/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.xml;

import brut.xml.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ResXmlUtils {
    private static final Logger LOGGER = Logger.getLogger(ResXmlUtils.class.getName());

    private ResXmlUtils() {
    }

    public static void removeApplicationDebugTag(File file) {
        try {
            Document doc = XmlUtils.loadDocument((File)file);
            Node application = doc.getElementsByTagName("application").item(0);
            NamedNodeMap attrs = application.getAttributes();
            boolean changed = false;
            Node debugAttr = attrs.getNamedItem("android:debuggable");
            if (debugAttr != null) {
                attrs.removeNamedItem("android:debuggable");
                changed = true;
            }
            if (changed) {
                XmlUtils.saveDocument((Document)doc, (File)file);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            // empty catch block
        }
    }

    public static void setApplicationDebugTagTrue(File file) {
        try {
            Document doc = XmlUtils.loadDocument((File)file);
            Node application = doc.getElementsByTagName("application").item(0);
            NamedNodeMap attrs = application.getAttributes();
            boolean changed = false;
            Node debugAttr = attrs.getNamedItem("android:debuggable");
            if (debugAttr == null) {
                debugAttr = doc.createAttribute("android:debuggable");
                debugAttr.setNodeValue("true");
                attrs.setNamedItem(debugAttr);
                changed = true;
            } else if (!debugAttr.getNodeValue().equals("true")) {
                debugAttr.setNodeValue("true");
                changed = true;
            }
            if (changed) {
                XmlUtils.saveDocument((Document)doc, (File)file);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            // empty catch block
        }
    }

    public static void setNetworkSecurityConfig(File file) {
        try {
            Document doc = XmlUtils.loadDocument((File)file);
            Node application = doc.getElementsByTagName("application").item(0);
            NamedNodeMap attrs = application.getAttributes();
            boolean changed = false;
            Node netSecConfAttr = attrs.getNamedItem("android:networkSecurityConfig");
            if (netSecConfAttr == null) {
                netSecConfAttr = doc.createAttribute("android:networkSecurityConfig");
                netSecConfAttr.setNodeValue("@xml/network_security_config");
                attrs.setNamedItem(netSecConfAttr);
                changed = true;
            } else if (!netSecConfAttr.getNodeValue().equals("@xml/network_security_config")) {
                netSecConfAttr.setNodeValue("@xml/network_security_config");
                changed = true;
            }
            if (changed) {
                XmlUtils.saveDocument((Document)doc, (File)file);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            // empty catch block
        }
    }

    public static void modNetworkSecurityConfig(File file) {
        try {
            Element trustAnchors;
            Element baseConfig;
            Document doc;
            if (file.exists()) {
                doc = XmlUtils.loadDocument((File)file);
                doc.getDocumentElement().normalize();
            } else {
                doc = XmlUtils.newDocument();
            }
            boolean changed = false;
            Element root = (Element)doc.getElementsByTagName("network-security-config").item(0);
            if (root == null) {
                root = doc.createElement("network-security-config");
                doc.appendChild(root);
                changed = true;
            }
            if ((baseConfig = (Element)root.getElementsByTagName("base-config").item(0)) == null) {
                baseConfig = doc.createElement("base-config");
                root.appendChild(baseConfig);
                changed = true;
            }
            if ((trustAnchors = (Element)baseConfig.getElementsByTagName("trust-anchors").item(0)) == null) {
                trustAnchors = doc.createElement("trust-anchors");
                baseConfig.appendChild(trustAnchors);
                changed = true;
            }
            NodeList certificates = trustAnchors.getElementsByTagName("certificates");
            boolean hasSystemCert = false;
            boolean hasUserCert = false;
            for (int i = 0; i < certificates.getLength(); ++i) {
                Element cert = (Element)certificates.item(i);
                String src = cert.getAttribute("src");
                if (src.equals("system")) {
                    hasSystemCert = true;
                    continue;
                }
                if (!src.equals("user")) continue;
                hasUserCert = true;
            }
            if (!hasSystemCert) {
                Element certSystem = doc.createElement("certificates");
                certSystem.setAttribute("src", "system");
                trustAnchors.appendChild(certSystem);
                changed = true;
            }
            if (!hasUserCert) {
                Element certUser = doc.createElement("certificates");
                certUser.setAttribute("src", "user");
                trustAnchors.appendChild(certUser);
                changed = true;
            }
            if (changed) {
                XmlUtils.saveDocument((Document)doc, (File)file);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            // empty catch block
        }
    }

    public static void removeManifestVersions(File file) {
        try {
            Node versionNameAttr;
            Document doc = XmlUtils.loadDocument((File)file);
            Node manifest = doc.getFirstChild();
            NamedNodeMap attrs = manifest.getAttributes();
            boolean changed = false;
            Node versionCodeAttr = attrs.getNamedItem("android:versionCode");
            if (versionCodeAttr != null) {
                attrs.removeNamedItem("android:versionCode");
                changed = true;
            }
            if ((versionNameAttr = attrs.getNamedItem("android:versionName")) != null) {
                attrs.removeNamedItem("android:versionName");
                changed = true;
            }
            if (changed) {
                XmlUtils.saveDocument((Document)doc, (File)file);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            // empty catch block
        }
    }

    public static void renameManifestPackage(File file, String packageOriginal) {
        try {
            Document doc = XmlUtils.loadDocument((File)file);
            Node manifest = doc.getFirstChild();
            NamedNodeMap attrs = manifest.getAttributes();
            boolean changed = false;
            Node packageAttr = attrs.getNamedItem("package");
            if (!packageAttr.getNodeValue().equals(packageOriginal)) {
                packageAttr.setNodeValue(packageOriginal);
                changed = true;
            }
            if (changed) {
                XmlUtils.saveDocument((Document)doc, (File)file);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            // empty catch block
        }
    }

    public static String[] pullManifestFeatureFlags(File file) {
        try {
            Document doc = XmlUtils.loadDocument((File)file, (boolean)true);
            String expression = "/manifest//@android:featureFlag";
            NodeList nodes = (NodeList)XmlUtils.evaluateXPath((Document)doc, (String)expression, NodeList.class);
            String[] featureFlags = new String[nodes.getLength()];
            for (int i = 0; i < featureFlags.length; ++i) {
                featureFlags[i] = nodes.item(i).getNodeValue();
            }
            return featureFlags;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ignored) {
            return null;
        }
    }

    public static void fixingPublicAttrsInProviderAttributes(File file) {
        try {
            int i;
            Document doc = XmlUtils.loadDocument((File)file, (boolean)true);
            boolean changed = false;
            String expression = "/manifest/application/provider/@android:authorities";
            NodeList nodes = (NodeList)XmlUtils.evaluateXPath((Document)doc, (String)expression, NodeList.class);
            for (i = 0; i < nodes.getLength(); ++i) {
                if (!ResXmlUtils.replaceStringReference(file, nodes.item(i))) continue;
                changed = true;
            }
            expression = "/manifest/application/activity/intent-filter/data/@android:scheme";
            nodes = (NodeList)XmlUtils.evaluateXPath((Document)doc, (String)expression, NodeList.class);
            for (i = 0; i < nodes.getLength(); ++i) {
                if (!ResXmlUtils.replaceStringReference(file, nodes.item(i))) continue;
                changed = true;
            }
            if (changed) {
                XmlUtils.saveDocument((Document)doc, (File)file);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException exception) {
            // empty catch block
        }
    }

    private static boolean replaceStringReference(File file, Node node) {
        String replacement = ResXmlUtils.pullValueFromStrings(file.getParentFile(), node.getNodeValue());
        if (replacement == null) {
            return false;
        }
        node.setNodeValue(replacement);
        return true;
    }

    public static String pullValueFromStrings(File apkDir, String key) {
        return ResXmlUtils.pullValueFromXml(new File(apkDir, "res/values/strings.xml"), "string", key);
    }

    public static String pullValueFromIntegers(File apkDir, String key) {
        return ResXmlUtils.pullValueFromXml(new File(apkDir, "res/values/integers.xml"), "integer", key);
    }

    private static String pullValueFromXml(File file, String type, String key) {
        if (!file.isFile() || key == null || !key.contains("@")) {
            return null;
        }
        key = key.replace("@" + type + "/", "");
        try {
            Document doc = XmlUtils.loadDocument((File)file);
            String expression = String.format("/resources/%s[@name='%s']/text()", type, key);
            return (String)XmlUtils.evaluateXPath((Document)doc, (String)expression, String.class);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ignored) {
            return null;
        }
    }
}

