/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ResResSpec {
    private static final Set<String> EMPTY_RESOURCE_NAMES = Sets.newHashSet((Object[])new String[]{"0_resource_name_obfuscated", "(name removed)"});
    private final ResID mId;
    private final String mName;
    private final ResPackage mPackage;
    private final ResTypeSpec mType;
    private final Map<ResConfigFlags, ResResource> mResources;

    public ResResSpec(ResID id, String name, ResPackage pkg, ResTypeSpec type) {
        this.mId = id;
        if (name == null || name.isEmpty() || EMPTY_RESOURCE_NAMES.contains(name)) {
            name = "APKTOOL_DUMMYVAL_" + id;
        } else if (type.getResSpecUnsafe(name) != null) {
            name = String.format("APKTOOL_DUPLICATE_%s_%s", type, id);
        }
        this.mName = name;
        this.mPackage = pkg;
        this.mType = type;
        this.mResources = new LinkedHashMap<ResConfigFlags, ResResource>();
    }

    public Set<ResResource> listResources() {
        return new LinkedHashSet<ResResource>(this.mResources.values());
    }

    public ResResource getResource(ResType config) throws AndrolibException {
        return this.getResource(config.getFlags());
    }

    public ResResource getResource(ResConfigFlags config) throws AndrolibException {
        ResResource res = this.mResources.get(config);
        if (res == null) {
            throw new UndefinedResObjectException(String.format("resource: spec=%s, config=%s", this, config));
        }
        return res;
    }

    public ResResource getDefaultResource() throws AndrolibException {
        return this.getResource(new ResConfigFlags());
    }

    public boolean hasDefaultResource() {
        return this.mResources.containsKey(new ResConfigFlags());
    }

    public String getFullName(ResPackage relativeToPackage, boolean excludeType) {
        return this.getFullName(this.getPackage().equals(relativeToPackage), excludeType);
    }

    public String getFullName(boolean excludePackage, boolean excludeType) {
        return (excludePackage ? "" : this.getPackage().getName() + ":") + (excludeType ? "" : this.getType().getName() + "/") + this.getName();
    }

    public ResID getId() {
        return this.mId;
    }

    public String getName() {
        return StringUtils.replace((String)this.mName, (String)"\"", (String)"q");
    }

    public ResPackage getPackage() {
        return this.mPackage;
    }

    public ResTypeSpec getType() {
        return this.mType;
    }

    public boolean isDummyResSpec() {
        return this.getName().startsWith("APKTOOL_DUMMY_");
    }

    public void addResource(ResResource res) throws AndrolibException {
        this.addResource(res, false);
    }

    public void addResource(ResResource res, boolean overwrite) throws AndrolibException {
        ResConfigFlags flags = res.getConfig().getFlags();
        if (this.mResources.put(flags, res) != null && !overwrite) {
            throw new AndrolibException(String.format("Multiple resources: spec=%s, config=%s", this, flags));
        }
    }

    public String toString() {
        return this.mId + " " + this.mType + "/" + this.mName;
    }
}

