/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.exceptions.AndrolibException;
import com.android.tools.smali.baksmali.Baksmali;
import com.android.tools.smali.baksmali.BaksmaliOptions;
import com.android.tools.smali.dexlib2.DexFileFactory;
import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.analysis.InlineMethodResolver;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedOdexFile;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.android.tools.smali.dexlib2.iface.MultiDexContainer;
import java.io.File;
import java.io.IOException;

public class SmaliDecoder {
    private final File mApkFile;
    private final String mDexName;
    private final boolean mBakDeb;
    private final int mApiLevel;

    public SmaliDecoder(File apkFile, String dexName, boolean bakDeb, int apiLevel) {
        this.mApkFile = apkFile;
        this.mDexName = dexName;
        this.mBakDeb = bakDeb;
        this.mApiLevel = apiLevel;
    }

    public DexFile decode(File outDir) throws AndrolibException {
        try {
            MultiDexContainer container;
            MultiDexContainer.DexEntry dexEntry;
            BaksmaliOptions options = new BaksmaliOptions();
            options.deodex = false;
            options.implicitReferences = false;
            options.parameterRegisters = true;
            options.localsDirective = true;
            options.sequentialLabels = true;
            options.debugInfo = this.mBakDeb;
            options.codeOffsets = false;
            options.accessorComments = false;
            options.registerInfo = 0;
            options.inlineResolver = null;
            int jobs = Runtime.getRuntime().availableProcessors();
            if (jobs > 6) {
                jobs = 6;
            }
            if ((dexEntry = (container = DexFileFactory.loadDexContainer((File)this.mApkFile, this.mApiLevel > 0 ? Opcodes.forApi((int)this.mApiLevel) : null)).getDexEntryNames().size() == 1 ? container.getEntry((String)container.getDexEntryNames().get(0)) : container.getEntry(this.mDexName)) == null) {
                dexEntry = container.getEntry((String)container.getDexEntryNames().get(0));
            }
            assert (dexEntry != null);
            DexBackedDexFile dexFile = (DexBackedDexFile)dexEntry.getDexFile();
            if (dexFile.supportsOptimizedOpcodes()) {
                throw new AndrolibException("Warning: You are disassembling an odex file without deodexing it.");
            }
            if (dexFile instanceof DexBackedOdexFile) {
                options.inlineResolver = InlineMethodResolver.createInlineMethodResolver((int)((DexBackedOdexFile)dexFile).getOdexVersion());
            }
            Baksmali.disassembleDexFile((DexFile)dexFile, (File)outDir, (int)jobs, (BaksmaliOptions)options);
            return dexFile;
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not baksmali file: " + this.mDexName, ex);
        }
    }
}

