/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFind9PatchChunkException;
import brut.androlib.res.data.ninepatch.NinePatchData;
import brut.androlib.res.data.ninepatch.OpticalInset;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.util.ExtDataInput;
import brut.util.ExtDataInputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class Res9patchStreamDecoder
implements ResStreamDecoder {
    private static final int NP_CHUNK_TYPE = 1852855395;
    private static final int OI_CHUNK_TYPE = 1852853346;
    private static final int NP_COLOR = -16777216;
    private static final int OI_COLOR = -65536;

    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)in);
            if (data.length == 0) {
                return;
            }
            BufferedImage im = ImageIO.read(new ByteArrayInputStream(data));
            int w = im.getWidth();
            int h = im.getHeight();
            BufferedImage im2 = new BufferedImage(w + 2, h + 2, 2);
            if (im.getType() == 0) {
                WritableRaster srcRaster = im.getRaster();
                WritableRaster dstRaster = im2.getRaster();
                int[] gray = null;
                int[] alpha = null;
                for (int y = 0; y < im.getHeight(); ++y) {
                    gray = srcRaster.getSamples(0, y, w, 1, 0, gray);
                    alpha = srcRaster.getSamples(0, y, w, 1, 1, alpha);
                    dstRaster.setSamples(1, y + 1, w, 1, 0, gray);
                    dstRaster.setSamples(1, y + 1, w, 1, 1, gray);
                    dstRaster.setSamples(1, y + 1, w, 1, 2, gray);
                    dstRaster.setSamples(1, y + 1, w, 1, 3, alpha);
                }
            } else {
                im2.createGraphics().drawImage(im, 1, 1, w, h, null);
            }
            NinePatchData np = this.getNinePatch(data);
            this.drawHLine(im2, h + 1, np.padLeft + 1, w - np.padRight);
            this.drawVLine(im2, w + 1, np.padTop + 1, h - np.padBottom);
            int[] xDivs = np.xDivs;
            if (xDivs.length == 0) {
                this.drawHLine(im2, 0, 1, w);
            } else {
                for (int i = 0; i < xDivs.length; i += 2) {
                    this.drawHLine(im2, 0, xDivs[i] + 1, xDivs[i + 1]);
                }
            }
            int[] yDivs = np.yDivs;
            if (yDivs.length == 0) {
                this.drawVLine(im2, 0, 1, h);
            } else {
                for (int i = 0; i < yDivs.length; i += 2) {
                    this.drawVLine(im2, 0, yDivs[i] + 1, yDivs[i + 1]);
                }
            }
            try {
                int y;
                int x;
                int i;
                OpticalInset oi = this.getOpticalInset(data);
                for (i = 0; i < oi.layoutBoundsLeft; ++i) {
                    x = 1 + i;
                    im2.setRGB(x, h + 1, -65536);
                }
                for (i = 0; i < oi.layoutBoundsRight; ++i) {
                    x = w - i;
                    im2.setRGB(x, h + 1, -65536);
                }
                for (i = 0; i < oi.layoutBoundsTop; ++i) {
                    y = 1 + i;
                    im2.setRGB(w + 1, y, -65536);
                }
                for (i = 0; i < oi.layoutBoundsBottom; ++i) {
                    y = h - i;
                    im2.setRGB(w + 1, y, -65536);
                }
            }
            catch (CantFind9PatchChunkException cantFind9PatchChunkException) {
                // empty catch block
            }
            ImageIO.write((RenderedImage)im2, "png", out);
        }
        catch (IOException | NullPointerException ex) {
            throw new AndrolibException(ex);
        }
    }

    private NinePatchData getNinePatch(byte[] data) throws AndrolibException, IOException {
        ExtDataInputStream in = ExtDataInputStream.bigEndian((InputStream)new ByteArrayInputStream(data));
        this.find9patchChunk((DataInput)in, 1852855395);
        return NinePatchData.decode((ExtDataInput)in);
    }

    private OpticalInset getOpticalInset(byte[] data) throws AndrolibException, IOException {
        ExtDataInputStream in = ExtDataInputStream.bigEndian((InputStream)new ByteArrayInputStream(data));
        this.find9patchChunk((DataInput)in, 1852853346);
        return OpticalInset.decode((ExtDataInput)in);
    }

    private void find9patchChunk(DataInput in, int magic) throws AndrolibException, IOException {
        in.skipBytes(8);
        while (true) {
            int size;
            try {
                size = in.readInt();
            }
            catch (IOException ex) {
                throw new CantFind9PatchChunkException("Could not find nine patch chunk", ex);
            }
            if (in.readInt() == magic) {
                return;
            }
            in.skipBytes(size + 4);
        }
    }

    private void drawHLine(BufferedImage im, int y, int x1, int x2) {
        for (int x = x1; x <= x2; ++x) {
            im.setRGB(x, y, -16777216);
        }
    }

    private void drawVLine(BufferedImage im, int x, int y1, int y2) {
        for (int y = y1; y <= y2; ++y) {
            im.setRGB(x, y, -16777216);
        }
    }
}

