/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFindFrameworkResException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.axml.NamespaceStack;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.decoder.StringBlock;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInput;
import brut.util.ExtDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AXmlResourceParser
implements XmlResourceParser {
    private static final Logger LOGGER = Logger.getLogger(AXmlResourceParser.class.getName());
    private static final String E_NOT_SUPPORTED = "Method is not supported.";
    private static final String ANDROID_RES_NS_AUTO = "http://schemas.android.com/apk/res-auto";
    public static final String ANDROID_RES_NS = "http://schemas.android.com/apk/res/android";
    private static final int ATTRIBUTE_IX_NAMESPACE_URI = 0;
    private static final int ATTRIBUTE_IX_NAME = 1;
    private static final int ATTRIBUTE_IX_VALUE_STRING = 2;
    private static final int ATTRIBUTE_IX_VALUE_TYPE = 3;
    private static final int ATTRIBUTE_IX_VALUE_DATA = 4;
    private static final int ATTRIBUTE_LENGTH = 5;
    private static final int PRIVATE_PKG_ID = 127;
    private final ResTable mResTable;
    private final NamespaceStack mNamespaces;
    private boolean mIsOperational;
    private ExtDataInputStream mIn;
    private StringBlock mStringBlock;
    private int[] mResourceIds;
    private boolean mDecreaseDepth;
    private AndrolibException mFirstError;
    private int mEvent;
    private int mLineNumber;
    private int mNameIndex;
    private int mNamespaceIndex;
    private int[] mAttributes;
    private int mIdIndex;
    private int mClassIndex;
    private int mStyleIndex;

    public AXmlResourceParser(ResTable resTable) {
        this.mResTable = resTable;
        this.mNamespaces = new NamespaceStack();
        this.resetEventInfo();
    }

    public AndrolibException getFirstError() {
        return this.mFirstError;
    }

    public ResTable getResTable() {
        return this.mResTable;
    }

    public void open(InputStream stream) {
        this.close();
        if (stream != null) {
            this.mIn = ExtDataInputStream.littleEndian((InputStream)stream);
        }
    }

    @Override
    public void close() {
        if (!this.mIsOperational) {
            return;
        }
        this.mIsOperational = false;
        this.mIn = null;
        this.mStringBlock = null;
        this.mResourceIds = null;
        this.mNamespaces.reset();
        this.resetEventInfo();
    }

    public int next() throws XmlPullParserException, IOException {
        if (this.mIn == null) {
            throw new XmlPullParserException("Parser is not opened.", (XmlPullParser)this, null);
        }
        try {
            this.doNext();
            return this.mEvent;
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("Expected start or end tag.", (XmlPullParser)this, null);
        }
        return eventType;
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException("Parser must be on START_TAG to read next text.", (XmlPullParser)this, null);
        }
        int eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 3) {
                throw new XmlPullParserException("Event TEXT must be immediately followed by END_TAG.", (XmlPullParser)this, null);
            }
            return result;
        }
        if (eventType == 3) {
            return "";
        }
        throw new XmlPullParserException("Parser must be on START_TAG or TEXT to read text.", (XmlPullParser)this, null);
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException {
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException(TYPES[type] + " is expected.", (XmlPullParser)this, null);
        }
    }

    public int getDepth() {
        return this.mNamespaces.getDepth() - 1;
    }

    public int getEventType() {
        return this.mEvent;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }

    public String getName() {
        if (this.mNameIndex == -1 || this.mEvent != 2 && this.mEvent != 3) {
            return null;
        }
        return this.mStringBlock.getString(this.mNameIndex);
    }

    public String getText() {
        if (this.mNameIndex == -1 || this.mEvent != 4) {
            return null;
        }
        return this.mStringBlock.getString(this.mNameIndex);
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        String text = this.getText();
        if (text == null) {
            return null;
        }
        holderForStartAndLength[0] = 0;
        holderForStartAndLength[1] = text.length();
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        return chars;
    }

    public String getNamespace() {
        return this.mStringBlock.getString(this.mNamespaceIndex);
    }

    public String getPrefix() {
        int prefix = this.mNamespaces.findPrefix(this.mNamespaceIndex);
        return this.mStringBlock.getString(prefix);
    }

    @Override
    public String getPositionDescription() {
        return "XML line #" + this.getLineNumber();
    }

    public int getNamespaceCount(int depth) {
        return this.mNamespaces.getAccumulatedCount(depth);
    }

    public String getNamespacePrefix(int pos) {
        int prefix = this.mNamespaces.getPrefix(pos);
        return this.mStringBlock.getString(prefix);
    }

    public String getNamespaceUri(int pos) {
        int uri = this.mNamespaces.getUri(pos);
        return this.mStringBlock.getString(uri);
    }

    @Override
    public String getClassAttribute() {
        if (this.mClassIndex == -1) {
            return null;
        }
        int offset = this.getAttributeOffset(this.mClassIndex);
        int value = this.mAttributes[offset + 2];
        return this.mStringBlock.getString(value);
    }

    @Override
    public String getIdAttribute() {
        if (this.mIdIndex == -1) {
            return null;
        }
        int offset = this.getAttributeOffset(this.mIdIndex);
        int value = this.mAttributes[offset + 2];
        return this.mStringBlock.getString(value);
    }

    @Override
    public int getIdAttributeResourceValue(int defaultValue) {
        if (this.mIdIndex == -1) {
            return defaultValue;
        }
        int offset = this.getAttributeOffset(this.mIdIndex);
        int valueType = this.mAttributes[offset + 3];
        if (valueType != 1) {
            return defaultValue;
        }
        return this.mAttributes[offset + 4];
    }

    @Override
    public int getStyleAttribute() {
        if (this.mStyleIndex == -1) {
            return 0;
        }
        int offset = this.getAttributeOffset(this.mStyleIndex);
        return this.mAttributes[offset + 4];
    }

    @Override
    public int getAttributeCount() {
        if (this.mEvent != 2) {
            return -1;
        }
        return this.mAttributes.length / 5;
    }

    public String getAttributeNamespace(int index) {
        int offset = this.getAttributeOffset(index);
        int namespace = this.mAttributes[offset + 0];
        ResID resId = new ResID(this.getAttributeNameResource(index));
        if (namespace == -1 && resId.getPackageId() == 1) {
            return ANDROID_RES_NS;
        }
        if (namespace == -1) {
            return "";
        }
        String value = this.mStringBlock.getString(namespace);
        if (value == null || value.isEmpty()) {
            if (resId.getPackageId() == 127) {
                return this.getNonDefaultNamespaceUri(offset);
            }
            return ANDROID_RES_NS;
        }
        return value;
    }

    public String decodeFromResourceId(int attrResId) throws AndrolibException {
        if (attrResId != 0) {
            try {
                ResResSpec resResSpec = this.mResTable.getResSpec(attrResId);
                if (resResSpec != null) {
                    return resResSpec.getName();
                }
            }
            catch (CantFindFrameworkResException | UndefinedResObjectException androlibException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getNonDefaultNamespaceUri(int offset) {
        String prefix = this.mStringBlock.getString(this.mNamespaces.getPrefix(offset));
        if (prefix == null) {
            return ANDROID_RES_NS_AUTO;
        }
        return this.mStringBlock.getString(this.mNamespaces.getUri(offset));
    }

    public String getAttributePrefix(int index) {
        int offset = this.getAttributeOffset(index);
        int uri = this.mAttributes[offset + 0];
        int prefix = this.mNamespaces.findPrefix(uri);
        if (prefix == -1) {
            return "";
        }
        return this.mStringBlock.getString(prefix);
    }

    @Override
    public String getAttributeName(int index) {
        String resourceMapValue;
        int offset = this.getAttributeOffset(index);
        int name = this.mAttributes[offset + 1];
        if (name == -1) {
            return "";
        }
        String stringBlockValue = this.mStringBlock.getString(name);
        int attrResId = this.getAttributeNameResource(index);
        try {
            resourceMapValue = this.decodeFromResourceId(attrResId);
        }
        catch (AndrolibException ignored) {
            resourceMapValue = null;
        }
        if (resourceMapValue != null) {
            return resourceMapValue;
        }
        if (stringBlockValue != null) {
            return stringBlockValue;
        }
        return "APKTOOL_MISSING_" + Integer.toHexString(attrResId);
    }

    @Override
    public int getAttributeNameResource(int index) {
        int offset = this.getAttributeOffset(index);
        int name = this.mAttributes[offset + 1];
        if (this.mResourceIds == null || name < 0 || name >= this.mResourceIds.length) {
            return 0;
        }
        return this.mResourceIds[name];
    }

    @Override
    public int getAttributeValueType(int index) {
        int offset = this.getAttributeOffset(index);
        return this.mAttributes[offset + 3];
    }

    @Override
    public int getAttributeValueData(int index) {
        int offset = this.getAttributeOffset(index);
        return this.mAttributes[offset + 4];
    }

    @Override
    public String getAttributeValue(int index) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.mAttributes[offset + 3];
        int valueData = this.mAttributes[offset + 4];
        int valueRaw = this.mAttributes[offset + 2];
        try {
            String stringBlockValue = valueRaw != -1 ? ResXmlEncoders.escapeXmlChars(this.mStringBlock.getString(valueRaw)) : null;
            String resourceMapValue = null;
            if (valueType == 1 || valueType == 7 || valueType == 2 || valueType == 8) {
                resourceMapValue = this.decodeFromResourceId(valueData);
            }
            String value = AXmlResourceParser.getPreferredString(stringBlockValue, resourceMapValue);
            int attrResId = this.getAttributeNameResource(index);
            ResScalarValue resValue = this.mResTable.getCurrentResPackage().getValueFactory().factory(valueType, valueData, value);
            String decoded = null;
            if (attrResId > 0) {
                try {
                    ResAttr attr = (ResAttr)this.mResTable.getResSpec(attrResId).getDefaultResource().getValue();
                    decoded = attr.convertToResXmlFormat(resValue);
                }
                catch (UndefinedResObjectException | ClassCastException object) {
                    // empty catch block
                }
            }
            return decoded != null ? decoded : resValue.encodeAsResXmlAttr();
        }
        catch (AndrolibException ex) {
            this.setFirstError(ex);
            LOGGER.log(Level.WARNING, String.format("Could not decode attr value, using undecoded value instead: ns=%s, name=%s, value=0x%08x", this.getAttributePrefix(index), this.getAttributeName(index), valueData), (Throwable)((Object)ex));
            return TypedValue.coerceToString(valueType, valueData);
        }
    }

    @Override
    public boolean getAttributeBooleanValue(int index, boolean defaultValue) {
        return this.getAttributeIntValue(index, defaultValue ? 1 : 0) != 0;
    }

    @Override
    public float getAttributeFloatValue(int index, float defaultValue) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.mAttributes[offset + 3];
        if (valueType != 4) {
            return defaultValue;
        }
        return Float.intBitsToFloat(this.mAttributes[offset + 4]);
    }

    @Override
    public int getAttributeIntValue(int index, int defaultValue) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.mAttributes[offset + 3];
        if (valueType < 16 || valueType > 31) {
            return defaultValue;
        }
        return this.mAttributes[offset + 4];
    }

    @Override
    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        return this.getAttributeIntValue(index, defaultValue);
    }

    @Override
    public int getAttributeResourceValue(int index, int defaultValue) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.mAttributes[offset + 3];
        if (valueType != 1) {
            return defaultValue;
        }
        return this.mAttributes[offset + 4];
    }

    @Override
    public String getAttributeValue(String namespace, String attribute) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return "";
        }
        return this.getAttributeValue(index);
    }

    @Override
    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeBooleanValue(index, defaultValue);
    }

    @Override
    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeFloatValue(index, defaultValue);
    }

    @Override
    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeIntValue(index, defaultValue);
    }

    @Override
    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeUnsignedIntValue(index, defaultValue);
    }

    @Override
    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeResourceValue(index, defaultValue);
    }

    @Override
    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        return 0;
    }

    @Override
    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        return 0;
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public void setInput(InputStream stream, String inputEncoding) {
        this.open(stream);
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        throw new XmlPullParserException(E_NOT_SUPPORTED);
    }

    public String getInputEncoding() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean isEmptyElementTag() {
        return false;
    }

    public boolean isWhitespace() {
        return false;
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
        throw new XmlPullParserException(E_NOT_SUPPORTED);
    }

    public String getNamespace(String prefix) {
        throw new RuntimeException(E_NOT_SUPPORTED);
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setProperty(String name, Object value) throws XmlPullParserException {
        throw new XmlPullParserException(E_NOT_SUPPORTED);
    }

    public boolean getFeature(String name) {
        return false;
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        throw new XmlPullParserException(E_NOT_SUPPORTED);
    }

    private int getAttributeOffset(int index) {
        if (this.mEvent != 2) {
            throw new IndexOutOfBoundsException("Current event is not START_TAG.");
        }
        int offset = index * 5;
        if (offset >= this.mAttributes.length) {
            throw new IndexOutOfBoundsException("Invalid attribute index (" + index + ").");
        }
        return offset;
    }

    private int findAttribute(String namespace, String attribute) {
        if (this.mStringBlock == null || attribute == null) {
            return -1;
        }
        int name = this.mStringBlock.find(attribute);
        if (name == -1) {
            return -1;
        }
        int uri = namespace != null ? this.mStringBlock.find(namespace) : -1;
        for (int offset = 0; offset < this.mAttributes.length; offset += 5) {
            if (name != this.mAttributes[offset + 1] || uri != -1 && uri != this.mAttributes[offset + 0]) continue;
            return offset / 5;
        }
        return -1;
    }

    private static String getPreferredString(String stringBlockValue, String resourceMapValue) {
        String value = stringBlockValue;
        if (stringBlockValue != null && resourceMapValue != null) {
            int slashPos = stringBlockValue.lastIndexOf("/");
            int colonPos = stringBlockValue.lastIndexOf(":");
            if (slashPos != -1) {
                if (colonPos == -1) {
                    String type = stringBlockValue.substring(0, slashPos);
                    value = type + "/" + resourceMapValue;
                }
            } else if (!stringBlockValue.equals(resourceMapValue)) {
                value = resourceMapValue;
            }
        }
        return value;
    }

    private void resetEventInfo() {
        this.mEvent = -1;
        this.mLineNumber = -1;
        this.mNameIndex = -1;
        this.mNamespaceIndex = -1;
        this.mAttributes = null;
        this.mIdIndex = -1;
        this.mClassIndex = -1;
        this.mStyleIndex = -1;
    }

    private void doNext() throws IOException {
        block19: {
            if (this.mStringBlock == null) {
                this.mIn.skipInt();
                this.mIn.skipInt();
                this.mStringBlock = StringBlock.readWithChunk((ExtDataInput)this.mIn);
                this.mNamespaces.increaseDepth();
                this.mIsOperational = true;
            }
            if (this.mEvent == 1) {
                return;
            }
            int event = this.mEvent;
            this.resetEventInfo();
            while (true) {
                int chunkSize;
                int chunkType;
                if (this.mDecreaseDepth) {
                    this.mDecreaseDepth = false;
                    this.mNamespaces.decreaseDepth();
                }
                if (event == 3 && this.mNamespaces.getDepth() == 1 && this.mNamespaces.getCurrentCount() == 0) {
                    this.mEvent = 1;
                    break block19;
                }
                if (this.mIn.available() == 0) {
                    LOGGER.warning(String.format("AXML hit unexpected end of file at byte: 0x%X", this.mIn.position()));
                    this.mEvent = 1;
                    break block19;
                }
                short headerSize = 0;
                if (event == 0) {
                    chunkType = 258;
                } else {
                    chunkType = this.mIn.readShort();
                    headerSize = this.mIn.readShort();
                }
                if (chunkType == 384) {
                    chunkSize = this.mIn.readInt();
                    if (chunkSize < 8 || chunkSize % 4 != 0) {
                        throw new IOException("Invalid resource ids size (" + chunkSize + ").");
                    }
                    this.mResourceIds = this.mIn.readIntArray(chunkSize / 4 - 2);
                    continue;
                }
                if (chunkType < 256 || chunkType > 383) {
                    chunkSize = this.mIn.readInt();
                    this.mIn.skipBytes(chunkSize - 8);
                    LOGGER.warning(String.format("Unknown chunk type at: (0x%08x) skipping...", this.mIn.position()));
                    break block19;
                }
                if (chunkType == 258 && event == -1) {
                    this.mEvent = 0;
                    break block19;
                }
                this.mIn.skipInt();
                this.mLineNumber = this.mIn.readInt();
                this.mIn.skipInt();
                if (chunkType == 256 || chunkType == 257) {
                    if (chunkType == 256) {
                        int prefix = this.mIn.readInt();
                        int uri = this.mIn.readInt();
                        this.mNamespaces.push(prefix, uri);
                    } else {
                        this.mIn.skipInt();
                        this.mIn.skipInt();
                        this.mNamespaces.pop();
                    }
                    if (headerSize <= 16) continue;
                    int bytesToSkip = headerSize - 16;
                    LOGGER.warning(String.format("AXML header larger than 0x10 bytes, skipping %d bytes.", bytesToSkip));
                    this.mIn.skipBytes(bytesToSkip);
                    continue;
                }
                if (chunkType == 258) {
                    this.mNamespaceIndex = this.mIn.readInt();
                    this.mNameIndex = this.mIn.readInt();
                    this.mIn.skipShort();
                    short attributeSize = this.mIn.readShort();
                    short attributeCount = this.mIn.readShort();
                    this.mIdIndex = this.mIn.readShort();
                    this.mClassIndex = this.mIn.readShort();
                    this.mStyleIndex = this.mIn.readShort();
                    this.mAttributes = this.mIn.readIntArray(attributeCount * 5);
                    for (int i = 3; i < this.mAttributes.length; i += 5) {
                        this.mAttributes[i] = this.mAttributes[i] >>> 24;
                    }
                    int byteAttrSizeRead = attributeCount * 5 * 4;
                    int byteAttrSizeReported = attributeSize * attributeCount;
                    if (byteAttrSizeRead < byteAttrSizeReported) {
                        int bytesToSkip = byteAttrSizeReported - byteAttrSizeRead;
                        this.mIn.skipBytes(bytesToSkip);
                        LOGGER.fine("Skipping " + bytesToSkip + " unknown bytes in attributes area.");
                    }
                    this.mNamespaces.increaseDepth();
                    this.mEvent = 2;
                    break block19;
                }
                if (chunkType == 259) {
                    this.mNamespaceIndex = this.mIn.readInt();
                    this.mNameIndex = this.mIn.readInt();
                    this.mEvent = 3;
                    this.mDecreaseDepth = true;
                    break block19;
                }
                if (chunkType == 260) break;
            }
            this.mNameIndex = this.mIn.readInt();
            this.mIn.skipInt();
            this.mIn.skipInt();
            this.mEvent = 4;
        }
    }

    private void setFirstError(AndrolibException error) {
        if (this.mFirstError == null) {
            this.mFirstError = error;
        }
    }
}

