/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.ninepatch;

import brut.util.ExtDataInput;
import java.io.IOException;

public class NinePatchData {
    public final int padLeft;
    public final int padRight;
    public final int padTop;
    public final int padBottom;
    public final int[] xDivs;
    public final int[] yDivs;

    public NinePatchData(int padLeft, int padRight, int padTop, int padBottom, int[] xDivs, int[] yDivs) {
        this.padLeft = padLeft;
        this.padRight = padRight;
        this.padTop = padTop;
        this.padBottom = padBottom;
        this.xDivs = xDivs;
        this.yDivs = yDivs;
    }

    public static NinePatchData decode(ExtDataInput in) throws IOException {
        in.skipBytes(1);
        byte numXDivs = in.readByte();
        byte numYDivs = in.readByte();
        in.skipBytes(1);
        in.skipBytes(8);
        int padLeft = in.readInt();
        int padRight = in.readInt();
        int padTop = in.readInt();
        int padBottom = in.readInt();
        in.skipBytes(4);
        int[] xDivs = in.readIntArray((int)numXDivs);
        int[] yDivs = in.readIntArray((int)numYDivs);
        return new NinePatchData(padLeft, padRight, padTop, padBottom, xDivs, yDivs);
    }
}

