/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.ApkDecoder;
import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.Framework;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.androlib.res.xml.ResXmlUtils;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ResTable {
    private static final Logger LOGGER = Logger.getLogger(ApkDecoder.class.getName());
    private final ApkInfo mApkInfo;
    private final Config mConfig;
    private final Map<Integer, ResPackage> mPackagesById;
    private final Map<String, ResPackage> mPackagesByName;
    private final Set<ResPackage> mMainPackages;
    private final Set<ResPackage> mFramePackages;
    private String mPackageRenamed;
    private String mPackageOriginal;
    private int mPackageId;
    private boolean mMainPkgLoaded;

    public ResTable(ApkInfo apkInfo, Config config) {
        this.mApkInfo = apkInfo;
        this.mConfig = config;
        this.mPackagesById = new HashMap<Integer, ResPackage>();
        this.mPackagesByName = new HashMap<String, ResPackage>();
        this.mMainPackages = new LinkedHashSet<ResPackage>();
        this.mFramePackages = new LinkedHashSet<ResPackage>();
    }

    public ApkInfo getApkInfo() {
        return this.mApkInfo;
    }

    public Config getConfig() {
        return this.mConfig;
    }

    public boolean isMainPkgLoaded() {
        return this.mMainPkgLoaded;
    }

    public ResResSpec getResSpec(int resId) throws AndrolibException {
        if (resId >> 24 == 0) {
            int pkgId = this.mPackageId == 0 ? 2 : this.mPackageId;
            resId = 0xFF000000 & pkgId << 24 | resId;
        }
        return this.getResSpec(new ResID(resId));
    }

    public ResResSpec getResSpec(ResID resId) throws AndrolibException {
        return this.getPackage(resId.getPackageId()).getResSpec(resId);
    }

    public Set<ResPackage> listMainPackages() {
        return this.mMainPackages;
    }

    public Set<ResPackage> listFramePackages() {
        return this.mFramePackages;
    }

    public ResPackage getPackage(int id) throws AndrolibException {
        ResPackage pkg = this.mPackagesById.get(id);
        if (pkg != null) {
            return pkg;
        }
        pkg = this.loadFrameworkPkg(id);
        this.addPackage(pkg, false);
        return pkg;
    }

    private ResPackage selectPkgWithMostResSpecs(ResPackage[] pkgs) {
        int id = 0;
        int value = 0;
        int index = 0;
        for (int i = 0; i < pkgs.length; ++i) {
            ResPackage resPackage = pkgs[i];
            if (resPackage.getResSpecCount() <= value || resPackage.getName().equals("android")) continue;
            value = resPackage.getResSpecCount();
            id = resPackage.getId();
            index = i;
        }
        return pkgs[id == 0 ? 0 : index];
    }

    public void loadMainPkg(File apkFile) throws AndrolibException {
        ResPackage pkg;
        LOGGER.info("Loading resource table...");
        ResPackage[] pkgs = this.loadResPackagesFromApk(apkFile, this.mConfig.isKeepBrokenResources());
        switch (pkgs.length) {
            case 0: {
                pkg = new ResPackage(this, 0, null);
                break;
            }
            case 1: {
                pkg = pkgs[0];
                break;
            }
            case 2: {
                LOGGER.warning("Skipping package group: " + pkgs[0].getName());
                pkg = pkgs[1];
                break;
            }
            default: {
                pkg = this.selectPkgWithMostResSpecs(pkgs);
            }
        }
        this.addPackage(pkg, true);
        this.mMainPkgLoaded = true;
    }

    private ResPackage loadFrameworkPkg(int id) throws AndrolibException {
        ResPackage pkg;
        Framework framework = new Framework(this.mConfig);
        File apkFile = framework.getApkFile(id, this.mConfig.getFrameworkTag());
        LOGGER.info("Loading resource table from file: " + apkFile);
        ResPackage[] pkgs = this.loadResPackagesFromApk(apkFile, true);
        if (pkgs.length > 1) {
            pkg = this.selectPkgWithMostResSpecs(pkgs);
        } else if (pkgs.length == 1) {
            pkg = pkgs[0];
        } else {
            throw new AndrolibException("Arsc files with zero packages");
        }
        if (pkg.getId() != id) {
            throw new AndrolibException("Expected pkg of id: " + id + ", got: " + pkg.getId());
        }
        return pkg;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ResPackage[] loadResPackagesFromApk(File apkFile, boolean keepBrokenResources) throws AndrolibException {
        try (ExtFile inFile = new ExtFile(apkFile);){
            ResPackage[] resPackageArray;
            try (BufferedInputStream in = new BufferedInputStream(inFile.getDirectory().getFileInput("resources.arsc"));){
                ARSCDecoder decoder = new ARSCDecoder(in, this, false, keepBrokenResources);
                resPackageArray = decoder.decode().getPackages();
            }
            return resPackageArray;
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not load resources.arsc from file: " + apkFile, ex);
        }
    }

    public ResPackage getHighestSpecPackage() throws AndrolibException {
        int id = 0;
        int value = 0;
        for (ResPackage resPackage : this.mPackagesById.values()) {
            if (resPackage.getResSpecCount() <= value || resPackage.getName().equals("android")) continue;
            id = resPackage.getId();
            value = resPackage.getResSpecCount();
        }
        return this.getPackage(id == 0 ? 1 : id);
    }

    public ResPackage getCurrentResPackage() throws AndrolibException {
        ResPackage pkg = this.mPackagesById.get(this.mPackageId);
        if (pkg != null) {
            return pkg;
        }
        if (this.mMainPackages.size() == 1) {
            return this.mMainPackages.iterator().next();
        }
        return this.getHighestSpecPackage();
    }

    public ResPackage getPackage(String name) throws AndrolibException {
        ResPackage pkg = this.mPackagesByName.get(name);
        if (pkg == null) {
            throw new UndefinedResObjectException("package: name=" + name);
        }
        return pkg;
    }

    public ResValue getValue(String pkg, String type, String name) throws AndrolibException {
        return this.getPackage(pkg).getType(type).getResSpec(name).getDefaultResource().getValue();
    }

    public void addPackage(ResPackage pkg, boolean main) throws AndrolibException {
        Integer id = pkg.getId();
        if (this.mPackagesById.containsKey(id)) {
            throw new AndrolibException("Multiple packages: id=" + id);
        }
        String name = pkg.getName();
        if (this.mPackagesByName.containsKey(name)) {
            throw new AndrolibException("Multiple packages: name=" + name);
        }
        this.mPackagesById.put(id, pkg);
        this.mPackagesByName.put(name, pkg);
        if (main) {
            this.mMainPackages.add(pkg);
        } else {
            this.mFramePackages.add(pkg);
        }
    }

    public void setPackageRenamed(String pkg) {
        this.mPackageRenamed = pkg;
    }

    public void setPackageOriginal(String pkg) {
        this.mPackageOriginal = pkg;
    }

    public void setPackageId(int id) {
        this.mPackageId = id;
    }

    public void setSharedLibrary(boolean flag) {
        this.mApkInfo.sharedLibrary = flag;
    }

    public void setSparseResources(boolean flag) {
        this.mApkInfo.sparseResources = flag;
    }

    public void setCompactEntries(boolean flag) {
        this.mApkInfo.compactEntries = flag;
    }

    public void addSdkInfo(String key, String value) {
        this.mApkInfo.sdkInfo.put(key, value);
    }

    public void setVersionName(String versionName) {
        this.mApkInfo.versionInfo.versionName = versionName;
    }

    public void setVersionCode(String versionCode) {
        this.mApkInfo.versionInfo.versionCode = versionCode;
    }

    public String getPackageRenamed() {
        return this.mPackageRenamed;
    }

    public String getPackageOriginal() {
        return this.mPackageOriginal;
    }

    public int getPackageId() {
        return this.mPackageId;
    }

    public boolean getSparseResources() {
        return this.mApkInfo.sparseResources;
    }

    private boolean isFrameworkApk() {
        for (ResPackage pkg : this.mMainPackages) {
            if (pkg.getId() <= 0 || pkg.getId() >= 64) continue;
            return true;
        }
        return false;
    }

    public void initApkInfo(ApkInfo apkInfo, File apkDir) throws AndrolibException {
        apkInfo.isFrameworkApk = this.isFrameworkApk();
        apkInfo.usesFramework = this.getUsesFramework();
        if (!this.mApkInfo.sdkInfo.isEmpty()) {
            this.updateSdkInfoFromResources(apkDir);
        }
        this.initPackageInfo();
        this.loadVersionName(apkDir);
    }

    private UsesFramework getUsesFramework() {
        UsesFramework info = new UsesFramework();
        Object[] ids = new Integer[this.mFramePackages.size()];
        int i = 0;
        for (ResPackage pkg : this.mFramePackages) {
            ids[i++] = pkg.getId();
        }
        Arrays.sort(ids);
        info.ids = Arrays.asList(ids);
        info.tag = this.mConfig.getFrameworkTag();
        return info;
    }

    private void updateSdkInfoFromResources(File apkDir) {
        String refValue;
        String maxSdkVersion;
        String refValue2;
        String targetSdkVersion;
        String refValue3;
        String minSdkVersion = this.mApkInfo.getMinSdkVersion();
        if (minSdkVersion != null && (refValue3 = ResXmlUtils.pullValueFromIntegers(apkDir, minSdkVersion)) != null) {
            this.mApkInfo.setMinSdkVersion(refValue3);
        }
        if ((targetSdkVersion = this.mApkInfo.getTargetSdkVersion()) != null && (refValue2 = ResXmlUtils.pullValueFromIntegers(apkDir, targetSdkVersion)) != null) {
            this.mApkInfo.setTargetSdkVersion(refValue2);
        }
        if ((maxSdkVersion = this.mApkInfo.getMaxSdkVersion()) != null && (refValue = ResXmlUtils.pullValueFromIntegers(apkDir, maxSdkVersion)) != null) {
            this.mApkInfo.setMaxSdkVersion(refValue);
        }
    }

    private void initPackageInfo() throws AndrolibException {
        int id;
        String original = this.getPackageOriginal();
        if (original == null || original.isEmpty()) {
            return;
        }
        String renamed = this.getPackageRenamed();
        if (renamed != null && !renamed.equals(original)) {
            this.mApkInfo.packageInfo.renameManifestPackage = renamed;
        }
        try {
            id = this.getPackage(renamed).getId();
        }
        catch (UndefinedResObjectException ex) {
            id = this.getPackageId();
        }
        this.mApkInfo.packageInfo.forcedPackageId = String.valueOf(id);
    }

    private void loadVersionName(File apkDir) {
        String versionName = this.mApkInfo.versionInfo.versionName;
        String refValue = ResXmlUtils.pullValueFromStrings(apkDir, versionName);
        if (refValue != null) {
            this.mApkInfo.versionInfo.versionName = refValue;
        }
    }
}

