/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.AndroidManifestPullStreamDecoder;
import brut.androlib.res.decoder.AndroidManifestResourceParser;
import brut.androlib.res.decoder.Res9patchStreamDecoder;
import brut.androlib.res.decoder.ResFileDecoder;
import brut.androlib.res.decoder.ResRawStreamDecoder;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.ResXmlPullStreamDecoder;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.androlib.res.xml.ResXmlUtils;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.xmlpull.MXSerializer;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlSerializer;

public class ResourcesDecoder {
    private static final Logger LOGGER = Logger.getLogger(ResourcesDecoder.class.getName());
    private static final Set<String> IGNORED_PACKAGES = Sets.newHashSet((Object[])new String[]{"android", "com.htc", "com.lge", "com.lge.internal", "yi", "flyme", "air.com.adobe.appentry", "FFFFFFFFFFFFFFFFFFFFFF"});
    private final ApkInfo mApkInfo;
    private final Config mConfig;
    private final ResTable mResTable;
    private final Map<String, String> mResFileMapping;

    public ResourcesDecoder(ApkInfo apkInfo, Config config) {
        this.mApkInfo = apkInfo;
        this.mConfig = config;
        this.mResTable = new ResTable(apkInfo, config);
        this.mResFileMapping = new HashMap<String, String>();
    }

    public ResTable getResTable() throws AndrolibException {
        if (!this.mApkInfo.hasManifest() && !this.mApkInfo.hasResources()) {
            throw new AndrolibException("Apk doesn't contain either AndroidManifest.xml file or resources.arsc file");
        }
        return this.mResTable;
    }

    public Map<String, String> getResFileMapping() {
        return this.mResFileMapping;
    }

    public void loadMainPkg() throws AndrolibException {
        this.mResTable.loadMainPkg((File)this.mApkInfo.getApkFile());
    }

    public void decodeManifest(File apkDir) throws AndrolibException {
        String[] featureFlags;
        if (!this.mApkInfo.hasManifest()) {
            return;
        }
        AndroidManifestResourceParser axmlParser = new AndroidManifestResourceParser(this.mResTable);
        XmlSerializer xmlSerializer = this.newXmlSerializer();
        AndroidManifestPullStreamDecoder fileDecoder = new AndroidManifestPullStreamDecoder(axmlParser, xmlSerializer);
        try {
            Directory inDir = this.mApkInfo.getApkFile().getDirectory();
            Directory outDir = new ExtFile(apkDir).getDirectory();
            if (this.mApkInfo.hasResources()) {
                LOGGER.info("Decoding AndroidManifest.xml with resources...");
            } else {
                LOGGER.info("Decoding AndroidManifest.xml with only framework resources...");
            }
            try (InputStream in = inDir.getFileInput("AndroidManifest.xml");
                 OutputStream out = outDir.getFileOutput("AndroidManifest.xml");){
                fileDecoder.decode(in, out);
            }
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
        File manifest = new File(apkDir, "AndroidManifest.xml");
        if (this.mApkInfo.hasResources() && !this.mConfig.isAnalysisMode()) {
            this.adjustPackageManifest(manifest);
            ResXmlUtils.removeManifestVersions(manifest);
            this.mApkInfo.packageInfo.forcedPackageId = String.valueOf(this.mResTable.getPackageId());
        }
        if ((featureFlags = ResXmlUtils.pullManifestFeatureFlags(manifest)) != null) {
            for (String flag : featureFlags) {
                this.mApkInfo.addFeatureFlag(flag, true);
            }
        }
    }

    public void updateApkInfo(File apkDir) throws AndrolibException {
        this.mResTable.initApkInfo(this.mApkInfo, apkDir);
    }

    private void adjustPackageManifest(File manifest) throws AndrolibException {
        ResPackage resPackage = this.mResTable.getCurrentResPackage();
        String pkgOriginal = resPackage.getName();
        String pkgRenamed = this.mResTable.getPackageRenamed();
        this.mResTable.setPackageId(resPackage.getId());
        this.mResTable.setPackageOriginal(pkgOriginal);
        if (pkgOriginal == null || pkgRenamed == null || pkgOriginal.equals(pkgRenamed) || IGNORED_PACKAGES.contains(pkgOriginal)) {
            LOGGER.info("Regular manifest package...");
        } else {
            LOGGER.info("Renamed manifest package found! Replacing " + pkgRenamed + " with " + pkgOriginal);
            ResXmlUtils.renameManifestPackage(manifest, pkgOriginal);
        }
    }

    public void decodeResources(File apkDir) throws AndrolibException {
        Directory outDir;
        Directory inDir;
        if (!this.mApkInfo.hasResources()) {
            return;
        }
        this.loadMainPkg();
        ResStreamDecoderContainer decoders = new ResStreamDecoderContainer();
        decoders.setDecoder("raw", new ResRawStreamDecoder());
        decoders.setDecoder("9patch", new Res9patchStreamDecoder());
        AXmlResourceParser axmlParser = new AXmlResourceParser(this.mResTable);
        XmlSerializer xmlSerializer = this.newXmlSerializer();
        decoders.setDecoder("xml", new ResXmlPullStreamDecoder(axmlParser, xmlSerializer));
        ResFileDecoder fileDecoder = new ResFileDecoder(decoders);
        try {
            inDir = this.mApkInfo.getApkFile().getDirectory();
            outDir = new ExtFile(apkDir).getDirectory().createDir("res");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        for (ResPackage pkg : this.mResTable.listMainPackages()) {
            LOGGER.info("Decoding file-resources...");
            for (ResResource res : pkg.listFiles()) {
                fileDecoder.decode(res, inDir, outDir, this.mResFileMapping);
            }
            LOGGER.info("Decoding values */* XMLs...");
            for (ResValuesFile valuesFile : pkg.listValuesFiles()) {
                this.generateValuesFile(valuesFile, outDir, xmlSerializer);
            }
            this.generatePublicXml(pkg, outDir, xmlSerializer);
        }
        AndrolibException decodeError = axmlParser.getFirstError();
        if (decodeError != null) {
            throw decodeError;
        }
    }

    private XmlSerializer newXmlSerializer() throws AndrolibException {
        try {
            MXSerializer serial = new MXSerializer();
            serial.setFeature("http://xmlpull.org/v1/doc/features.html#attr-value-no-escape", true);
            serial.setProperty("http://xmlpull.org/v1/doc/properties.html#default-encoding", (Object)"utf-8");
            serial.setProperty("http://xmlpull.org/v1/doc/properties.html#indentation", (Object)"    ");
            serial.setProperty("http://xmlpull.org/v1/doc/properties.html#line-separator", (Object)System.getProperty("line.separator"));
            return serial;
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void generateValuesFile(ResValuesFile valuesFile, Directory resDir, XmlSerializer serial) throws AndrolibException {
        try (OutputStream out = resDir.getFileOutput(valuesFile.getPath());){
            serial.setOutput(out, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResource res : valuesFile.listResources()) {
                if (valuesFile.isSynthesized(res)) continue;
                ((ResValuesXmlSerializable)((Object)res.getValue())).serializeToResValuesXml(serial, res);
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate: " + valuesFile.getPath(), ex);
        }
    }

    private void generatePublicXml(ResPackage pkg, Directory resDir, XmlSerializer serial) throws AndrolibException {
        try (OutputStream out = resDir.getFileOutput("values/public.xml");){
            serial.setOutput(out, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            List<ResResSpec> specs = pkg.listResSpecs();
            specs.sort(Comparator.comparing(ResResSpec::getId));
            for (ResResSpec spec : specs) {
                serial.startTag(null, "public");
                serial.attribute(null, "type", spec.getType().getName());
                serial.attribute(null, "name", spec.getName());
                serial.attribute(null, "id", spec.getId().toString());
                serial.endTag(null, "public");
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate public.xml file", ex);
        }
    }
}

