/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.exceptions.AndrolibException;
import brut.common.BrutException;
import brut.util.AaptManager;
import brut.util.OSDetection;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

public final class Config {
    private static final Logger LOGGER;
    public static final short DECODE_SOURCES_NONE = 0;
    public static final short DECODE_SOURCES_SMALI = 1;
    public static final short DECODE_SOURCES_SMALI_ONLY_MAIN_CLASSES = 16;
    public static final short DECODE_RESOURCES_NONE = 256;
    public static final short DECODE_RESOURCES_FULL = 257;
    public static final short FORCE_DECODE_MANIFEST_NONE = 0;
    public static final short FORCE_DECODE_MANIFEST_FULL = 1;
    public static final short DECODE_ASSETS_NONE = 0;
    public static final short DECODE_ASSETS_FULL = 1;
    public static final short DECODE_RES_RESOLVE_REMOVE = 0;
    public static final short DECODE_RES_RESOLVE_DUMMY = 1;
    public static final short DECODE_RES_RESOLVE_RETAIN = 2;
    private static final String DEFAULT_FRAMEWORK_DIRECTORY;
    private boolean mForceBuildAll = false;
    private boolean mForceDeleteFramework = false;
    private boolean mDebugMode = false;
    private boolean mNetSecConf = false;
    private boolean mVerbose = false;
    private boolean mCopyOriginalFiles = false;
    private boolean mUpdateFiles = false;
    private boolean mNoCrunch = false;
    private boolean mNoApk = false;
    private short mDecodeSources = 1;
    private short mDecodeResources = (short)257;
    private short mForceDecodeManifest = 0;
    private short mDecodeAssets = 1;
    private short mDecodeResolveMode = 0;
    private int mApiLevel = 0;
    private boolean mAnalysisMode = false;
    private boolean mForceDelete = false;
    private boolean mKeepBrokenResources = false;
    private boolean mBaksmaliDebugMode = true;
    private int mJobs = Math.min(Runtime.getRuntime().availableProcessors(), 8);
    private String mFrameworkDirectory = DEFAULT_FRAMEWORK_DIRECTORY;
    private String mFrameworkTag = null;
    private File mAaptBinary = null;
    private int mAaptVersion = 2;

    public boolean isForceBuildAll() {
        return this.mForceBuildAll;
    }

    public void setForceBuildAll(boolean forceBuildAll) {
        this.mForceBuildAll = forceBuildAll;
    }

    public boolean isForceDeleteFramework() {
        return this.mForceDeleteFramework;
    }

    public void setForceDeleteFramework(boolean forceDeleteFramework) {
        this.mForceDeleteFramework = forceDeleteFramework;
    }

    public boolean isDebugMode() {
        return this.mDebugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.mDebugMode = debugMode;
    }

    public boolean isNetSecConf() {
        return this.mNetSecConf;
    }

    public void setNetSecConf(boolean netSecConf) {
        this.mNetSecConf = netSecConf;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public boolean isCopyOriginalFiles() {
        return this.mCopyOriginalFiles;
    }

    public void setCopyOriginalFiles(boolean copyOriginalFiles) {
        this.mCopyOriginalFiles = copyOriginalFiles;
    }

    public boolean isUpdateFiles() {
        return this.mUpdateFiles;
    }

    public void setUpdateFiles(boolean updateFiles) {
        this.mUpdateFiles = updateFiles;
    }

    public boolean isNoCrunch() {
        return this.mNoCrunch;
    }

    public void setNoCrunch(boolean noCrunch) {
        this.mNoCrunch = noCrunch;
    }

    public boolean isNoApk() {
        return this.mNoApk;
    }

    public void setNoApk(boolean noApk) {
        this.mNoApk = noApk;
    }

    public short getDecodeSources() {
        return this.mDecodeSources;
    }

    public void setDecodeSources(short decodeSources) throws AndrolibException {
        switch (decodeSources) {
            case 0: 
            case 1: 
            case 16: {
                this.mDecodeSources = decodeSources;
                break;
            }
            default: {
                throw new AndrolibException("Invalid decode sources mode: " + decodeSources);
            }
        }
    }

    public short getDecodeResources() {
        return this.mDecodeResources;
    }

    public void setDecodeResources(short decodeResources) throws AndrolibException {
        switch (decodeResources) {
            case 256: 
            case 257: {
                this.mDecodeResources = decodeResources;
                break;
            }
            default: {
                throw new AndrolibException("Invalid decode resources mode: " + decodeResources);
            }
        }
    }

    public short getForceDecodeManifest() {
        return this.mForceDecodeManifest;
    }

    public void setForceDecodeManifest(short forceDecodeManifest) throws AndrolibException {
        switch (forceDecodeManifest) {
            case 0: 
            case 1: {
                this.mForceDecodeManifest = forceDecodeManifest;
                break;
            }
            default: {
                throw new AndrolibException("Invalid force decode manifest mode: " + forceDecodeManifest);
            }
        }
    }

    public short getDecodeAssets() {
        return this.mDecodeAssets;
    }

    public void setDecodeAssets(short decodeAssets) throws AndrolibException {
        switch (decodeAssets) {
            case 0: 
            case 1: {
                this.mDecodeAssets = decodeAssets;
                break;
            }
            default: {
                throw new AndrolibException("Invalid decode asset mode: " + decodeAssets);
            }
        }
    }

    public short getDecodeResolveMode() {
        return this.mDecodeResolveMode;
    }

    public void setDecodeResolveMode(short decodeResolveMode) throws AndrolibException {
        switch (decodeResolveMode) {
            case 0: 
            case 1: 
            case 2: {
                this.mDecodeResolveMode = decodeResolveMode;
                break;
            }
            default: {
                throw new AndrolibException("Invalid decode resolve mode: " + decodeResolveMode);
            }
        }
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    public void setApiLevel(int apiLevel) {
        this.mApiLevel = apiLevel;
    }

    public boolean isAnalysisMode() {
        return this.mAnalysisMode;
    }

    public void setAnalysisMode(boolean analysisMode) {
        this.mAnalysisMode = analysisMode;
    }

    public boolean isForceDelete() {
        return this.mForceDelete;
    }

    public void setForceDelete(boolean forceDelete) {
        this.mForceDelete = forceDelete;
    }

    public boolean isKeepBrokenResources() {
        return this.mKeepBrokenResources;
    }

    public void setKeepBrokenResources(boolean keepBrokenResources) {
        this.mKeepBrokenResources = keepBrokenResources;
    }

    public boolean isBaksmaliDebugMode() {
        return this.mBaksmaliDebugMode;
    }

    public void setBaksmaliDebugMode(boolean baksmaliDebugMode) {
        this.mBaksmaliDebugMode = baksmaliDebugMode;
    }

    public int getJobs() {
        return this.mJobs;
    }

    public void setJobs(int jobs) {
        this.mJobs = jobs;
    }

    public String getFrameworkDirectory() {
        return this.mFrameworkDirectory;
    }

    public void setFrameworkDirectory(String frameworkDirectory) {
        this.mFrameworkDirectory = frameworkDirectory != null ? frameworkDirectory : DEFAULT_FRAMEWORK_DIRECTORY;
    }

    public String getFrameworkTag() {
        return this.mFrameworkTag;
    }

    public void setFrameworkTag(String frameworkTag) {
        this.mFrameworkTag = frameworkTag;
    }

    public File getAaptBinary() {
        return this.mAaptBinary;
    }

    public void setAaptBinary(File aaptBinary) throws AndrolibException {
        try {
            this.mAaptBinary = aaptBinary;
            this.mAaptVersion = AaptManager.getAaptVersion((File)aaptBinary);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    public int getAaptVersion() {
        return this.mAaptVersion;
    }

    public void setAaptVersion(int aaptVersion) {
        this.mAaptVersion = aaptVersion;
    }

    static {
        String xdgDataFolder;
        LOGGER = Logger.getLogger(Config.class.getName());
        File parent = new File(System.getProperty("user.home"));
        Path path = OSDetection.isMacOSX() ? Paths.get(parent.getAbsolutePath(), "Library", "apktool", "framework") : (OSDetection.isWindows() ? Paths.get(parent.getAbsolutePath(), "AppData", "Local", "apktool", "framework") : ((xdgDataFolder = System.getenv("XDG_DATA_HOME")) != null ? Paths.get(xdgDataFolder, "apktool", "framework") : Paths.get(parent.getAbsolutePath(), ".local", "share", "apktool", "framework")));
        DEFAULT_FRAMEWORK_DIRECTORY = path.toString();
    }
}

