/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.javadoc.main;

import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.oldlets.javadoc.main.ClassDocImpl;
import com.sun.tools.oldlets.javadoc.main.DocEnv;
import com.sun.tools.oldlets.javadoc.main.SymbolKind;

public class JavadocMemberEnter
extends MemberEnter {
    final DocEnv docenv;

    public static JavadocMemberEnter instance0(Context context) {
        MemberEnter instance = (MemberEnter)context.get(memberEnterKey);
        if (instance == null) {
            instance = new JavadocMemberEnter(context);
        }
        return (JavadocMemberEnter)instance;
    }

    public static void preRegister(Context context) {
        context.put(memberEnterKey, JavadocMemberEnter::new);
    }

    protected JavadocMemberEnter(Context context) {
        super(context);
        this.docenv = DocEnv.instance(context);
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        super.visitMethodDef(tree);
        Symbol.MethodSymbol meth = tree.sym;
        if (meth == null || !SymbolKind.MTH.same(meth)) {
            return;
        }
        TreePath treePath = this.docenv.getTreePath(this.env.toplevel, this.env.enclClass, tree);
        if (meth.isConstructor()) {
            this.docenv.makeConstructorDoc(meth, treePath);
        } else if (JavadocMemberEnter.isAnnotationTypeElement(meth)) {
            this.docenv.makeAnnotationTypeElementDoc(meth, treePath);
        } else {
            this.docenv.makeMethodDoc(meth, treePath);
        }
        tree.body = null;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        if (tree.init != null) {
            boolean isFinal;
            boolean bl = isFinal = (tree.mods.flags & 0x10L) != 0L || (this.env.enclClass.mods.flags & 0x200L) != 0L;
            if (!isFinal || JavadocMemberEnter.containsNonConstantExpression(tree.init)) {
                tree.init = null;
            }
        }
        super.visitVarDef(tree);
        if (tree.sym != null && SymbolKind.VAR.same(tree.sym) && !JavadocMemberEnter.isParameter(tree.sym)) {
            this.docenv.makeFieldDoc(tree.sym, this.docenv.getTreePath(this.env.toplevel, this.env.enclClass, tree));
        }
    }

    private static boolean isAnnotationTypeElement(Symbol.MethodSymbol meth) {
        return ClassDocImpl.isAnnotationType(meth.enclClass());
    }

    private static boolean isParameter(Symbol.VarSymbol var) {
        return (var.flags() & 0x200000000L) != 0L;
    }

    private static boolean containsNonConstantExpression(JCTree.JCExpression tree) {
        return new MaybeConstantExpressionScanner().containsNonConstantExpression(tree);
    }

    private static class MaybeConstantExpressionScanner
    extends JCTree.Visitor {
        boolean maybeConstantExpr = true;

        private MaybeConstantExpressionScanner() {
        }

        public boolean containsNonConstantExpression(JCTree.JCExpression tree) {
            this.scan(tree);
            return !this.maybeConstantExpr;
        }

        public void scan(JCTree tree) {
            if (this.maybeConstantExpr && tree != null) {
                tree.accept(this);
            }
        }

        @Override
        public void visitTree(JCTree tree) {
            this.maybeConstantExpr = false;
        }

        @Override
        public void visitBinary(JCTree.JCBinary tree) {
            switch (tree.getTag()) {
                case MUL: 
                case DIV: 
                case MOD: 
                case PLUS: 
                case MINUS: 
                case SL: 
                case SR: 
                case USR: 
                case LT: 
                case LE: 
                case GT: 
                case GE: 
                case EQ: 
                case NE: 
                case BITAND: 
                case BITXOR: 
                case BITOR: 
                case AND: 
                case OR: {
                    break;
                }
                default: {
                    this.maybeConstantExpr = false;
                }
            }
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            this.scan(tree.cond);
            this.scan(tree.truepart);
            this.scan(tree.falsepart);
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral tree) {
        }

        @Override
        public void visitParens(JCTree.JCParens tree) {
            this.scan(tree.expr);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            this.scan(tree.selected);
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast tree) {
            this.scan(tree.clazz);
            this.scan(tree.expr);
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            switch (tree.getTag()) {
                case POS: 
                case NEG: 
                case COMPL: 
                case NOT: {
                    break;
                }
                default: {
                    this.maybeConstantExpr = false;
                }
            }
        }
    }
}

