/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.javadoc.main;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.List;
import com.sun.tools.oldlets.javadoc.main.Messager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileManager;

public class DocletInvoker {
    private final Class<?> docletClass;
    private final String docletClassName;
    private final ClassLoader appClassLoader;
    private final Messager messager;
    private final boolean apiMode;
    private final boolean exportInternalAPI;

    private String appendPath(String path1, String path2) {
        if (path1 == null || path1.length() == 0) {
            return path2 == null ? "." : path2;
        }
        if (path2 == null || path2.length() == 0) {
            return path1;
        }
        return path1 + File.pathSeparator + path2;
    }

    public DocletInvoker(Messager messager, Class<?> docletClass, boolean apiMode, boolean exportInternalAPI) {
        this.messager = messager;
        this.docletClass = docletClass;
        this.docletClassName = docletClass.getName();
        this.appClassLoader = null;
        this.apiMode = apiMode;
        this.exportInternalAPI = exportInternalAPI;
        if (exportInternalAPI) {
            this.exportInternalAPI(docletClass.getClassLoader());
        }
    }

    public DocletInvoker(Messager messager, JavaFileManager fileManager, String docletClassName, String docletPath, ClassLoader docletParentClassLoader, boolean apiMode, boolean exportInternalAPI) {
        this.messager = messager;
        this.docletClassName = docletClassName;
        this.apiMode = apiMode;
        this.exportInternalAPI = exportInternalAPI;
        if (fileManager != null && fileManager.hasLocation(DocumentationTool.Location.DOCLET_PATH)) {
            this.appClassLoader = fileManager.getClassLoader(DocumentationTool.Location.DOCLET_PATH);
        } else {
            String cpString = null;
            cpString = this.appendPath(System.getProperty("env.class.path"), cpString);
            cpString = this.appendPath(System.getProperty("java.class.path"), cpString);
            cpString = this.appendPath(docletPath, cpString);
            URL[] urls = DocletInvoker.pathToURLs(cpString);
            this.appClassLoader = docletParentClassLoader == null ? new URLClassLoader(urls, this.getDelegationClassLoader(docletClassName)) : new URLClassLoader(urls, docletParentClassLoader);
        }
        if (exportInternalAPI) {
            this.exportInternalAPI(this.appClassLoader);
        }
        Class<?> dc = null;
        try {
            dc = this.appClassLoader.loadClass(docletClassName);
        }
        catch (ClassNotFoundException exc) {
            messager.error(Messager.NOPOS, "main.doclet_class_not_found", docletClassName);
            messager.exit();
        }
        this.docletClass = dc;
    }

    private ClassLoader getDelegationClassLoader(String docletClassName) {
        ClassLoader ctxCL;
        block12: {
            ctxCL = Thread.currentThread().getContextClassLoader();
            ClassLoader sysCL = ClassLoader.getSystemClassLoader();
            if (sysCL == null) {
                return ctxCL;
            }
            if (ctxCL == null) {
                return sysCL;
            }
            try {
                sysCL.loadClass(docletClassName);
                try {
                    ctxCL.loadClass(docletClassName);
                }
                catch (ClassNotFoundException e) {
                    return sysCL;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                if (this.getClass() != sysCL.loadClass(this.getClass().getName())) break block12;
                try {
                    if (this.getClass() != ctxCL.loadClass(this.getClass().getName())) {
                        return sysCL;
                    }
                }
                catch (ClassNotFoundException e) {
                    return sysCL;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ctxCL;
    }

    public boolean start(RootDoc root) {
        Object retVal;
        String methodName = "start";
        Class[] paramTypes = new Class[]{RootDoc.class};
        Object[] params = new Object[]{root};
        try {
            retVal = this.invoke(methodName, null, paramTypes, params);
        }
        catch (DocletInvokeException exc) {
            return false;
        }
        if (retVal instanceof Boolean) {
            return (Boolean)retVal;
        }
        this.messager.error(Messager.NOPOS, "main.must_return_boolean", this.docletClassName, methodName);
        return false;
    }

    public int optionLength(String option) {
        Object retVal;
        String methodName = "optionLength";
        Class[] paramTypes = new Class[]{String.class};
        Object[] params = new Object[]{option};
        try {
            retVal = this.invoke(methodName, 0, paramTypes, params);
        }
        catch (DocletInvokeException exc) {
            return -1;
        }
        if (retVal instanceof Integer) {
            return (Integer)retVal;
        }
        this.messager.error(Messager.NOPOS, "main.must_return_int", this.docletClassName, methodName);
        return -1;
    }

    public boolean validOptions(List<String[]> optlist) {
        Object retVal;
        String[][] options = (String[][])optlist.toArray((T[])new String[optlist.length()][]);
        String methodName = "validOptions";
        Messager reporter = this.messager;
        Class[] paramTypes = new Class[]{String[][].class, DocErrorReporter.class};
        Object[] params = new Object[]{options, reporter};
        try {
            retVal = this.invoke(methodName, Boolean.TRUE, paramTypes, params);
        }
        catch (DocletInvokeException exc) {
            return false;
        }
        if (retVal instanceof Boolean) {
            return (Boolean)retVal;
        }
        this.messager.error(Messager.NOPOS, "main.must_return_boolean", this.docletClassName, methodName);
        return false;
    }

    public LanguageVersion languageVersion() {
        try {
            Object retVal;
            String methodName = "languageVersion";
            Class[] paramTypes = new Class[]{};
            Object[] params = new Object[]{};
            try {
                retVal = this.invoke(methodName, (Object)LanguageVersion.JAVA_1_1, paramTypes, params);
            }
            catch (DocletInvokeException exc) {
                return LanguageVersion.JAVA_1_1;
            }
            if (retVal instanceof LanguageVersion) {
                return (LanguageVersion)((Object)retVal);
            }
            this.messager.error(Messager.NOPOS, "main.must_return_languageversion", this.docletClassName, methodName);
            return LanguageVersion.JAVA_1_1;
        }
        catch (NoClassDefFoundError ex) {
            return null;
        }
    }

    private Object invoke(String methodName, Object returnValueIfNonExistent, Class<?>[] paramTypes, Object[] params) throws DocletInvokeException {
        Method meth;
        try {
            meth = this.docletClass.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException exc) {
            if (returnValueIfNonExistent == null) {
                this.messager.error(Messager.NOPOS, "main.doclet_method_not_found", this.docletClassName, methodName);
                throw new DocletInvokeException();
            }
            return returnValueIfNonExistent;
        }
        catch (SecurityException exc) {
            this.messager.error(Messager.NOPOS, "main.doclet_method_not_accessible", this.docletClassName, methodName);
            throw new DocletInvokeException();
        }
        if (!Modifier.isStatic(meth.getModifiers())) {
            this.messager.error(Messager.NOPOS, "main.doclet_method_must_be_static", this.docletClassName, methodName);
            throw new DocletInvokeException();
        }
        ClassLoader savedCCL = Thread.currentThread().getContextClassLoader();
        try {
            if (this.appClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.appClassLoader);
            }
            Object object = meth.invoke(null, params);
            return object;
        }
        catch (IllegalArgumentException | NullPointerException exc) {
            this.messager.error(Messager.NOPOS, "main.internal_error_exception_thrown", this.docletClassName, methodName, exc.toString());
            throw new DocletInvokeException();
        }
        catch (IllegalAccessException exc) {
            this.messager.error(Messager.NOPOS, "main.doclet_method_not_accessible", this.docletClassName, methodName);
            throw new DocletInvokeException();
        }
        catch (InvocationTargetException exc) {
            Throwable err = exc.getTargetException();
            if (this.apiMode) {
                throw new ClientCodeException(err);
            }
            if (err instanceof OutOfMemoryError) {
                this.messager.error(Messager.NOPOS, "main.out.of.memory", new Object[0]);
            } else {
                this.messager.error(Messager.NOPOS, "main.exception_thrown", this.docletClassName, methodName, exc.toString());
                exc.getTargetException().printStackTrace(System.err);
            }
            throw new DocletInvokeException();
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCCL);
        }
    }

    private void exportInternalAPI(ClassLoader cl) {
        String[] packages = new String[]{"com.sun.tools.doclets", "com.sun.tools.doclets.standard", "com.sun.tools.doclets.internal.toolkit", "com.sun.tools.doclets.internal.toolkit.taglets", "com.sun.tools.doclets.internal.toolkit.builders", "com.sun.tools.doclets.internal.toolkit.util", "com.sun.tools.doclets.internal.toolkit.util.links", "com.sun.tools.doclets.formats.html", "com.sun.tools.doclets.formats.html.markup"};
        try {
            Method getModuleMethod = Class.class.getDeclaredMethod("getModule", new Class[0]);
            Object thisModule = getModuleMethod.invoke(this.getClass(), new Object[0]);
            Class<?> moduleClass = Class.forName("java.lang.Module");
            Method addExportsMethod = moduleClass.getDeclaredMethod("addExports", String.class, moduleClass);
            Method getUnnamedModuleMethod = ClassLoader.class.getDeclaredMethod("getUnnamedModule", new Class[0]);
            Object target = getUnnamedModuleMethod.invoke((Object)cl, new Object[0]);
            for (String pack : packages) {
                addExportsMethod.invoke(thisModule, pack, target);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static URL[] pathToURLs(String path) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String s : path.split(Pattern.quote(File.pathSeparator))) {
            URL url;
            if (s.isEmpty() || (url = DocletInvoker.fileToURL(Paths.get(s, new String[0]))) == null) continue;
            urls.add(url);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL fileToURL(Path file) {
        Path p;
        try {
            p = file.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            p = file.toAbsolutePath();
        }
        try {
            return p.normalize().toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static class DocletInvokeException
    extends Exception {
        private static final long serialVersionUID = 0L;

        private DocletInvokeException() {
        }
    }
}

