/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImplementedMethods {
    private Map<MethodDoc, Type> interfaces = new HashMap<MethodDoc, Type>();
    private List<MethodDoc> methlist = new ArrayList<MethodDoc>();
    private Configuration configuration;
    private final ClassDoc classdoc;
    private final MethodDoc method;

    public ImplementedMethods(MethodDoc method, Configuration configuration) {
        this.method = method;
        this.configuration = configuration;
        this.classdoc = method.containingClass();
    }

    public MethodDoc[] build(boolean sort) {
        this.buildImplementedMethodList(sort);
        return this.methlist.toArray(new MethodDoc[this.methlist.size()]);
    }

    public MethodDoc[] build() {
        return this.build(true);
    }

    public Type getMethodHolder(MethodDoc methodDoc) {
        return this.interfaces.get(methodDoc);
    }

    private void buildImplementedMethodList(boolean sort) {
        List<Type> intfacs = Util.getAllInterfaces(this.classdoc, this.configuration, sort);
        for (Type interfaceType : intfacs) {
            MethodDoc found = Util.findMethod(interfaceType.asClassDoc(), this.method);
            if (found == null) continue;
            this.removeOverriddenMethod(found);
            if (this.overridingMethodFound(found)) continue;
            this.methlist.add(found);
            this.interfaces.put(found, interfaceType);
        }
    }

    private void removeOverriddenMethod(MethodDoc method) {
        ClassDoc overriddenClass = method.overriddenClass();
        if (overriddenClass != null) {
            for (int i = 0; i < this.methlist.size(); ++i) {
                ClassDoc cd = this.methlist.get(i).containingClass();
                if (cd != overriddenClass && !overriddenClass.subclassOf(cd)) continue;
                this.methlist.remove(i);
                return;
            }
        }
    }

    private boolean overridingMethodFound(MethodDoc method) {
        ClassDoc containingClass = method.containingClass();
        for (int i = 0; i < this.methlist.size(); ++i) {
            MethodDoc listmethod = this.methlist.get(i);
            if (containingClass == listmethod.containingClass()) {
                return true;
            }
            ClassDoc cd = listmethod.overriddenClass();
            if (cd == null || cd != containingClass && !cd.subclassOf(containingClass)) continue;
            return true;
        }
        return false;
    }
}

