/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.internal.toolkit.util.DocLink;

public class DocPath {
    private final String path;
    public static final DocPath empty = new DocPath("");
    public static final DocPath parent = new DocPath("..");

    public static DocPath create(String p) {
        return p == null || p.isEmpty() ? empty : new DocPath(p);
    }

    public static DocPath forClass(ClassDoc cd) {
        return cd == null ? empty : DocPath.forPackage(cd.containingPackage()).resolve(DocPath.forName(cd));
    }

    public static DocPath forName(ClassDoc cd) {
        return cd == null ? empty : new DocPath(cd.name() + ".html");
    }

    public static DocPath forPackage(ClassDoc cd) {
        return cd == null ? empty : DocPath.forPackage(cd.containingPackage());
    }

    public static DocPath forPackage(PackageDoc pd) {
        return pd == null ? empty : DocPath.create(pd.name().replace('.', '/'));
    }

    public static DocPath forRoot(PackageDoc pd) {
        String name;
        String string = name = pd == null ? "" : pd.name();
        if (name.isEmpty()) {
            return empty;
        }
        return new DocPath(name.replace('.', '/').replaceAll("[^/]+", ".."));
    }

    public static DocPath relativePath(PackageDoc from, PackageDoc to) {
        return DocPath.forRoot(from).resolve(DocPath.forPackage(to));
    }

    protected DocPath(String p) {
        this.path = p.endsWith("/") ? p.substring(0, p.length() - 1) : p;
    }

    public boolean equals(Object other) {
        return other instanceof DocPath && this.path.equals(((DocPath)other).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public DocPath basename() {
        int sep = this.path.lastIndexOf("/");
        return sep == -1 ? this : new DocPath(this.path.substring(sep + 1));
    }

    public DocPath parent() {
        int sep = this.path.lastIndexOf("/");
        return sep == -1 ? empty : new DocPath(this.path.substring(0, sep));
    }

    public DocPath resolve(String p) {
        if (p == null || p.isEmpty()) {
            return this;
        }
        if (this.path.isEmpty()) {
            return new DocPath(p);
        }
        return new DocPath(this.path + "/" + p);
    }

    public DocPath resolve(DocPath p) {
        if (p == null || p.isEmpty()) {
            return this;
        }
        if (this.path.isEmpty()) {
            return p;
        }
        return new DocPath(this.path + "/" + p.getPath());
    }

    public DocPath invert() {
        return new DocPath(this.path.replaceAll("[^/]+", ".."));
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public DocLink fragment(String fragment) {
        return new DocLink(this.path, null, fragment);
    }

    public DocLink query(String query) {
        return new DocLink(this.path, query, null);
    }

    public String getPath() {
        return this.path;
    }
}

