/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.ProfileSummaryWriter;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;

public class ProfileSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "ProfileDoc";
    private final Profile profile;
    private final ProfileSummaryWriter profileWriter;
    private Content contentTree;
    private PackageDoc pkg;

    private ProfileSummaryBuilder(AbstractBuilder.Context context, Profile profile, ProfileSummaryWriter profileWriter) {
        super(context);
        this.profile = profile;
        this.profileWriter = profileWriter;
    }

    public static ProfileSummaryBuilder getInstance(AbstractBuilder.Context context, Profile profile, ProfileSummaryWriter profileWriter) {
        return new ProfileSummaryBuilder(context, profile, profileWriter);
    }

    @Override
    public void build() throws IOException {
        if (this.profileWriter == null) {
            return;
        }
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildProfileDoc(XMLNode node, Content contentTree) throws Exception {
        contentTree = this.profileWriter.getProfileHeader(this.profile.name);
        this.buildChildren(node, contentTree);
        this.profileWriter.addProfileFooter(contentTree);
        this.profileWriter.printDocument(contentTree);
        this.profileWriter.close();
        Util.copyDocFiles(this.configuration, DocPaths.profileSummary(this.profile.name));
    }

    public void buildContent(XMLNode node, Content contentTree) {
        Content profileContentTree = this.profileWriter.getContentHeader();
        this.buildChildren(node, profileContentTree);
        contentTree.addContent(profileContentTree);
    }

    public void buildSummary(XMLNode node, Content profileContentTree) {
        Content summaryContentTree = this.profileWriter.getSummaryHeader();
        this.buildChildren(node, summaryContentTree);
        profileContentTree.addContent(this.profileWriter.getSummaryTree(summaryContentTree));
    }

    public void buildPackageSummary(XMLNode node, Content summaryContentTree) {
        PackageDoc[] packages = this.configuration.profilePackages.get(this.profile.name);
        for (int i = 0; i < packages.length; ++i) {
            this.pkg = packages[i];
            Content packageSummaryContentTree = this.profileWriter.getPackageSummaryHeader(this.pkg);
            this.buildChildren(node, packageSummaryContentTree);
            summaryContentTree.addContent(this.profileWriter.getPackageSummaryTree(packageSummaryContentTree));
        }
    }

    public void buildInterfaceSummary(XMLNode node, Content packageSummaryContentTree) {
        String interfaceTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Interface_Summary"), this.configuration.getText("doclet.interfaces"));
        String[] interfaceTableHeader = new String[]{this.configuration.getText("doclet.Interface"), this.configuration.getText("doclet.Description")};
        ClassDoc[] interfaces = this.pkg.interfaces();
        if (interfaces.length > 0) {
            this.profileWriter.addClassesSummary(interfaces, this.configuration.getText("doclet.Interface_Summary"), interfaceTableSummary, interfaceTableHeader, packageSummaryContentTree);
        }
    }

    public void buildClassSummary(XMLNode node, Content packageSummaryContentTree) {
        String classTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Class_Summary"), this.configuration.getText("doclet.classes"));
        String[] classTableHeader = new String[]{this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classes = this.pkg.ordinaryClasses();
        if (classes.length > 0) {
            this.profileWriter.addClassesSummary(classes, this.configuration.getText("doclet.Class_Summary"), classTableSummary, classTableHeader, packageSummaryContentTree);
        }
    }

    public void buildEnumSummary(XMLNode node, Content packageSummaryContentTree) {
        String enumTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Enum_Summary"), this.configuration.getText("doclet.enums"));
        String[] enumTableHeader = new String[]{this.configuration.getText("doclet.Enum"), this.configuration.getText("doclet.Description")};
        ClassDoc[] enums = this.pkg.enums();
        if (enums.length > 0) {
            this.profileWriter.addClassesSummary(enums, this.configuration.getText("doclet.Enum_Summary"), enumTableSummary, enumTableHeader, packageSummaryContentTree);
        }
    }

    public void buildExceptionSummary(XMLNode node, Content packageSummaryContentTree) {
        String exceptionTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Exception_Summary"), this.configuration.getText("doclet.exceptions"));
        String[] exceptionTableHeader = new String[]{this.configuration.getText("doclet.Exception"), this.configuration.getText("doclet.Description")};
        ClassDoc[] exceptions = this.pkg.exceptions();
        if (exceptions.length > 0) {
            this.profileWriter.addClassesSummary(exceptions, this.configuration.getText("doclet.Exception_Summary"), exceptionTableSummary, exceptionTableHeader, packageSummaryContentTree);
        }
    }

    public void buildErrorSummary(XMLNode node, Content packageSummaryContentTree) {
        String errorTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Error_Summary"), this.configuration.getText("doclet.errors"));
        String[] errorTableHeader = new String[]{this.configuration.getText("doclet.Error"), this.configuration.getText("doclet.Description")};
        ClassDoc[] errors = this.pkg.errors();
        if (errors.length > 0) {
            this.profileWriter.addClassesSummary(errors, this.configuration.getText("doclet.Error_Summary"), errorTableSummary, errorTableHeader, packageSummaryContentTree);
        }
    }

    public void buildAnnotationTypeSummary(XMLNode node, Content packageSummaryContentTree) {
        String annotationtypeTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Annotation_Types_Summary"), this.configuration.getText("doclet.annotationtypes"));
        String[] annotationtypeTableHeader = new String[]{this.configuration.getText("doclet.AnnotationType"), this.configuration.getText("doclet.Description")};
        ClassDoc[] annotationTypes = this.pkg.annotationTypes();
        if (annotationTypes.length > 0) {
            this.profileWriter.addClassesSummary(annotationTypes, this.configuration.getText("doclet.Annotation_Types_Summary"), annotationtypeTableSummary, annotationtypeTableHeader, packageSummaryContentTree);
        }
    }
}

