/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.FieldWriter;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FieldBuilder
extends AbstractMemberBuilder {
    private final ClassDoc classDoc;
    private final VisibleMemberMap visibleMemberMap;
    private final FieldWriter writer;
    private final List<ProgramElementDoc> fields;
    private int currentFieldIndex;

    private FieldBuilder(AbstractBuilder.Context context, ClassDoc classDoc, FieldWriter writer) {
        super(context);
        this.classDoc = classDoc;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(classDoc, 2, this.configuration);
        this.fields = new ArrayList<ProgramElementDoc>(this.visibleMemberMap.getLeafClassMembers(this.configuration));
        if (this.configuration.getMemberComparator() != null) {
            Collections.sort(this.fields, this.configuration.getMemberComparator());
        }
    }

    public static FieldBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, FieldWriter writer) {
        return new FieldBuilder(context, classDoc, writer);
    }

    @Override
    public String getName() {
        return "FieldDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.fields.size() > 0;
    }

    public void buildFieldDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.fields.size();
        if (size > 0) {
            Content fieldDetailsTree = this.writer.getFieldDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentFieldIndex = 0;
            while (this.currentFieldIndex < size) {
                Content fieldDocTree = this.writer.getFieldDocTreeHeader((FieldDoc)this.fields.get(this.currentFieldIndex), fieldDetailsTree);
                this.buildChildren(node, fieldDocTree);
                fieldDetailsTree.addContent(this.writer.getFieldDoc(fieldDocTree, this.currentFieldIndex == size - 1));
                ++this.currentFieldIndex;
            }
            memberDetailsTree.addContent(this.writer.getFieldDetails(fieldDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content fieldDocTree) {
        fieldDocTree.addContent(this.writer.getSignature((FieldDoc)this.fields.get(this.currentFieldIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content fieldDocTree) {
        this.writer.addDeprecated((FieldDoc)this.fields.get(this.currentFieldIndex), fieldDocTree);
    }

    public void buildFieldComments(XMLNode node, Content fieldDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((FieldDoc)this.fields.get(this.currentFieldIndex), fieldDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content fieldDocTree) {
        this.writer.addTags((FieldDoc)this.fields.get(this.currentFieldIndex), fieldDocTree);
    }

    public FieldWriter getWriter() {
        return this.writer;
    }
}

