/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.oldlets.internal.toolkit.AnnotationTypeRequiredMemberWriter;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationTypeRequiredMemberBuilder
extends AbstractMemberBuilder {
    protected ClassDoc classDoc;
    protected VisibleMemberMap visibleMemberMap;
    protected AnnotationTypeRequiredMemberWriter writer;
    protected List<ProgramElementDoc> members;
    protected int currentMemberIndex;

    protected AnnotationTypeRequiredMemberBuilder(AbstractBuilder.Context context, ClassDoc classDoc, AnnotationTypeRequiredMemberWriter writer, int memberType) {
        super(context);
        this.classDoc = classDoc;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(classDoc, memberType, this.configuration);
        this.members = new ArrayList<ProgramElementDoc>(this.visibleMemberMap.getMembersFor(classDoc));
        if (this.configuration.getMemberComparator() != null) {
            Collections.sort(this.members, this.configuration.getMemberComparator());
        }
    }

    public static AnnotationTypeRequiredMemberBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, AnnotationTypeRequiredMemberWriter writer) {
        return new AnnotationTypeRequiredMemberBuilder(context, classDoc, writer, 7);
    }

    @Override
    public String getName() {
        return "AnnotationTypeRequiredMemberDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.members.size() > 0;
    }

    public void buildAnnotationTypeRequiredMember(XMLNode node, Content memberDetailsTree) {
        this.buildAnnotationTypeMember(node, memberDetailsTree);
    }

    public void buildAnnotationTypeMember(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.members.size();
        if (size > 0) {
            this.writer.addAnnotationDetailsMarker(memberDetailsTree);
            this.currentMemberIndex = 0;
            while (this.currentMemberIndex < size) {
                Content detailsTree = this.writer.getMemberTreeHeader();
                this.writer.addAnnotationDetailsTreeHeader(this.classDoc, detailsTree);
                Content annotationDocTree = this.writer.getAnnotationDocTreeHeader((MemberDoc)this.members.get(this.currentMemberIndex), detailsTree);
                this.buildChildren(node, annotationDocTree);
                detailsTree.addContent(this.writer.getAnnotationDoc(annotationDocTree, this.currentMemberIndex == size - 1));
                memberDetailsTree.addContent(this.writer.getAnnotationDetails(detailsTree));
                ++this.currentMemberIndex;
            }
        }
    }

    public void buildSignature(XMLNode node, Content annotationDocTree) {
        annotationDocTree.addContent(this.writer.getSignature((MemberDoc)this.members.get(this.currentMemberIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content annotationDocTree) {
        this.writer.addDeprecated((MemberDoc)this.members.get(this.currentMemberIndex), annotationDocTree);
    }

    public void buildMemberComments(XMLNode node, Content annotationDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((MemberDoc)this.members.get(this.currentMemberIndex), annotationDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content annotationDocTree) {
        this.writer.addTags((MemberDoc)this.members.get(this.currentMemberIndex), annotationDocTree);
    }

    public AnnotationTypeRequiredMemberWriter getWriter() {
        return this.writer;
    }
}

