/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlSerialFieldWriter;
import com.sun.tools.oldlets.formats.html.HtmlSerialMethodWriter;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.SubWriterHolderWriter;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.SerializedFormWriter;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import java.io.IOException;

public class SerializedFormWriterImpl
extends SubWriterHolderWriter
implements SerializedFormWriter {
    public SerializedFormWriterImpl(ConfigurationImpl configuration) throws IOException {
        super(configuration, DocPaths.SERIALIZED_FORM);
    }

    @Override
    public Content getHeader(String header) {
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(header));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        StringContent h1Content = new StringContent(header);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, h1Content);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    @Override
    public Content getSerializedSummariesHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public Content getPackageSerializedHeader() {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        li.addStyle(HtmlStyle.blockList);
        return li;
    }

    @Override
    public Content getPackageHeader(String packageName) {
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, this.packageLabel);
        ((Content)heading).addContent(this.getSpace());
        ((Content)heading).addContent(packageName);
        return heading;
    }

    @Override
    public Content getClassSerializedHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public Content getClassHeader(ClassDoc classDoc) {
        StringContent classLink = classDoc.isPublic() || classDoc.isProtected() ? this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.DEFAULT, classDoc).label(this.configuration.getClassName(classDoc))) : new StringContent(classDoc.qualifiedName());
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, this.getMarkerAnchor(classDoc.qualifiedName()));
        Content superClassLink = classDoc.superclassType() != null ? this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.SERIALIZED_FORM, classDoc.superclassType())) : null;
        Content className = superClassLink == null ? this.configuration.getResource("doclet.Class_0_implements_serializable", classLink) : this.configuration.getResource("doclet.Class_0_extends_implements_serializable", classLink, superClassLink);
        ((Content)li).addContent(HtmlTree.HEADING(HtmlConstants.SERIALIZED_MEMBER_HEADING, className));
        return li;
    }

    @Override
    public Content getSerialUIDInfoHeader() {
        HtmlTree dl = new HtmlTree(HtmlTag.DL);
        dl.addStyle(HtmlStyle.nameValue);
        return dl;
    }

    @Override
    public void addSerialUIDInfo(String header, String serialUID, Content serialUidTree) {
        StringContent headerContent = new StringContent(header);
        serialUidTree.addContent(HtmlTree.DT(headerContent));
        StringContent serialContent = new StringContent(serialUID);
        serialUidTree.addContent(HtmlTree.DD(serialContent));
    }

    @Override
    public Content getClassContentHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public Content getSerializedContent(Content serializedTreeContent) {
        HtmlTree divContent = HtmlTree.DIV(HtmlStyle.serializedFormContainer, serializedTreeContent);
        return divContent;
    }

    @Override
    public void addFooter(Content serializedTree) {
        this.addNavLinks(false, serializedTree);
        this.addBottom(serializedTree);
    }

    @Override
    public void printDocument(Content serializedTree) throws IOException {
        this.printHtmlDocument(null, true, serializedTree);
    }

    @Override
    public SerializedFormWriter.SerialFieldWriter getSerialFieldWriter(ClassDoc classDoc) {
        return new HtmlSerialFieldWriter(this, classDoc);
    }

    @Override
    public SerializedFormWriter.SerialMethodWriter getSerialMethodWriter(ClassDoc classDoc) {
        return new HtmlSerialMethodWriter(this, classDoc);
    }
}

