/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.formats.html.AbstractProfileIndexWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import org.apidesign.javadoc.codesnippet.impl.Profiles;

public class ProfilePackageIndexFrameWriter
extends AbstractProfileIndexWriter {
    public ProfilePackageIndexFrameWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(ConfigurationImpl configuration, String profileName) {
        DocPath filename = DocPaths.profileFrame(profileName);
        try {
            ProfilePackageIndexFrameWriter profpackgen = new ProfilePackageIndexFrameWriter(configuration, filename);
            profpackgen.buildProfilePackagesIndexFile("doclet.Window_Overview", false, profileName);
            profpackgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    @Override
    protected void addProfilePackagesList(Profiles profiles, String text, String tableSummary, Content body, String profileName) {
        StringContent profNameContent = new StringContent(profileName);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, this.getTargetProfileLink("classFrame", profNameContent, profileName));
        ((Content)heading).addContent(this.getSpace());
        ((Content)heading).addContent(this.packagesLabel);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.indexContainer, heading);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.setTitle(this.packagesLabel);
        PackageDoc[] packages = (PackageDoc[])this.configuration.profilePackages.get(profileName);
        for (int i = 0; i < packages.length; ++i) {
            if (this.configuration.nodeprecated && Util.isDeprecated(packages[i])) continue;
            ul.addContent(this.getPackage(packages[i], profileName));
        }
        ((Content)div).addContent(ul);
        body.addContent(div);
    }

    protected Content getPackage(PackageDoc pd, String profileName) {
        Content packageLinkContent;
        if (pd.name().length() > 0) {
            Content pkgLabel = this.getPackageLabel(pd.name());
            packageLinkContent = this.getHyperLink(this.pathString(pd, DocPaths.profilePackageFrame(profileName)), pkgLabel, "", "packageFrame");
        } else {
            StringContent pkgLabel = new StringContent("<unnamed package>");
            packageLinkContent = this.getHyperLink(DocPaths.PACKAGE_FRAME, (Content)pkgLabel, "", "packageFrame");
        }
        HtmlTree li = HtmlTree.LI(packageLinkContent);
        return li;
    }

    @Override
    protected void addNavigationBarHeader(Content body) {
        RawHtml headerContent = this.configuration.packagesheader.length() > 0 ? new RawHtml(this.replaceDocRootDir(this.configuration.packagesheader)) : new RawHtml(this.replaceDocRootDir(this.configuration.header));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.bar, headerContent);
        body.addContent(heading);
    }

    @Override
    protected void addOverviewHeader(Content body) {
    }

    @Override
    protected void addProfilesList(Profiles profiles, String text, String tableSummary, Content body) {
    }

    @Override
    protected void addAllClassesLink(Content div) {
        Content linkContent = this.getHyperLink(DocPaths.ALLCLASSES_FRAME, this.allclassesLabel, "", "packageFrame");
        HtmlTree span = HtmlTree.SPAN(linkContent);
        div.addContent(span);
    }

    @Override
    protected void addAllPackagesLink(Content div) {
        Content linkContent = this.getHyperLink(DocPaths.OVERVIEW_FRAME, this.allpackagesLabel, "", "packageListFrame");
        HtmlTree span = HtmlTree.SPAN(linkContent);
        div.addContent(span);
    }

    @Override
    protected void addAllProfilesLink(Content div) {
        Content linkContent = this.getHyperLink(DocPaths.PROFILE_OVERVIEW_FRAME, this.allprofilesLabel, "", "packageListFrame");
        HtmlTree span = HtmlTree.SPAN(linkContent);
        div.addContent(span);
    }

    @Override
    protected void addNavigationBarFooter(Content body) {
        HtmlTree p = HtmlTree.P(this.getSpace());
        body.addContent(p);
    }
}

