/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclint.DocLint;
import com.sun.tools.javac.util.StringUtils;
import com.sun.tools.oldlets.formats.html.WriterFactoryImpl;
import com.sun.tools.oldlets.formats.html.markup.ContentBuilder;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.WriterFactory;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.MessageRetriever;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.tools.JavaFileManager;
import org.apidesign.javadoc.codesnippet.impl.Profiles;

public class ConfigurationImpl
extends Configuration {
    public static final String BUILD_DATE = System.getProperty("java.version");
    public String header = "";
    public String packagesheader = "";
    public String footer = "";
    public String doctitle = "";
    public String windowtitle = "";
    public String top = "";
    public String bottom = "";
    public String helpfile = "";
    public String stylesheetfile = "";
    public String docrootparent = "";
    public boolean nohelp = false;
    public boolean splitindex = false;
    public boolean createindex = true;
    public boolean classuse = false;
    public boolean createtree = true;
    public boolean nodeprecatedlist = false;
    public boolean nonavbar = false;
    private boolean nooverview = false;
    public boolean overview = false;
    public boolean createoverview = false;
    public Set<String> doclintOpts = new LinkedHashSet<String>();
    private boolean allowScriptInComments;
    public final MessageRetriever standardmessage;
    public DocPath topFile = DocPath.empty;
    public ClassDoc currentcd = null;
    private final String versionRBName = "com.sun.tools.javadoc.resources.version";
    private ResourceBundle versionRB;
    private JavaFileManager fileManager;

    public ConfigurationImpl() {
        this.standardmessage = new MessageRetriever(this, "com.sun.tools.oldlets.formats.html.resources.standard");
    }

    @Override
    public String getDocletSpecificBuildDate() {
        if (this.versionRB == null) {
            try {
                this.versionRB = ResourceBundle.getBundle("com.sun.tools.javadoc.resources.version");
            }
            catch (MissingResourceException e) {
                return BUILD_DATE;
            }
        }
        try {
            return this.versionRB.getString("release");
        }
        catch (MissingResourceException e) {
            return BUILD_DATE;
        }
    }

    @Override
    public void setSpecificDocletOptions(String[][] options) {
        this.processSpecificOptions(options);
        if (this.root.specifiedClasses().length > 0) {
            HashMap<String, PackageDoc> map = new HashMap<String, PackageDoc>();
            ClassDoc[] classes = this.root.classes();
            for (int i = 0; i < classes.length; ++i) {
                PackageDoc pd = classes[i].containingPackage();
                if (map.containsKey(pd.name())) continue;
                map.put(pd.name(), pd);
            }
        }
        this.setCreateOverview();
        this.setTopFile(this.root);
    }

    public void processSpecificOptions(String[][] options) {
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = StringUtils.toLowerCase(os[0]);
            if (opt.equals("-footer")) {
                this.footer = os[1];
                continue;
            }
            if (opt.equals("-header")) {
                this.header = os[1];
                continue;
            }
            if (opt.equals("-packagesheader")) {
                this.packagesheader = os[1];
                continue;
            }
            if (opt.equals("-doctitle")) {
                this.doctitle = os[1];
                continue;
            }
            if (opt.equals("-windowtitle")) {
                this.windowtitle = os[1].replaceAll("\\<.*?>", "");
                continue;
            }
            if (opt.equals("-top")) {
                this.top = os[1];
                continue;
            }
            if (opt.equals("-bottom")) {
                this.bottom = os[1];
                continue;
            }
            if (opt.equals("-helpfile")) {
                this.helpfile = os[1];
                continue;
            }
            if (opt.equals("-stylesheetfile")) {
                this.stylesheetfile = os[1];
                continue;
            }
            if (opt.equals("-charset")) {
                this.charset = os[1];
                continue;
            }
            if (opt.equals("-xdocrootparent")) {
                this.docrootparent = os[1];
                continue;
            }
            if (opt.equals("-nohelp")) {
                this.nohelp = true;
                continue;
            }
            if (opt.equals("-splitindex")) {
                this.splitindex = true;
                continue;
            }
            if (opt.equals("-noindex")) {
                this.createindex = false;
                continue;
            }
            if (opt.equals("-use")) {
                this.classuse = true;
                continue;
            }
            if (opt.equals("-notree")) {
                this.createtree = false;
                continue;
            }
            if (opt.equals("-nodeprecatedlist")) {
                this.nodeprecatedlist = true;
                continue;
            }
            if (opt.equals("-nonavbar")) {
                this.nonavbar = true;
                continue;
            }
            if (opt.equals("-nooverview")) {
                this.nooverview = true;
                continue;
            }
            if (opt.equals("-overview")) {
                this.overview = true;
                continue;
            }
            if (opt.equals("-xdoclint")) {
                this.doclintOpts.add("-Xmsgs");
                continue;
            }
            if (opt.startsWith("-xdoclint:")) {
                if ("1.8".equals(System.getProperty("java.specification.version"))) {
                    this.doclintOpts.add(opt.substring(opt.indexOf(":") + 1));
                    continue;
                }
                this.doclintOpts.add("-Xmsgs:" + opt.substring(opt.indexOf(":") + 1));
                continue;
            }
            if (!opt.equals("--allow-script-in-comments")) continue;
            this.allowScriptInComments = true;
        }
    }

    public void initDocLint(RootDoc root) {
        RootDoc realRoot = null;
        if (Proxy.isProxyClass(root.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(root);
            if (handler instanceof Callable) {
                try {
                    realRoot = ((Callable)((Object)handler)).call();
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
        } else {
            realRoot = root;
        }
        if (realRoot != null) {
            try {
                Method initDocLint2 = realRoot.getClass().getMethod("initDocLint", Collection.class, Collection.class);
                initDocLint2.invoke((Object)realRoot, this.doclintOpts, this.tagletManager.getCustomTagNames());
            }
            catch (ReflectiveOperationException ex) {
                try {
                    Method initDocLint3 = realRoot.getClass().getMethod("initDocLint", Collection.class, Collection.class, String.class);
                    initDocLint3.invoke((Object)realRoot, this.doclintOpts, this.tagletManager.getCustomTagNames(), "html5");
                }
                catch (ReflectiveOperationException ex2) {
                    throw new IllegalStateException(ex2);
                }
            }
        }
    }

    @Override
    public int optionLength(String option) {
        int result = -1;
        result = super.optionLength(option);
        if (result > 0) {
            return result;
        }
        if ((option = StringUtils.toLowerCase(option)).equals("-nodeprecatedlist") || option.equals("-noindex") || option.equals("-notree") || option.equals("-nohelp") || option.equals("-splitindex") || option.equals("-serialwarn") || option.equals("-use") || option.equals("-nonavbar") || option.equals("-nooverview") || option.equals("-xdoclint") || option.startsWith("-xdoclint:") || option.equals("--allow-script-in-comments") || option.equals("-suppressmissinglinkwarnings")) {
            return 1;
        }
        if (option.equals("-help")) {
            System.out.println(this.getText("doclet.usage"));
            return 1;
        }
        if (option.equals("-x")) {
            System.out.println(this.getText("doclet.X.usage"));
            return 1;
        }
        if (option.equals("-footer") || option.equals("-header") || option.equals("-packagesheader") || option.equals("-doctitle") || option.equals("-windowtitle") || option.equals("-top") || option.equals("-bottom") || option.equals("-helpfile") || option.equals("-stylesheetfile") || option.equals("-charset") || option.equals("-overview") || option.equals("-xdocrootparent")) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean helpfile = false;
        boolean nohelp = false;
        boolean overview = false;
        boolean nooverview = false;
        boolean splitindex = false;
        boolean noindex = false;
        if (!this.generalValidOptions(options, reporter)) {
            return false;
        }
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = StringUtils.toLowerCase(os[0]);
            if (opt.equals("-helpfile")) {
                if (nohelp) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-helpfile", "-nohelp"));
                    return false;
                }
                if (helpfile) {
                    reporter.printError(this.getText("doclet.Option_reuse", "-helpfile"));
                    return false;
                }
                DocFile help = DocFile.createFileForInput(this, os[1]);
                if (!help.exists()) {
                    reporter.printError(this.getText("doclet.File_not_found", os[1]));
                    return false;
                }
                helpfile = true;
                continue;
            }
            if (opt.equals("-nohelp")) {
                if (helpfile) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-nohelp", "-helpfile"));
                    return false;
                }
                nohelp = true;
                continue;
            }
            if (opt.equals("-xdocrootparent")) {
                try {
                    new URL(os[1]);
                    continue;
                }
                catch (MalformedURLException e) {
                    reporter.printError(this.getText("doclet.MalformedURL", os[1]));
                    return false;
                }
            }
            if (opt.equals("-overview")) {
                if (nooverview) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-overview", "-nooverview"));
                    return false;
                }
                if (overview) {
                    reporter.printError(this.getText("doclet.Option_reuse", "-overview"));
                    return false;
                }
                overview = true;
                continue;
            }
            if (opt.equals("-nooverview")) {
                if (overview) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-nooverview", "-overview"));
                    return false;
                }
                nooverview = true;
                continue;
            }
            if (opt.equals("-splitindex")) {
                if (noindex) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-splitindex", "-noindex"));
                    return false;
                }
                splitindex = true;
                continue;
            }
            if (opt.equals("-noindex")) {
                if (splitindex) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-noindex", "-splitindex"));
                    return false;
                }
                noindex = true;
                continue;
            }
            if (!opt.startsWith("-xdoclint:")) continue;
            if (opt.contains("/")) {
                reporter.printError(this.getText("doclet.Option_doclint_no_qualifiers"));
                return false;
            }
            if (DocLint.isValidOption(opt.replace("-xdoclint:", "-Xmsgs:"))) continue;
            reporter.printError(this.getText("doclet.Option_doclint_invalid_arg"));
            return false;
        }
        return true;
    }

    @Override
    public MessageRetriever getDocletSpecificMsg() {
        return this.standardmessage;
    }

    protected void setTopFile(RootDoc root) {
        if (!this.checkForDeprecation(root)) {
            return;
        }
        if (this.createoverview) {
            this.topFile = DocPaths.OVERVIEW_SUMMARY;
        } else if (this.packages.length == 1 && this.packages[0].name().equals("")) {
            if (root.classes().length > 0) {
                Object[] classarr = root.classes();
                Arrays.sort(classarr);
                ClassDoc cd = this.getValidClass((ClassDoc[])classarr);
                this.topFile = DocPath.forClass(cd);
            }
        } else {
            this.topFile = DocPath.forPackage(this.packages[0]).resolve(DocPaths.PACKAGE_SUMMARY);
        }
    }

    protected ClassDoc getValidClass(ClassDoc[] classarr) {
        if (!this.nodeprecated) {
            return classarr[0];
        }
        for (int i = 0; i < classarr.length; ++i) {
            if (classarr[i].tags("deprecated").length != 0) continue;
            return classarr[i];
        }
        return null;
    }

    protected boolean checkForDeprecation(RootDoc root) {
        ClassDoc[] classarr = root.classes();
        for (int i = 0; i < classarr.length; ++i) {
            if (!this.isGeneratedDoc(classarr[i])) continue;
            return true;
        }
        return false;
    }

    protected void setCreateOverview() {
        if ((this.overview || this.packages.length > 1) && !this.nooverview) {
            this.createoverview = true;
        }
    }

    @Override
    public WriterFactory getWriterFactory() {
        return new WriterFactoryImpl(this);
    }

    @Override
    public Comparator<ProgramElementDoc> getMemberComparator() {
        return null;
    }

    @Override
    public Locale getLocale() {
        return Profiles.getLocale(this.root);
    }

    @Override
    public JavaFileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = Profiles.findFileManager(this.root);
        }
        return this.fileManager;
    }

    @Override
    public boolean showMessage(SourcePosition pos, String key) {
        return true;
    }

    @Override
    public Content newContent() {
        return new ContentBuilder();
    }

    public boolean isAllowScriptInComments() {
        return this.allowScriptInComments;
    }
}

