/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.oldlets.formats.html.AbstractMemberWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.SubWriterHolderWriter;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.builders.MemberSummaryBuilder;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;

public class AnnotationTypeWriterImpl
extends SubWriterHolderWriter
implements AnnotationTypeWriter {
    protected AnnotationTypeDoc annotationType;
    protected Type prev;
    protected Type next;

    public AnnotationTypeWriterImpl(ConfigurationImpl configuration, AnnotationTypeDoc annotationType, Type prevType, Type nextType) throws Exception {
        super(configuration, DocPath.forClass(annotationType));
        this.annotationType = annotationType;
        configuration.currentcd = annotationType.asClassDoc();
        this.prev = prevType;
        this.next = nextType;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink(DocPaths.PACKAGE_SUMMARY, this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClass() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.classLabel);
        return li;
    }

    @Override
    protected Content getNavLinkClassUse() {
        Content linkContent = this.getHyperLink(DocPaths.CLASS_USE.resolve(this.filename), this.useLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree li;
        if (this.prev != null) {
            Content prevLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS, this.prev.asClassDoc()).label(this.prevclassLabel).strong(true));
            li = HtmlTree.LI(prevLink);
        } else {
            li = HtmlTree.LI(this.prevclassLabel);
        }
        return li;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree li;
        if (this.next != null) {
            Content nextLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS, this.next.asClassDoc()).label(this.nextclassLabel).strong(true));
            li = HtmlTree.LI(nextLink);
        } else {
            li = HtmlTree.LI(this.nextclassLabel);
        }
        return li;
    }

    @Override
    public Content getHeader(String header) {
        String pkgname = this.annotationType.containingPackage() != null ? this.annotationType.containingPackage().name() : "";
        String clname = this.annotationType.name();
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(clname));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        ((Content)bodyTree).addContent(HtmlConstants.START_OF_CLASS_DATA);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        if (pkgname.length() > 0) {
            StringContent pkgNameContent = new StringContent(pkgname);
            HtmlTree pkgNameDiv = HtmlTree.DIV(HtmlStyle.subTitle, pkgNameContent);
            div.addContent(pkgNameDiv);
        }
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_HEADER, this.annotationType);
        StringContent headerContent = new StringContent(header);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CLASS_PAGE_HEADING, true, HtmlStyle.title, headerContent);
        ((Content)heading).addContent(this.getTypeParameterLinks(linkInfo));
        div.addContent(heading);
        ((Content)bodyTree).addContent(div);
        return bodyTree;
    }

    @Override
    public Content getAnnotationContentHeader() {
        return this.getContentHeader();
    }

    @Override
    public void addFooter(Content contentTree) {
        contentTree.addContent(HtmlConstants.END_OF_CLASS_DATA);
        this.addNavLinks(false, contentTree);
        this.addBottom(contentTree);
    }

    @Override
    public void printDocument(Content contentTree) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.annotationType), true, contentTree);
    }

    @Override
    public Content getAnnotationInfoTreeHeader() {
        return this.getMemberTreeHeader();
    }

    @Override
    public Content getAnnotationInfo(Content annotationInfoTree) {
        return this.getMemberTree(HtmlStyle.description, annotationInfoTree);
    }

    @Override
    public void addAnnotationTypeSignature(String modifiers, Content annotationInfoTree) {
        annotationInfoTree.addContent(new HtmlTree(HtmlTag.BR));
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.addAnnotationInfo(this.annotationType, (Content)pre);
        ((Content)pre).addContent(modifiers);
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_SIGNATURE, this.annotationType);
        StringContent annotationName = new StringContent(this.annotationType.name());
        Content parameterLinks = this.getTypeParameterLinks(linkInfo);
        if (this.configuration.linksource) {
            this.addSrcLink(this.annotationType, annotationName, pre);
            ((Content)pre).addContent(parameterLinks);
        } else {
            HtmlTree span = HtmlTree.SPAN(HtmlStyle.memberNameLabel, annotationName);
            ((Content)span).addContent(parameterLinks);
            ((Content)pre).addContent(span);
        }
        annotationInfoTree.addContent(pre);
    }

    @Override
    public void addAnnotationTypeDescription(Content annotationInfoTree) {
        if (!this.configuration.nocomment && this.annotationType.inlineTags().length > 0) {
            this.addInlineComment(this.annotationType, annotationInfoTree);
        }
    }

    @Override
    public void addAnnotationTypeTagInfo(Content annotationInfoTree) {
        if (!this.configuration.nocomment) {
            this.addTagsInfo(this.annotationType, annotationInfoTree);
        }
    }

    @Override
    public void addAnnotationTypeDeprecationInfo(Content annotationInfoTree) {
        HtmlTree hr = new HtmlTree(HtmlTag.HR);
        annotationInfoTree.addContent(hr);
        Tag[] deprs = this.annotationType.tags("deprecated");
        if (Util.isDeprecated(this.annotationType)) {
            Tag[] commentTags;
            HtmlTree deprLabel = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, deprLabel);
            if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                ((Content)div).addContent(this.getSpace());
                this.addInlineDeprecatedComment(this.annotationType, deprs[0], div);
            }
            annotationInfoTree.addContent(div);
        }
    }

    @Override
    protected Content getNavLinkTree() {
        Content treeLinkContent = this.getHyperLink(DocPaths.PACKAGE_TREE, this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(treeLinkContent);
        return li;
    }

    @Override
    protected void addSummaryDetailLinks(Content subDiv) {
        try {
            HtmlTree div = HtmlTree.DIV(this.getNavSummaryLinks());
            ((Content)div).addContent(this.getNavDetailLinks());
            subDiv.addContent(div);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocletAbortException(e);
        }
    }

    protected Content getNavSummaryLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.summaryLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        HtmlTree liNavField = new HtmlTree(HtmlTag.LI);
        this.addNavSummaryLink(memberSummaryBuilder, "doclet.navField", 5, liNavField);
        this.addNavGap(liNavField);
        ((Content)ulNav).addContent(liNavField);
        HtmlTree liNavReq = new HtmlTree(HtmlTag.LI);
        this.addNavSummaryLink(memberSummaryBuilder, "doclet.navAnnotationTypeRequiredMember", 7, liNavReq);
        this.addNavGap(liNavReq);
        ((Content)ulNav).addContent(liNavReq);
        HtmlTree liNavOpt = new HtmlTree(HtmlTag.LI);
        this.addNavSummaryLink(memberSummaryBuilder, "doclet.navAnnotationTypeOptionalMember", 6, liNavOpt);
        ((Content)ulNav).addContent(liNavOpt);
        return ulNav;
    }

    protected void addNavSummaryLink(MemberSummaryBuilder builder, String label, int type, Content liNav) {
        AbstractMemberWriter writer = (AbstractMemberWriter)((Object)builder.getMemberSummaryWriter(type));
        if (writer == null) {
            liNav.addContent(this.getResource(label));
        } else {
            liNav.addContent(writer.getNavSummaryLink(null, !builder.getVisibleMemberMap(type).noVisibleMembers()));
        }
    }

    protected Content getNavDetailLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.detailLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        AbstractMemberWriter writerField = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(5));
        AbstractMemberWriter writerOptional = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(6));
        AbstractMemberWriter writerRequired = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(7));
        HtmlTree liNavField = new HtmlTree(HtmlTag.LI);
        if (writerField != null) {
            writerField.addNavDetailLink(this.annotationType.fields().length > 0, (Content)liNavField);
        } else {
            ((Content)liNavField).addContent(this.getResource("doclet.navField"));
        }
        this.addNavGap(liNavField);
        ((Content)ulNav).addContent(liNavField);
        if (writerOptional != null) {
            HtmlTree liNavOpt = new HtmlTree(HtmlTag.LI);
            writerOptional.addNavDetailLink(this.annotationType.elements().length > 0, (Content)liNavOpt);
            ((Content)ulNav).addContent(liNavOpt);
        } else if (writerRequired != null) {
            HtmlTree liNavReq = new HtmlTree(HtmlTag.LI);
            writerRequired.addNavDetailLink(this.annotationType.elements().length > 0, (Content)liNavReq);
            ((Content)ulNav).addContent(liNavReq);
        } else {
            HtmlTree liNav = HtmlTree.LI(this.getResource("doclet.navAnnotationTypeMember"));
            ((Content)ulNav).addContent(liNav);
        }
        return ulNav;
    }

    protected void addNavGap(Content liNav) {
        liNav.addContent(this.getSpace());
        liNav.addContent("|");
        liNav.addContent(this.getSpace());
    }

    @Override
    public AnnotationTypeDoc getAnnotationTypeDoc() {
        return this.annotationType;
    }
}

