/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;

public class AllClassesFrameWriter
extends HtmlDocletWriter {
    protected IndexBuilder indexbuilder;
    final HtmlTree BR = new HtmlTree(HtmlTag.BR);

    public AllClassesFrameWriter(ConfigurationImpl configuration, DocPath filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename);
        this.indexbuilder = indexbuilder;
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        DocPath filename = DocPaths.ALLCLASSES_FRAME;
        try {
            AllClassesFrameWriter allclassgen = new AllClassesFrameWriter(configuration, filename, indexbuilder);
            allclassgen.buildAllClassesFile(true);
            allclassgen.close();
            filename = DocPaths.ALLCLASSES_NOFRAME;
            allclassgen = new AllClassesFrameWriter(configuration, filename, indexbuilder);
            allclassgen.buildAllClassesFile(false);
            allclassgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    protected void buildAllClassesFile(boolean wantFrames) throws IOException {
        String label = this.configuration.getText("doclet.All_Classes");
        HtmlTree body = this.getBody(false, this.getWindowTitle(label));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, this.allclassesLabel);
        ((Content)body).addContent(heading);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        this.addAllClasses(ul, wantFrames);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.indexContainer, ul);
        ((Content)body).addContent(div);
        this.printHtmlDocument(null, false, body);
    }

    protected void addAllClasses(Content content, boolean wantFrames) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character unicode = (Character)this.indexbuilder.elements()[i];
            this.addContents(this.indexbuilder.getMemberList(unicode), wantFrames, content);
        }
    }

    protected void addContents(List<Doc> classlist, boolean wantFrames, Content content) {
        for (int i = 0; i < classlist.size(); ++i) {
            ClassDoc cd = (ClassDoc)classlist.get(i);
            if (!Util.isCoreClass(cd)) continue;
            Content label = this.italicsClassName(cd, false);
            Content linkContent = wantFrames ? this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.ALL_CLASSES_FRAME, cd).label(label).target("classFrame")) : this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.DEFAULT, cd).label(label));
            HtmlTree li = HtmlTree.LI(linkContent);
            content.addContent(li);
        }
    }
}

