/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.javadoc.codesnippet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.source.util.JavacTask;
import com.sun.tools.oldlets.formats.html.HtmlDoclet;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.javadoc.main.Start;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.lang.model.SourceVersion;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.apidesign.javadoc.codesnippet.DelegatingDocErrorReporter;
import org.apidesign.javadoc.codesnippet.Snippets;

public final class Doclet
implements jdk.javadoc.doclet.Doclet {
    private static Snippets snippets;
    private Locale locale;
    private Reporter reporter;
    private static List<String> allOptions;
    private static DocErrorReporter docErrorReporter;

    public Doclet() {
        Doclet.enableJavacAccess();
    }

    public static boolean start(RootDoc root) throws Configuration.Fault {
        HtmlDoclet.sharedInstanceForOptions.root = root;
        HtmlDoclet.sharedInstanceForOptions.setOptions(root.options());
        HtmlDoclet.sharedInstanceForOptions.processSpecificOptions(root.options());
        HtmlDoclet.sharedInstanceForOptions.initDocLint(root);
        for (ClassDoc classDoc : root.classes()) {
            snippets.fixCodesnippets(root, classDoc);
            for (MethodDoc methodDoc : classDoc.methods()) {
                snippets.fixCodesnippets(classDoc, methodDoc);
            }
            for (MemberDoc memberDoc : classDoc.fields()) {
                snippets.fixCodesnippets(classDoc, memberDoc);
            }
            for (MemberDoc memberDoc : classDoc.constructors()) {
                snippets.fixCodesnippets(classDoc, memberDoc);
            }
            if (!(classDoc instanceof AnnotationTypeDoc)) continue;
            for (MemberDoc memberDoc : ((AnnotationTypeDoc)classDoc).elements()) {
                snippets.fixCodesnippets(classDoc, memberDoc);
            }
        }
        for (Doc doc : root.specifiedPackages()) {
            snippets.fixCodesnippets(root, doc);
        }
        RootDoc rootProxy = Doclet.hideElements(RootDoc.class, root);
        return HtmlDoclet.start(rootProxy);
    }

    public static int optionLength(String option) {
        if (SnippetOption.SNIPPETPATH.matches(option)) {
            return 2;
        }
        if (SnippetOption.SNIPPETCLASSES.matches(option)) {
            return 2;
        }
        if (SnippetOption.MAXLINELENGTH.matches(option)) {
            return 2;
        }
        if (SnippetOption.VERIFYSINCEPRESENT.matches(option)) {
            return 1;
        }
        if (SnippetOption.VERIFYSINCE.matches(option)) {
            return 2;
        }
        if (SnippetOption.HIDINGANNOTATION.matches(option)) {
            return 2;
        }
        return HtmlDoclet.optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        if (snippets == null) {
            snippets = new Snippets(reporter);
        }
        for (String[] optionAndParams : options) {
            int i;
            Boolean visible = null;
            if (SnippetOption.SOURCEPATH.matches(optionAndParams[0])) {
                visible = true;
            }
            if (SnippetOption.SNIPPETPATH.matches(optionAndParams[0])) {
                visible = false;
            }
            if (visible != null) {
                for (i = 1; i < optionAndParams.length; ++i) {
                    for (String elem : optionAndParams[i].split(File.pathSeparator)) {
                        snippets.addPath(Doclet.findAbsolutePath(elem), visible);
                    }
                }
            }
            if (SnippetOption.SNIPPETCLASSES.matches(optionAndParams[0])) {
                for (i = 1; i < optionAndParams.length; ++i) {
                    snippets.addClasses(optionAndParams[i]);
                }
            }
            if (SnippetOption.MAXLINELENGTH.matches(optionAndParams[0]) && optionAndParams.length > 1) {
                snippets.setMaxLineLength(optionAndParams[1]);
            }
            if (SnippetOption.VERIFYSINCEPRESENT.matches(optionAndParams[0]) || SnippetOption.VERIFYSINCE.matches(optionAndParams[0])) {
                if (optionAndParams.length > 1) {
                    snippets.setVerifySince(optionAndParams[1]);
                } else {
                    snippets.setVerifySince("");
                }
            }
            if (SnippetOption.HIDINGANNOTATION.matches(optionAndParams[0])) {
                snippets.addHiddenAnnotation(optionAndParams[1]);
            }
            if (!SnippetOption.ENCODING.matches(optionAndParams[0])) continue;
            snippets.setEncoding(optionAndParams[1]);
        }
        return HtmlDoclet.validOptions(options, reporter);
    }

    private static Path findAbsolutePath(String elem) {
        File file = new File(elem);
        if (file.isAbsolute()) {
            return file.toPath();
        }
        for (File root = new File(".").getAbsoluteFile(); !file.exists() && root != null; root = root.getParentFile()) {
            file = new File(root, elem);
        }
        return file.getAbsoluteFile().toPath();
    }

    public static LanguageVersion languageVersion() {
        return HtmlDoclet.languageVersion();
    }

    private static <T> T hideElement(Class<T> clazz, Object obj) {
        return Doclet.hideElements(clazz, clazz.cast(obj));
    }

    private static <T> T hideElements(Class<T> clazz, T obj) {
        if (!Doclet.toBeHiddenInterface(clazz)) {
            return obj;
        }
        Class<Object> c = clazz;
        if (clazz.isAssignableFrom(ClassDoc.class) && obj instanceof ClassDoc && ((ClassDoc)obj).isAnnotationType()) {
            c = AnnotationTypeDoc.class;
        }
        if (clazz.isAssignableFrom(SeeTag.class) && obj instanceof SeeTag) {
            c = SeeTag.class;
        }
        DocProxy<T> h = new DocProxy<T>(obj);
        return clazz.cast(Proxy.newProxyInstance(obj.getClass().getClassLoader(), new Class[]{c}, h));
    }

    private static boolean toBeHiddenInterface(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.getPackage() == RootDoc.class.getPackage()) {
            return true;
        }
        for (Class<?> interfce : type.getInterfaces()) {
            if (!Doclet.toBeHiddenInterface(interfce)) continue;
            return true;
        }
        return Doclet.toBeHiddenInterface(type.getSuperclass());
    }

    public void init(Locale locale, Reporter reporter) {
        this.locale = locale;
        this.reporter = reporter;
        docErrorReporter = new DelegatingDocErrorReporter(reporter);
    }

    public String getName() {
        return "CodesnippetDoclet";
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        jdk.javadoc.doclet.Doclet standardDoclet;
        try {
            standardDoclet = (jdk.javadoc.doclet.Doclet)Class.forName("jdk.javadoc.doclet.StandardDoclet").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
        HashSet<Doclet.Option> all = new HashSet<Doclet.Option>();
        all.addAll(EnumSet.allOf(SnippetOption.class));
        for (Doclet.Option option : standardDoclet.getSupportedOptions()) {
            all.add(new DelegatingOption(option));
        }
        return all;
    }

    public SourceVersion getSupportedSourceVersion() {
        throw new UnsupportedOperationException();
    }

    public boolean run(DocletEnvironment environment) {
        Start start = new Start(this.getName());
        boolean result = start.begin(Doclet.class, allOptions, Collections.emptyList());
        return result;
    }

    private static void enableJavacAccess() {
        try (StandardJavaFileManager fm = ToolProvider.getSystemJavaCompiler().getStandardFileManager(null, null, null);){
            ForwardingJavaFileManager<StandardJavaFileManager> fm2 = new ForwardingJavaFileManager<StandardJavaFileManager>(fm){

                @Override
                public ClassLoader getClassLoader(JavaFileManager.Location location) {
                    return Doclet.class.getClassLoader();
                }
            };
            SimpleJavaFileObject jfo = new SimpleJavaFileObject(new URI("mem://Whatever.java"), JavaFileObject.Kind.SOURCE){

                @Override
                public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                    return "";
                }
            };
            ((JavacTask)ToolProvider.getSystemJavaCompiler().getTask(null, fm2, null, Arrays.asList("-XDaccessInternalAPI"), null, Arrays.asList(jfo))).analyze();
        }
        catch (IOException | IllegalStateException | URISyntaxException exception) {
            // empty catch block
        }
    }

    private static class DocProxy<T>
    implements InvocationHandler,
    Callable<T> {
        private final T obj;

        public DocProxy(T obj) {
            this.obj = obj;
        }

        @Override
        public T call() {
            return this.obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> componentType;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) continue;
                    InvocationHandler handler = null;
                    try {
                        handler = Proxy.getInvocationHandler(args[i]);
                    }
                    catch (IllegalArgumentException ignore) {
                        continue;
                    }
                    if (!(handler instanceof DocProxy)) continue;
                    args[i] = ((DocProxy)handler).obj;
                }
            }
            boolean doSkip = true;
            if (method.getName().equals("allClasses")) {
                doSkip = false;
            }
            Object ret = method.invoke(this.obj, args);
            Class<?> requestedType = method.getReturnType();
            if (requestedType.isArray() && Doclet.toBeHiddenInterface(componentType = requestedType.getComponentType())) {
                Object[] arr = (Object[])ret;
                ArrayList<Object> copy = new ArrayList<Object>();
                for (Object element : arr) {
                    boolean skip = false;
                    for (String name : this.findAnnotationsNames(element)) {
                        if (!snippets.isHiddingAnnotation(name)) continue;
                        skip = doSkip;
                        break;
                    }
                    if (skip) continue;
                    copy.add(Doclet.hideElement(componentType, element));
                }
                Object[] reqArr = (Object[])Array.newInstance(requestedType.getComponentType(), 0);
                return copy.toArray(reqArr);
            }
            if (ret instanceof Object && Doclet.toBeHiddenInterface(ret.getClass())) {
                ret = Doclet.hideElement(ret.getClass().getInterfaces()[0], ret);
            }
            return ret;
        }

        private AnnotationDesc[] findAnnotations(Object element) {
            if (element instanceof ProgramElementDoc) {
                ProgramElementDoc ped = (ProgramElementDoc)element;
                return ped.annotations();
            }
            if (element instanceof PackageDoc) {
                return ((PackageDoc)element).annotations();
            }
            return new AnnotationDesc[0];
        }

        private Iterable<String> findAnnotationsNames(Object element) {
            TreeSet<String> names = new TreeSet<String>();
            for (AnnotationDesc desc : this.findAnnotations(element)) {
                try {
                    String name = desc.annotationType().qualifiedName();
                    names.add(name);
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                }
            }
            return names;
        }
    }

    private static class DelegatingOption
    implements Doclet.Option {
        private final Doclet.Option delegate;

        DelegatingOption(Doclet.Option delegate) {
            this.delegate = delegate;
        }

        @Override
        public List<String> getNames() {
            return this.delegate.getNames();
        }

        @Override
        public boolean matches(String option) {
            return this.delegate.matches(option);
        }

        @Override
        public int getArgumentCount() {
            return this.delegate.getArgumentCount();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return this.delegate.getKind();
        }

        @Override
        public String getParameters() {
            return this.delegate.getParameters();
        }

        @Override
        public boolean process(String option, List<String> arguments) {
            ArrayList<String> all = new ArrayList<String>();
            all.add(option);
            all.addAll(arguments);
            if (allOptions == null) {
                allOptions = all;
            }
            return Doclet.validOptions(new String[][]{all.subList(0, this.getArgumentCount() + 1).toArray(new String[0])}, docErrorReporter);
        }
    }

    static enum SnippetOption implements Doclet.Option
    {
        CLASSPATH(2, "-classpath"),
        SOURCEPATH(2, "-sourcepath"),
        SNIPPETPATH(2, "-snippetpath"),
        SNIPPETCLASSES(2, "-snippetclasses"),
        MAXLINELENGTH(2, "-maxLineLength"),
        HIDINGANNOTATION(2, "-hiddingannotation"),
        VERIFYSINCE(1, "-verifysince"),
        VERIFYSINCEPRESENT(1, "-verifysincepresent"),
        ENCODING(2, "-encoding"),
        SUPPRESSMISSINGLINKWARNINGS(1, "-suppressmissinglinkwarnings");

        final int length;
        final String name;

        private SnippetOption(int length, String name) {
            this.length = length;
            this.name = name;
        }

        @Override
        public boolean matches(String option) {
            return option.equals(this.name);
        }

        @Override
        public int getArgumentCount() {
            return this.length - 1;
        }

        @Override
        public String getDescription() {
            return this.name;
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.STANDARD;
        }

        @Override
        public List<String> getNames() {
            return Arrays.asList(this.name);
        }

        @Override
        public String getParameters() {
            return null;
        }

        @Override
        public boolean process(String option, List<String> arguments) {
            ArrayList<String> all = new ArrayList<String>();
            all.add(option);
            all.addAll(arguments);
            if (allOptions == null) {
                allOptions = all;
            }
            return Doclet.validOptions(new String[][]{all.subList(0, this.length).toArray(new String[0])}, docErrorReporter);
        }
    }
}

