/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.javadoc.main;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.oldlets.javadoc.main.DocEnv;
import com.sun.tools.oldlets.javadoc.main.JavadocClassFinder;
import com.sun.tools.oldlets.javadoc.main.JavadocEnter;
import com.sun.tools.oldlets.javadoc.main.JavadocMemberEnter;
import com.sun.tools.oldlets.javadoc.main.JavadocTodo;
import com.sun.tools.oldlets.javadoc.main.Messager;
import com.sun.tools.oldlets.javadoc.main.ModifierFilter;
import com.sun.tools.oldlets.javadoc.main.RootDocImpl;
import com.sun.tools.oldlets.javadoc.main.SymbolKind;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JavadocTool
extends JavaCompiler {
    DocEnv docenv;
    final Messager messager;
    final JavadocClassFinder javadocFinder;
    final Enter javadocEnter;
    final Set<JavaFileObject> uniquefiles;
    static final boolean surrogatesSupported = JavadocTool.surrogatesSupported();

    protected JavadocTool(Context context) {
        super(context);
        this.messager = Messager.instance0(context);
        this.javadocFinder = JavadocClassFinder.instance(context);
        this.javadocEnter = JavadocEnter.instance(context);
        this.uniquefiles = new HashSet<JavaFileObject>();
    }

    @Override
    protected boolean keepComments() {
        return true;
    }

    public static JavadocTool make0(Context context) {
        JavadocClassFinder.preRegister(context);
        JavadocEnter.preRegister(context);
        JavadocMemberEnter.preRegister(context);
        JavadocTodo.preRegister(context);
        Messager.instance0(context);
        return new JavadocTool(context);
    }

    public RootDocImpl getRootDocImpl(String doclocale, String encoding, ModifierFilter filter, List<String> args, List<String[]> options, Iterable<? extends JavaFileObject> fileObjects, boolean breakiterator, List<String> subPackages, List<String> excludedPackages, boolean docClasses, boolean legacyDoclet, boolean quiet) throws IOException {
        this.docenv = DocEnv.instance(this.context);
        this.docenv.showAccess = filter;
        this.docenv.quiet = quiet;
        this.docenv.breakiterator = breakiterator;
        this.docenv.setLocale(doclocale);
        this.docenv.setEncoding(encoding);
        this.docenv.docClasses = docClasses;
        this.docenv.legacyDoclet = legacyDoclet;
        Object sc = docClasses ? SymbolKind.getStaticOrElse(Symbol.Completer.class, "NULL_COMPLETER", null) : SymbolKind.getOrElse(this.docenv.finder.getClass().getSuperclass(), this.docenv.finder, "sourceCompleter", null);
        if (sc != null) {
            SymbolKind.setOrNothing(this.javadocFinder, "sourceCompleter", sc);
        }
        if (docClasses) {
            for (String arg : args) {
                if (this.isValidPackageName(arg)) continue;
                this.docenv.error(null, "main.illegal_class_name", arg);
            }
            if (this.messager.nerrors() != 0) {
                return null;
            }
            return new RootDocImpl(this.docenv, args, options);
        }
        ListBuffer<JCTree.JCCompilationUnit> classTrees = new ListBuffer<JCTree.JCCompilationUnit>();
        Set<Object> includedPackages = new LinkedHashSet();
        try {
            StandardJavaFileManager fm = this.docenv.fileManager instanceof StandardJavaFileManager ? (StandardJavaFileManager)this.docenv.fileManager : null;
            LinkedHashSet<String> packageNames = new LinkedHashSet<String>();
            for (String arg : args) {
                if (fm != null && arg.endsWith(".java") && new File(arg).exists()) {
                    if (new File(arg).getName().equals("module-info.java")) {
                        this.docenv.warning(null, "main.file_ignored", arg);
                        continue;
                    }
                    this.parse(fm.getJavaFileObjects(arg), classTrees, true);
                    continue;
                }
                if (this.isValidPackageName(arg)) {
                    packageNames.add(arg);
                    continue;
                }
                if (arg.endsWith(".java")) {
                    if (fm == null) {
                        throw new IllegalArgumentException();
                    }
                    this.docenv.error(null, "main.file_not_found", arg);
                    continue;
                }
                this.docenv.error(null, "main.illegal_package_name", arg);
            }
            this.parse(fileObjects, classTrees, true);
            Object m = this.modules();
            boolean multiModuleMode = false;
            if (m != null) {
                SymbolKind.invokeOrNull(m, "initModules", classTrees.toList());
                multiModuleMode = SymbolKind.getOrElse(null, m, "multiModuleMode", false);
            }
            StandardLocation location = multiModuleMode ? StandardLocation.valueOf("MODULE_SOURCE_PATH") : (this.docenv.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH);
            PackageTable t = new PackageTable(this.docenv.fileManager, location).packages(packageNames).subpackages(subPackages, excludedPackages);
            includedPackages = t.getIncludedPackages();
            ListBuffer<JCTree.JCCompilationUnit> allTrees = new ListBuffer<JCTree.JCCompilationUnit>();
            for (String string : includedPackages) {
                List<JavaFileObject> files = t.getFiles(string);
                this.docenv.notice("main.Loading_source_files_for_package", string);
                if (files.isEmpty()) {
                    this.messager.warning(Messager.NOPOS, "main.no_source_files_for_package", string);
                }
                allTrees.addAll((Collection<JCTree.JCCompilationUnit>)classTrees);
                this.parse(files, allTrees, false);
            }
            if (m != null) {
                SymbolKind.invokeOrNull(m, "newRound", new Object[0]);
                SymbolKind.invokeOrNull(m, "initModules", allTrees.toList());
            }
            if (this.messager.nerrors() != 0) {
                return null;
            }
            this.docenv.notice("main.Building_tree");
            this.javadocEnter.main(classTrees.toList().appendList(allTrees.toList()));
        }
        catch (Abort abort) {
            // empty catch block
        }
        if (this.messager.nerrors() != 0) {
            return null;
        }
        return new RootDocImpl(this.docenv, this.listClasses(classTrees.toList()), List.from(includedPackages), options);
    }

    private Object modules() {
        try {
            Class<?> Modules2 = Class.forName("com.sun.tools.javac.comp.Modules");
            return SymbolKind.invokeStaticOrNull(Modules2, "instance", this.context);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    boolean isValidPackageName(String s) {
        int index;
        while ((index = s.indexOf(46)) != -1) {
            if (!JavadocTool.isValidClassName(s.substring(0, index))) {
                return false;
            }
            s = s.substring(index + 1);
        }
        return JavadocTool.isValidClassName(s);
    }

    private void parse(Iterable<? extends JavaFileObject> files, ListBuffer<JCTree.JCCompilationUnit> trees, boolean trace) {
        for (JavaFileObject javaFileObject : files) {
            if (!this.uniquefiles.add(javaFileObject)) continue;
            if (trace) {
                this.docenv.notice("main.Loading_source_file", javaFileObject.getName());
            }
            trees.append(this.parse(javaFileObject));
        }
    }

    private static boolean surrogatesSupported() {
        try {
            boolean b = Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
    }

    public static boolean isValidClassName(String s) {
        if (s.length() < 1) {
            return false;
        }
        if (s.equals("package-info")) {
            return true;
        }
        if (surrogatesSupported) {
            int cp = s.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                return false;
            }
            for (int j = Character.charCount(cp); j < s.length(); j += Character.charCount(cp)) {
                cp = s.codePointAt(j);
                if (Character.isJavaIdentifierPart(cp)) continue;
                return false;
            }
        } else {
            if (!Character.isJavaIdentifierStart(s.charAt(0))) {
                return false;
            }
            for (int j = 1; j < s.length(); ++j) {
                if (Character.isJavaIdentifierPart(s.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    List<JCTree.JCClassDecl> listClasses(List<JCTree.JCCompilationUnit> trees) {
        ListBuffer<JCTree.JCClassDecl> result = new ListBuffer<JCTree.JCClassDecl>();
        for (JCTree.JCCompilationUnit t : trees) {
            for (JCTree def : t.defs) {
                if (!def.hasTag(JCTree.Tag.CLASSDEF)) continue;
                result.append((JCTree.JCClassDecl)def);
            }
        }
        return result.toList();
    }

    class PackageTable {
        private final Map<String, Entry> entries = new LinkedHashMap<String, Entry>();
        private final Set<String> includedPackages = new LinkedHashSet<String>();
        private final JavaFileManager fm;
        private final JavaFileManager.Location location;
        private final Set<JavaFileObject.Kind> sourceKinds = EnumSet.of(JavaFileObject.Kind.SOURCE);

        PackageTable(JavaFileManager fm, JavaFileManager.Location locn) {
            this.fm = fm;
            this.location = locn;
            this.getEntry((String)"").excluded = false;
        }

        PackageTable packages(Collection<String> packageNames) {
            this.includedPackages.addAll(packageNames);
            return this;
        }

        PackageTable subpackages(Collection<String> packageNames, Collection<String> excludePackageNames) throws IOException {
            for (String p : excludePackageNames) {
                this.getEntry((String)p).excluded = true;
            }
            for (String packageName : packageNames) {
                JavaFileManager.Location packageLocn = this.getLocation(packageName);
                for (JavaFileObject fo : this.fm.list(packageLocn, packageName, this.sourceKinds, true)) {
                    String binaryName = this.fm.inferBinaryName(packageLocn, fo);
                    String pn = this.getPackageName(binaryName);
                    String simpleName = this.getSimpleName(binaryName);
                    Entry e = this.getEntry(pn);
                    if (e.isExcluded() || !JavadocTool.isValidClassName(simpleName)) continue;
                    this.includedPackages.add(pn);
                    e.files = e.files == null ? List.of(fo) : e.files.prepend(fo);
                }
            }
            return this;
        }

        Set<String> getIncludedPackages() {
            return this.includedPackages;
        }

        List<JavaFileObject> getFiles(String packageName) throws IOException {
            Entry e = this.getEntry(packageName);
            if (e.files != null) {
                return e.files;
            }
            ListBuffer<JavaFileObject> lb = new ListBuffer<JavaFileObject>();
            JavaFileManager.Location packageLocn = this.getLocation(packageName);
            for (JavaFileObject fo : this.fm.list(packageLocn, packageName, this.sourceKinds, false)) {
                String binaryName = this.fm.inferBinaryName(packageLocn, fo);
                String simpleName = this.getSimpleName(binaryName);
                if (!JavadocTool.isValidClassName(simpleName)) continue;
                lb.append(fo);
            }
            return lb.toList();
        }

        private JavaFileManager.Location getLocation(String packageName) throws IOException {
            if (this.location.toString().equals("MODULE_SOURCE_PATH")) {
                Name pack = JavadocTool.this.names.fromString(packageName);
                List all = (List)SymbolKind.invokeOrNull(JavadocTool.this.modules(), "allModules", new Object[0]);
                for (Object msym : all) {
                    Scope members;
                    boolean empty;
                    Symbol.PackageSymbol p = (Symbol.PackageSymbol)SymbolKind.invokeOrNull((Object)JavadocTool.this.syms, "getPackage", pack);
                    if (p == null || (empty = ((Boolean)SymbolKind.invokeOrNull((Object)(members = (Scope)SymbolKind.invokeOrNull((Object)p, "members", new Object[0])), "isEmpty", new Object[0])).booleanValue())) continue;
                    String name = SymbolKind.getOrElse(null, msym, "name", null).toString();
                    return (JavaFileManager.Location)SymbolKind.invokeOrNull((Object)this.fm, "getLocationForModule", this.location, name);
                }
                return null;
            }
            return this.location;
        }

        private Entry getEntry(String name) {
            Entry e = this.entries.get(name);
            if (e == null) {
                e = new Entry(name);
                this.entries.put(name, e);
            }
            return e;
        }

        private String getPackageName(String name) {
            int lastDot = name.lastIndexOf(".");
            return lastDot == -1 ? "" : name.substring(0, lastDot);
        }

        private String getSimpleName(String name) {
            int lastDot = name.lastIndexOf(".");
            return lastDot == -1 ? name : name.substring(lastDot + 1);
        }

        class Entry {
            final String name;
            Boolean excluded;
            List<JavaFileObject> files;

            Entry(String name) {
                this.name = name;
            }

            boolean isExcluded() {
                if (this.excluded == null) {
                    this.excluded = PackageTable.this.getEntry(PackageTable.this.getPackageName(this.name)).isExcluded();
                }
                return this.excluded;
            }
        }
    }
}

