/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.javadoc.main;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JavaScriptScanner {
    private Reporter reporter;
    protected char[] buf;
    protected int bp;
    protected int buflen;
    protected char ch;
    private boolean newline = true;
    Map<String, TagParser> tagParsers;
    Set<String> eventAttrs;
    Set<String> uriAttrs;

    public JavaScriptScanner() {
        this.initTagParsers();
        this.initEventAttrs();
        this.initURIAttrs();
    }

    public void parse(String comment, Reporter r) {
        this.reporter = r;
        String c = comment;
        this.buf = new char[c.length() + 1];
        c.getChars(0, c.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.newline = true;
        this.nextChar();
        this.blockContent();
        this.blockTags();
    }

    private void checkHtmlTag(String tag) {
        if (tag.equalsIgnoreCase("script")) {
            this.reporter.report();
        }
    }

    private void checkHtmlAttr(String name, String value) {
        String n = name.toLowerCase(Locale.ENGLISH);
        if (this.eventAttrs.contains(n) || this.uriAttrs.contains(n) && value != null && value.toLowerCase(Locale.ENGLISH).trim().startsWith("javascript:")) {
            this.reporter.report();
        }
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': 
            case '\f': 
            case '\r': {
                this.newline = true;
            }
        }
    }

    protected void blockContent() {
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(null);
                    continue block9;
                }
                case '<': {
                    this.html();
                    continue block9;
                }
                case '>': {
                    this.newline = false;
                    this.nextChar();
                    continue block9;
                }
                case '{': {
                    this.inlineTag(null);
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    this.newline = false;
                    this.nextChar();
                    continue block9;
                }
            }
        }
    }

    protected void blockTags() {
        while (this.ch == '@') {
            this.blockTag();
        }
    }

    protected void blockTag() {
        int p = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                String name = this.readTagName();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    this.blockContent();
                } else {
                    switch (tp.getKind()) {
                        case BLOCK: {
                            tp.parse(p);
                            return;
                        }
                        case INLINE: {
                            return;
                        }
                    }
                }
            }
            this.blockContent();
        }
        catch (ParseException e) {
            this.blockContent();
        }
    }

    protected void inlineTag(Void list) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            this.inlineTag();
        }
    }

    protected void inlineTag() {
        int p = this.bp - 1;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                String name = this.readTagName();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    this.skipWhitespace();
                    this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                    this.nextChar();
                } else {
                    this.skipWhitespace();
                    if (tp.getKind() == TagParser.Kind.INLINE) {
                        tp.parse(p);
                    } else {
                        this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                        this.nextChar();
                    }
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void inlineText(WhitespaceRetentionPolicy whitespacePolicy) throws ParseException {
        switch (whitespacePolicy) {
            case REMOVE_ALL: {
                this.skipWhitespace();
                break;
            }
            case REMOVE_FIRST_SPACE: {
                if (this.ch != ' ') break;
                this.nextChar();
                break;
            }
        }
        int pos = this.bp;
        int depth = 1;
        block11: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth == 0) {
                        return;
                    }
                    this.newline = false;
                    break;
                }
                case '@': {
                    if (this.newline) break block11;
                    this.newline = false;
                    break;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        throw new ParseException("dc.unterminated.inline.tag");
    }

    protected void reference(boolean allowMember) throws ParseException {
        int pos = this.bp;
        int depth = 0;
        block8: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    if (depth != 0) break;
                    break block8;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++depth;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --depth;
                    break;
                }
                case '}': {
                    if (this.bp == pos) {
                        return;
                    }
                    this.newline = false;
                    break block8;
                }
                case '@': {
                    if (this.newline) break block8;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (depth != 0) {
            throw new ParseException("dc.unterminated.signature");
        }
    }

    protected void identifier() throws ParseException {
        this.skipWhitespace();
        int pos = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            this.readJavaIdentifier();
            return;
        }
        throw new ParseException("dc.identifier.expected");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void quotedString() {
        int pos = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return;
                }
                case '@': {
                    if (!this.newline) break;
                    return;
                }
            }
            this.nextChar();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void inlineWord() {
        int pos = this.bp;
        int depth = 0;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': {
                    this.newline = true;
                }
                case '\t': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return;
                }
                case '@': {
                    if (this.newline) {
                        return;
                    }
                }
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    if (depth == 0) return;
                    if (--depth != 0) break;
                    return;
                }
            }
            this.newline = false;
            this.nextChar();
        }
    }

    private void inlineContent() {
        this.skipWhitespace();
        int pos = this.bp;
        int depth = 1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(null);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.html();
                    continue block9;
                }
                case '{': {
                    this.newline = false;
                    ++depth;
                    this.nextChar();
                    continue block9;
                }
                case '}': {
                    this.newline = false;
                    if (--depth == 0) {
                        this.nextChar();
                        return;
                    }
                    this.nextChar();
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    this.nextChar();
                    continue block9;
                }
            }
        }
    }

    protected void entity(Void list) {
        this.newline = false;
        this.entity();
    }

    protected void entity() {
        this.nextChar();
        String name = null;
        if (this.ch == '#') {
            int namep = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                name = new String(this.buf, namep, this.bp - namep);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    name = new String(this.buf, namep, this.bp - namep);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            name = this.readIdentifier();
        }
        if (name != null) {
            if (this.ch != ';') {
                return;
            }
            this.nextChar();
        }
    }

    protected void html() {
        int p = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            String name = this.readIdentifier();
            this.checkHtmlTag(name);
            this.htmlAttrs();
            if (this.ch == '/') {
                this.nextChar();
            }
            if (this.ch == '>') {
                this.nextChar();
                return;
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    return;
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int dash = 0;
                        while (this.ch == '-') {
                            ++dash;
                            this.nextChar();
                        }
                        if (dash >= 2 && this.ch == '>') {
                            this.nextChar();
                            return;
                        }
                        this.nextChar();
                    }
                }
            }
        }
        this.bp = p + 1;
        this.ch = this.buf[this.bp];
    }

    protected void htmlAttrs() {
        this.skipWhitespace();
        block0: while (this.isIdentifierStart(this.ch)) {
            int namePos = this.bp;
            String name = this.readAttributeName();
            this.skipWhitespace();
            StringBuilder value = new StringBuilder();
            if (this.ch == '=') {
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    char quote = this.ch;
                    this.nextChar();
                    while (this.bp < this.buflen && this.ch != quote) {
                        if (this.newline && this.ch == '@') break block0;
                        value.append(this.ch);
                        this.nextChar();
                    }
                    this.nextChar();
                } else {
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        value.append(this.ch);
                        this.nextChar();
                    }
                }
                this.skipWhitespace();
            }
            this.checkHtmlAttr(name, value.toString());
        }
    }

    protected void attrValueChar(Void list) {
        switch (this.ch) {
            case '&': {
                this.entity(list);
                break;
            }
            case '{': {
                this.inlineTag(list);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected boolean isIdentifierStart(char ch) {
        return Character.isUnicodeIdentifierStart(ch);
    }

    protected String readIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return new String(this.buf, start, this.bp - start);
    }

    protected String readAttributeName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '-')) {
            this.nextChar();
        }
        return new String(this.buf, start, this.bp - start);
    }

    protected String readTagName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.' || this.ch == '-' || this.ch == ':')) {
            this.nextChar();
        }
        return new String(this.buf, start, this.bp - start);
    }

    protected boolean isJavaIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    protected String readJavaIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return new String(this.buf, start, this.bp - start);
    }

    protected boolean isDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    protected boolean isHexDigit(char ch) {
        return '0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    protected boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    protected void skipWhitespace() {
        while (this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    String newString(int start, int end) {
        return new String(this.buf, start, end - start);
    }

    private void initTagParsers() {
        TagParser[] parsers = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, "author"){

            @Override
            public void parse(int pos) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "code", true){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                JavaScriptScanner.this.nextChar();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "deprecated"){

            @Override
            public void parse(int pos) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "docRoot"){

            @Override
            public void parse(int pos) throws ParseException {
                if (JavaScriptScanner.this.ch == '}') {
                    JavaScriptScanner.this.nextChar();
                    return;
                }
                JavaScriptScanner.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                JavaScriptScanner.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, "exception"){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.reference(false);
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "hidden"){

            @Override
            public void parse(int pos) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "index"){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                if (JavaScriptScanner.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                if (JavaScriptScanner.this.ch == '\"') {
                    JavaScriptScanner.this.quotedString();
                } else {
                    JavaScriptScanner.this.inlineWord();
                }
                JavaScriptScanner.this.skipWhitespace();
                if (JavaScriptScanner.this.ch != '}') {
                    JavaScriptScanner.this.inlineContent();
                } else {
                    JavaScriptScanner.this.nextChar();
                }
            }
        }, new TagParser(TagParser.Kind.INLINE, "inheritDoc"){

            @Override
            public void parse(int pos) throws ParseException {
                if (JavaScriptScanner.this.ch == '}') {
                    JavaScriptScanner.this.nextChar();
                    return;
                }
                JavaScriptScanner.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                JavaScriptScanner.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, "link"){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.reference(true);
                JavaScriptScanner.this.inlineContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "linkplain"){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.reference(true);
                JavaScriptScanner.this.inlineContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "literal", true){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                JavaScriptScanner.this.nextChar();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "param"){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                boolean typaram = false;
                if (JavaScriptScanner.this.ch == '<') {
                    typaram = true;
                    JavaScriptScanner.this.nextChar();
                }
                JavaScriptScanner.this.identifier();
                if (typaram) {
                    if (JavaScriptScanner.this.ch != '>') {
                        throw new ParseException("dc.gt.expected");
                    }
                    JavaScriptScanner.this.nextChar();
                }
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "return"){

            @Override
            public void parse(int pos) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "see"){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                switch (JavaScriptScanner.this.ch) {
                    case '\"': {
                        JavaScriptScanner.this.quotedString();
                        JavaScriptScanner.this.skipWhitespace();
                        if (JavaScriptScanner.this.ch != '@' && (JavaScriptScanner.this.ch != '\u001a' || JavaScriptScanner.this.bp != JavaScriptScanner.this.buf.length - 1)) break;
                        return;
                    }
                    case '<': {
                        JavaScriptScanner.this.blockContent();
                        return;
                    }
                    case '@': {
                        if (!JavaScriptScanner.this.newline) break;
                        throw new ParseException("dc.no.content");
                    }
                    case '\u001a': {
                        if (JavaScriptScanner.this.bp != JavaScriptScanner.this.buf.length - 1) break;
                        throw new ParseException("dc.no.content");
                    }
                    default: {
                        if (!JavaScriptScanner.this.isJavaIdentifierStart(JavaScriptScanner.this.ch) && JavaScriptScanner.this.ch != '#') break;
                        JavaScriptScanner.this.reference(true);
                        JavaScriptScanner.this.blockContent();
                    }
                }
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, "@serialData"){

            @Override
            public void parse(int pos) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "serialField"){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.identifier();
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.reference(false);
                if (JavaScriptScanner.this.isWhitespace(JavaScriptScanner.this.ch)) {
                    JavaScriptScanner.this.skipWhitespace();
                    JavaScriptScanner.this.blockContent();
                }
            }
        }, new TagParser(TagParser.Kind.BLOCK, "serial"){

            @Override
            public void parse(int pos) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "since"){

            @Override
            public void parse(int pos) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "throws"){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.reference(false);
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "value"){

            @Override
            public void parse(int pos) throws ParseException {
                JavaScriptScanner.this.reference(true);
                JavaScriptScanner.this.skipWhitespace();
                if (JavaScriptScanner.this.ch == '}') {
                    JavaScriptScanner.this.nextChar();
                    return;
                }
                JavaScriptScanner.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, "version"){

            @Override
            public void parse(int pos) {
                JavaScriptScanner.this.blockContent();
            }
        }};
        this.tagParsers = new HashMap<String, TagParser>();
        for (TagParser p : parsers) {
            this.tagParsers.put(p.getName(), p);
        }
    }

    private void initEventAttrs() {
        this.eventAttrs = new HashSet<String>(Arrays.asList("onabort", "onblur", "oncanplay", "oncanplaythrough", "onchange", "onclick", "oncontextmenu", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onended", "onerror", "onfocus", "oninput", "oninvalid", "onkeydown", "onkeypress", "onkeyup", "onload", "onloadeddata", "onloadedmetadata", "onloadstart", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onpause", "onplay", "onplaying", "onprogress", "onratechange", "onreadystatechange", "onreset", "onscroll", "onseeked", "onseeking", "onselect", "onshow", "onstalled", "onsubmit", "onsuspend", "ontimeupdate", "onvolumechange", "onwaiting", "onunload"));
    }

    private void initURIAttrs() {
        this.uriAttrs = new HashSet<String>(Arrays.asList("action", "cite", "classid", "codebase", "data", "datasrc", "for", "href", "longdesc", "profile", "src", "usemap"));
    }

    static abstract class TagParser {
        final Kind kind;
        final String name;

        TagParser(Kind k, String tk) {
            this.kind = k;
            this.name = tk;
        }

        TagParser(Kind k, String tk, boolean retainWhiteSpace) {
            this(k, tk);
        }

        Kind getKind() {
            return this.kind;
        }

        String getName() {
            return this.name;
        }

        abstract void parse(int var1) throws ParseException;

        static enum Kind {
            INLINE,
            BLOCK;

        }
    }

    private static enum WhitespaceRetentionPolicy {
        RETAIN_ALL,
        REMOVE_FIRST_SPACE,
        REMOVE_ALL;

    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ParseException(String key) {
            super(key);
        }
    }

    public static interface Reporter {
        public void report();
    }
}

