/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocFileFactory;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.tools.DocumentationTool;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

class StandardDocFileFactory
extends DocFileFactory {
    private final StandardJavaFileManager fileManager;
    private File destDir;

    public StandardDocFileFactory(Configuration configuration) {
        super(configuration);
        this.fileManager = (StandardJavaFileManager)configuration.getFileManager();
    }

    private File getDestDir() {
        if (this.destDir == null) {
            if (!this.configuration.destDirName.isEmpty() || !this.fileManager.hasLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT)) {
                try {
                    String dirName = this.configuration.destDirName.isEmpty() ? "." : this.configuration.destDirName;
                    File dir = new File(dirName);
                    this.fileManager.setLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT, Arrays.asList(dir));
                }
                catch (IOException e) {
                    throw new DocletAbortException(e);
                }
            }
            this.destDir = this.fileManager.getLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT).iterator().next();
        }
        return this.destDir;
    }

    @Override
    public DocFile createFileForDirectory(String file) {
        return new StandardDocFile(new File(file));
    }

    @Override
    public DocFile createFileForInput(String file) {
        return new StandardDocFile(new File(file));
    }

    @Override
    public DocFile createFileForOutput(DocPath path) {
        return new StandardDocFile(DocumentationTool.Location.DOCUMENTATION_OUTPUT, path);
    }

    @Override
    Iterable<DocFile> list(JavaFileManager.Location location, DocPath path) {
        if (location != StandardLocation.SOURCE_PATH) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<DocFile> files = new LinkedHashSet<DocFile>();
        StandardLocation l = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
        for (File file : this.fileManager.getLocation(l)) {
            File file2;
            if (!file.isDirectory() || !(file2 = new File(file, path.getPath())).exists()) continue;
            files.add(new StandardDocFile(file2));
        }
        return files;
    }

    private static File newFile(File dir, String path) {
        return dir == null ? new File(path) : new File(dir, path);
    }

    class StandardDocFile
    extends DocFile {
        private File file;

        private StandardDocFile(File file) {
            super(StandardDocFileFactory.this.configuration);
            this.file = file;
        }

        private StandardDocFile(JavaFileManager.Location location, DocPath path) {
            super(StandardDocFileFactory.this.configuration, location, path);
            Assert.check(location == DocumentationTool.Location.DOCUMENTATION_OUTPUT);
            this.file = StandardDocFileFactory.newFile(StandardDocFileFactory.this.getDestDir(), path.getPath());
        }

        @Override
        public InputStream openInputStream() throws IOException {
            JavaFileObject fo = this.getJavaFileObjectForInput(this.file);
            return new BufferedInputStream(fo.openInputStream());
        }

        @Override
        public OutputStream openOutputStream() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            OutputStream out = this.getFileObjectForOutput(this.path).openOutputStream();
            return new BufferedOutputStream(out);
        }

        @Override
        public Writer openWriter() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            OutputStream out = this.getFileObjectForOutput(this.path).openOutputStream();
            if (StandardDocFileFactory.this.configuration.docencoding == null) {
                return new BufferedWriter(new OutputStreamWriter(out));
            }
            return new BufferedWriter(new OutputStreamWriter(out, StandardDocFileFactory.this.configuration.docencoding));
        }

        @Override
        public boolean canRead() {
            return this.file.canRead();
        }

        @Override
        public boolean canWrite() {
            return this.file.canWrite();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }

        @Override
        public boolean isAbsolute() {
            return this.file.isAbsolute();
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.file.isFile();
        }

        @Override
        public boolean isSameFile(DocFile other) {
            if (!(other instanceof StandardDocFile)) {
                return false;
            }
            try {
                return this.file.exists() && this.file.getCanonicalFile().equals(((StandardDocFile)other).file.getCanonicalFile());
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public Iterable<DocFile> list() {
            ArrayList<DocFile> files = new ArrayList<DocFile>();
            for (File f : this.file.listFiles()) {
                files.add(new StandardDocFile(f));
            }
            return files;
        }

        @Override
        public boolean mkdirs() {
            return this.file.mkdirs();
        }

        @Override
        public DocFile resolve(DocPath p) {
            return this.resolve(p.getPath());
        }

        @Override
        public DocFile resolve(String p) {
            if (this.location == null && this.path == null) {
                return new StandardDocFile(new File(this.file, p));
            }
            return new StandardDocFile(this.location, this.path.resolve(p));
        }

        @Override
        public DocFile resolveAgainst(JavaFileManager.Location locn) {
            if (locn != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalArgumentException();
            }
            return new StandardDocFile(StandardDocFileFactory.newFile(StandardDocFileFactory.this.getDestDir(), this.file.getPath()));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("StandardDocFile[");
            if (this.location != null) {
                sb.append("locn:").append(this.location).append(",");
            }
            if (this.path != null) {
                sb.append("path:").append(this.path.getPath()).append(",");
            }
            sb.append("file:").append(this.file);
            sb.append("]");
            return sb.toString();
        }

        private JavaFileObject getJavaFileObjectForInput(File file) {
            return StandardDocFileFactory.this.fileManager.getJavaFileObjects(file).iterator().next();
        }

        private FileObject getFileObjectForOutput(DocPath path) throws IOException {
            String p = path.getPath();
            int lastSep = -1;
            for (int i = 0; i < p.length(); ++i) {
                char ch = p.charAt(i);
                if (ch == '/') {
                    lastSep = i;
                    continue;
                }
                if (i == lastSep + 1 && !Character.isJavaIdentifierStart(ch) || !Character.isJavaIdentifierPart(ch)) break;
            }
            String pkg = lastSep == -1 ? "" : p.substring(0, lastSep);
            String rest = p.substring(lastSep + 1);
            return StandardDocFileFactory.this.fileManager.getFileForOutput(this.location, pkg, rest, null);
        }
    }
}

