/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class PackageListWriter
extends PrintWriter {
    private Configuration configuration;

    public PackageListWriter(Configuration configuration) throws IOException {
        super(DocFile.createFileForOutput(configuration, DocPaths.PACKAGE_LIST).openWriter());
        this.configuration = configuration;
    }

    public static void generate(Configuration configuration) {
        try {
            PackageListWriter packgen = new PackageListWriter(configuration);
            packgen.generatePackageListFile(configuration.root);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.message.error("doclet.exception_encountered", exc.toString(), DocPaths.PACKAGE_LIST);
            throw new DocletAbortException(exc);
        }
    }

    protected void generatePackageListFile(RootDoc root) {
        int i;
        PackageDoc[] packages = this.configuration.packages;
        ArrayList<String> names = new ArrayList<String>();
        for (i = 0; i < packages.length; ++i) {
            if (this.configuration.nodeprecated && Util.isDeprecated(packages[i])) continue;
            names.add(packages[i].name());
        }
        Collections.sort(names);
        for (i = 0; i < names.size(); ++i) {
            this.println((String)names.get(i));
        }
    }
}

