/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.MethodWriter;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.DocFinder;
import com.sun.tools.oldlets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MethodBuilder
extends AbstractMemberBuilder {
    private int currentMethodIndex;
    private final ClassDoc classDoc;
    private final VisibleMemberMap visibleMemberMap;
    private final MethodWriter writer;
    private List<ProgramElementDoc> methods;

    private MethodBuilder(AbstractBuilder.Context context, ClassDoc classDoc, MethodWriter writer) {
        super(context);
        this.classDoc = classDoc;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(classDoc, 4, this.configuration);
        this.methods = new ArrayList<ProgramElementDoc>(this.visibleMemberMap.getLeafClassMembers(this.configuration));
        if (this.configuration.getMemberComparator() != null) {
            Collections.sort(this.methods, this.configuration.getMemberComparator());
        }
    }

    public static MethodBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, MethodWriter writer) {
        return new MethodBuilder(context, classDoc, writer);
    }

    @Override
    public String getName() {
        return "MethodDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.methods.size() > 0;
    }

    public void buildMethodDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.methods.size();
        if (size > 0) {
            Content methodDetailsTree = this.writer.getMethodDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentMethodIndex = 0;
            while (this.currentMethodIndex < size) {
                Content methodDocTree = this.writer.getMethodDocTreeHeader((MethodDoc)this.methods.get(this.currentMethodIndex), methodDetailsTree);
                this.buildChildren(node, methodDocTree);
                methodDetailsTree.addContent(this.writer.getMethodDoc(methodDocTree, this.currentMethodIndex == size - 1));
                ++this.currentMethodIndex;
            }
            memberDetailsTree.addContent(this.writer.getMethodDetails(methodDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content methodDocTree) {
        methodDocTree.addContent(this.writer.getSignature((MethodDoc)this.methods.get(this.currentMethodIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content methodDocTree) {
        this.writer.addDeprecated((MethodDoc)this.methods.get(this.currentMethodIndex), methodDocTree);
    }

    public void buildMethodComments(XMLNode node, Content methodDocTree) {
        if (!this.configuration.nocomment) {
            MethodDoc method = (MethodDoc)this.methods.get(this.currentMethodIndex);
            if (method.inlineTags().length == 0) {
                DocFinder.Output docs = DocFinder.search(new DocFinder.Input(method));
                method = docs.inlineTags != null && docs.inlineTags.length > 0 ? (MethodDoc)docs.holder : method;
            }
            this.writer.addComments(method.containingClass(), method, methodDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content methodDocTree) {
        this.writer.addTags((MethodDoc)this.methods.get(this.currentMethodIndex), methodDocTree);
    }

    public MethodWriter getWriter() {
        return this.writer;
    }
}

