/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.oldlets.internal.toolkit.ConstantsSummaryWriter;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.VisibleMemberMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ConstantsSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "ConstantSummary";
    public static final int MAX_CONSTANT_VALUE_INDEX_LENGTH = 2;
    protected final ConstantsSummaryWriter writer;
    protected final Set<ClassDoc> classDocsWithConstFields;
    protected Set<String> printedPackageHeaders;
    private PackageDoc currentPackage;
    private ClassDoc currentClass;
    private Content contentTree;

    private ConstantsSummaryBuilder(AbstractBuilder.Context context, ConstantsSummaryWriter writer) {
        super(context);
        this.writer = writer;
        this.classDocsWithConstFields = new HashSet<ClassDoc>();
    }

    public static ConstantsSummaryBuilder getInstance(AbstractBuilder.Context context, ConstantsSummaryWriter writer) {
        return new ConstantsSummaryBuilder(context, writer);
    }

    @Override
    public void build() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildConstantSummary(XMLNode node, Content contentTree) throws Exception {
        contentTree = this.writer.getHeader();
        this.buildChildren(node, contentTree);
        this.writer.addFooter(contentTree);
        this.writer.printDocument(contentTree);
        this.writer.close();
    }

    public void buildContents(XMLNode node, Content contentTree) {
        Content contentListTree = this.writer.getContentsHeader();
        PackageDoc[] packages = this.configuration.packages;
        this.printedPackageHeaders = new HashSet<String>();
        for (int i = 0; i < packages.length; ++i) {
            if (!this.hasConstantField(packages[i]) || this.hasPrintedPackageIndex(packages[i].name())) continue;
            this.writer.addLinkToPackageContent(packages[i], this.parsePackageName(packages[i].name()), this.printedPackageHeaders, contentListTree);
        }
        contentTree.addContent(this.writer.getContentsList(contentListTree));
    }

    public void buildConstantSummaries(XMLNode node, Content contentTree) {
        PackageDoc[] packages = this.configuration.packages;
        this.printedPackageHeaders = new HashSet<String>();
        Content summariesTree = this.writer.getConstantSummaries();
        for (int i = 0; i < packages.length; ++i) {
            if (!this.hasConstantField(packages[i])) continue;
            this.currentPackage = packages[i];
            this.buildChildren(node, summariesTree);
        }
        contentTree.addContent(summariesTree);
    }

    public void buildPackageHeader(XMLNode node, Content summariesTree) {
        String parsedPackageName = this.parsePackageName(this.currentPackage.name());
        if (!this.printedPackageHeaders.contains(parsedPackageName)) {
            this.writer.addPackageName(this.currentPackage, this.parsePackageName(this.currentPackage.name()), summariesTree);
            this.printedPackageHeaders.add(parsedPackageName);
        }
    }

    public void buildClassConstantSummary(XMLNode node, Content summariesTree) {
        Object[] classes = this.currentPackage.name().length() > 0 ? this.currentPackage.allClasses() : this.configuration.classDocCatalog.allClasses("<Unnamed>");
        Arrays.sort(classes);
        Content classConstantTree = this.writer.getClassConstantHeader();
        for (int i = 0; i < classes.length; ++i) {
            if (!this.classDocsWithConstFields.contains(classes[i]) || !classes[i].isIncluded()) continue;
            this.currentClass = classes[i];
            this.buildChildren(node, classConstantTree);
        }
        summariesTree.addContent(classConstantTree);
    }

    public void buildConstantMembers(XMLNode node, Content classConstantTree) {
        new ConstantFieldBuilder(this.currentClass).buildMembersSummary(node, classConstantTree);
    }

    private boolean hasConstantField(PackageDoc pkg) {
        ClassDoc[] classes = pkg.name().length() > 0 ? pkg.allClasses() : this.configuration.classDocCatalog.allClasses("<Unnamed>");
        boolean found = false;
        for (int j = 0; j < classes.length; ++j) {
            if (!classes[j].isIncluded() || !this.hasConstantField(classes[j])) continue;
            found = true;
        }
        return found;
    }

    private boolean hasConstantField(ClassDoc classDoc) {
        VisibleMemberMap visibleMemberMapFields = new VisibleMemberMap(classDoc, 2, this.configuration);
        List<ProgramElementDoc> fields = visibleMemberMapFields.getLeafClassMembers(this.configuration);
        for (FieldDoc fieldDoc : fields) {
            if (fieldDoc.constantValueExpression() == null) continue;
            this.classDocsWithConstFields.add(classDoc);
            return true;
        }
        return false;
    }

    private boolean hasPrintedPackageIndex(String pkgname) {
        String[] list = this.printedPackageHeaders.toArray(new String[0]);
        for (int i = 0; i < list.length; ++i) {
            if (!pkgname.startsWith(list[i])) continue;
            return true;
        }
        return false;
    }

    private String parsePackageName(String pkgname) {
        int index = -1;
        for (int j = 0; j < 2; ++j) {
            index = pkgname.indexOf(".", index + 1);
        }
        if (index != -1) {
            pkgname = pkgname.substring(0, index);
        }
        return pkgname;
    }

    private class ConstantFieldBuilder {
        protected VisibleMemberMap visibleMemberMapFields = null;
        protected VisibleMemberMap visibleMemberMapEnumConst = null;
        protected ClassDoc classdoc;

        public ConstantFieldBuilder(ClassDoc classdoc) {
            this.classdoc = classdoc;
            this.visibleMemberMapFields = new VisibleMemberMap(classdoc, 2, ConstantsSummaryBuilder.this.configuration);
            this.visibleMemberMapEnumConst = new VisibleMemberMap(classdoc, 1, ConstantsSummaryBuilder.this.configuration);
        }

        protected void buildMembersSummary(XMLNode node, Content classConstantTree) {
            ArrayList<FieldDoc> members = new ArrayList<FieldDoc>(this.members());
            if (members.size() > 0) {
                Collections.sort(members);
                ConstantsSummaryBuilder.this.writer.addConstantMembers(this.classdoc, members, classConstantTree);
            }
        }

        protected List<FieldDoc> members() {
            List<ProgramElementDoc> l = this.visibleMemberMapFields.getLeafClassMembers(ConstantsSummaryBuilder.this.configuration);
            l.addAll(this.visibleMemberMapEnumConst.getLeafClassMembers(ConstantsSummaryBuilder.this.configuration));
            if (l == null) {
                return null;
            }
            Iterator<ProgramElementDoc> iter = l.iterator();
            LinkedList<FieldDoc> inclList = new LinkedList<FieldDoc>();
            while (iter.hasNext()) {
                FieldDoc member = (FieldDoc)iter.next();
                if (member.constantValue() == null) continue;
                inclList.add(member);
            }
            return inclList;
        }
    }
}

