/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;

public class AnnotationTypeBuilder
extends AbstractBuilder {
    public static final String ROOT = "AnnotationTypeDoc";
    private final AnnotationTypeDoc annotationTypeDoc;
    private final AnnotationTypeWriter writer;
    private Content contentTree;

    private AnnotationTypeBuilder(AbstractBuilder.Context context, AnnotationTypeDoc annotationTypeDoc, AnnotationTypeWriter writer) {
        super(context);
        this.annotationTypeDoc = annotationTypeDoc;
        this.writer = writer;
    }

    public static AnnotationTypeBuilder getInstance(AbstractBuilder.Context context, AnnotationTypeDoc annotationTypeDoc, AnnotationTypeWriter writer) throws Exception {
        return new AnnotationTypeBuilder(context, annotationTypeDoc, writer);
    }

    @Override
    public void build() throws IOException {
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildAnnotationTypeDoc(XMLNode node, Content contentTree) throws Exception {
        contentTree = this.writer.getHeader(this.configuration.getText("doclet.AnnotationType") + " " + this.annotationTypeDoc.name());
        Content annotationContentTree = this.writer.getAnnotationContentHeader();
        this.buildChildren(node, annotationContentTree);
        contentTree.addContent(annotationContentTree);
        this.writer.addFooter(contentTree);
        this.writer.printDocument(contentTree);
        this.writer.close();
        this.copyDocFiles();
    }

    private void copyDocFiles() {
        PackageDoc containingPackage = this.annotationTypeDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, containingPackage) >= 0 || this.containingPackagesSeen.contains(containingPackage.name()))) {
            Util.copyDocFiles(this.configuration, containingPackage);
            this.containingPackagesSeen.add(containingPackage.name());
        }
    }

    public void buildAnnotationTypeInfo(XMLNode node, Content annotationContentTree) {
        Content annotationInfoTree = this.writer.getAnnotationInfoTreeHeader();
        this.buildChildren(node, annotationInfoTree);
        annotationContentTree.addContent(this.writer.getAnnotationInfo(annotationInfoTree));
    }

    public void buildDeprecationInfo(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeDeprecationInfo(annotationInfoTree);
    }

    public void buildAnnotationTypeSignature(XMLNode node, Content annotationInfoTree) {
        StringBuilder modifiers = new StringBuilder(this.annotationTypeDoc.modifiers() + " ");
        this.writer.addAnnotationTypeSignature(Util.replaceText(modifiers.toString(), "interface", "@interface"), annotationInfoTree);
    }

    public void buildAnnotationTypeDescription(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeDescription(annotationInfoTree);
    }

    public void buildAnnotationTypeTagInfo(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeTagInfo(annotationInfoTree);
    }

    public void buildMemberSummary(XMLNode node, Content annotationContentTree) throws Exception {
        Content memberSummaryTree = this.writer.getMemberTreeHeader();
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).buildChildren(node, memberSummaryTree);
        annotationContentTree.addContent(this.writer.getMemberSummaryTree(memberSummaryTree));
    }

    public void buildAnnotationTypeMemberDetails(XMLNode node, Content annotationContentTree) {
        Content memberDetailsTree = this.writer.getMemberTreeHeader();
        this.buildChildren(node, memberDetailsTree);
        if (memberDetailsTree.isValid()) {
            annotationContentTree.addContent(this.writer.getMemberDetailsTree(memberDetailsTree));
        }
    }

    public void buildAnnotationTypeFieldDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeFieldsBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildAnnotationTypeOptionalMemberDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeOptionalMemberBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildAnnotationTypeRequiredMemberDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeRequiredMemberBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }
}

