/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.AnnotatedType;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.markup.ContentBuilder;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import com.sun.tools.oldlets.internal.toolkit.util.links.LinkFactory;
import com.sun.tools.oldlets.internal.toolkit.util.links.LinkInfo;
import java.util.List;

public class LinkFactoryImpl
extends LinkFactory {
    private HtmlDocletWriter m_writer;

    public LinkFactoryImpl(HtmlDocletWriter writer) {
        this.m_writer = writer;
    }

    @Override
    protected Content newContent() {
        return new ContentBuilder();
    }

    @Override
    protected Content getClassLink(LinkInfo linkInfo) {
        LinkInfoImpl classLinkInfo = (LinkInfoImpl)linkInfo;
        boolean noLabel = linkInfo.label == null || linkInfo.label.isEmpty();
        ClassDoc classDoc = classLinkInfo.classDoc;
        String title = classLinkInfo.where == null || classLinkInfo.where.length() == 0 ? this.getClassToolTip(classDoc, classLinkInfo.type != null && !classDoc.qualifiedTypeName().equals(classLinkInfo.type.qualifiedTypeName())) : "";
        Content label = classLinkInfo.getClassLinkLabel(this.m_writer.configuration);
        ConfigurationImpl configuration = this.m_writer.configuration;
        ContentBuilder link = new ContentBuilder();
        if (classDoc.isIncluded()) {
            if (configuration.isGeneratedDoc(classDoc)) {
                DocPath filename = this.getPath(classLinkInfo);
                if (linkInfo.linkToSelf || !DocPath.forName(classDoc).equals(this.m_writer.filename)) {
                    ((Content)link).addContent(this.m_writer.getHyperLink(filename.fragment(classLinkInfo.where), label, classLinkInfo.isStrong, classLinkInfo.styleName, title, classLinkInfo.target));
                    if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
                        ((Content)link).addContent(this.getTypeParameterLinks(linkInfo));
                    }
                    return link;
                }
            }
        } else {
            Content crossLink = this.m_writer.getCrossClassLink(classDoc.qualifiedName(), classLinkInfo.where, label, classLinkInfo.isStrong, classLinkInfo.styleName, true);
            if (crossLink != null) {
                ((Content)link).addContent(crossLink);
                if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
                    ((Content)link).addContent(this.getTypeParameterLinks(linkInfo));
                }
                return link;
            }
        }
        ((Content)link).addContent(label);
        if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
            ((Content)link).addContent(this.getTypeParameterLinks(linkInfo));
        }
        return link;
    }

    @Override
    protected Content getTypeParameterLink(LinkInfo linkInfo, Type typeParam) {
        LinkInfoImpl typeLinkInfo = new LinkInfoImpl(this.m_writer.configuration, ((LinkInfoImpl)linkInfo).getContext(), typeParam);
        typeLinkInfo.excludeTypeBounds = linkInfo.excludeTypeBounds;
        typeLinkInfo.excludeTypeParameterLinks = linkInfo.excludeTypeParameterLinks;
        typeLinkInfo.linkToSelf = linkInfo.linkToSelf;
        typeLinkInfo.isJava5DeclarationLocation = false;
        return this.getLink(typeLinkInfo);
    }

    @Override
    protected Content getTypeAnnotationLink(LinkInfo linkInfo, AnnotationDesc annotation) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public Content getTypeAnnotationLinks(LinkInfo linkInfo) {
        AnnotationDesc[] annotations;
        ContentBuilder links = new ContentBuilder();
        if (linkInfo.type instanceof AnnotatedType) {
            annotations = linkInfo.type.asAnnotatedType().annotations();
        } else if (linkInfo.type instanceof TypeVariable) {
            annotations = linkInfo.type.asTypeVariable().annotations();
        } else {
            return links;
        }
        if (annotations.length == 0) {
            return links;
        }
        List<Content> annos = this.m_writer.getAnnotations(0, annotations, false, linkInfo.isJava5DeclarationLocation);
        boolean isFirst = true;
        for (Content anno : annos) {
            if (!isFirst) {
                links.addContent(" ");
            }
            links.addContent(anno);
            isFirst = false;
        }
        if (!annos.isEmpty()) {
            links.addContent(" ");
        }
        return links;
    }

    private String getClassToolTip(ClassDoc classDoc, boolean isTypeLink) {
        ConfigurationImpl configuration = this.m_writer.configuration;
        if (isTypeLink) {
            return configuration.getText("doclet.Href_Type_Param_Title", classDoc.name());
        }
        if (classDoc.isInterface()) {
            return configuration.getText("doclet.Href_Interface_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        if (classDoc.isAnnotationType()) {
            return configuration.getText("doclet.Href_Annotation_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        if (classDoc.isEnum()) {
            return configuration.getText("doclet.Href_Enum_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        return configuration.getText("doclet.Href_Class_Title", Util.getPackageName(classDoc.containingPackage()));
    }

    private DocPath getPath(LinkInfoImpl linkInfo) {
        if (linkInfo.context == LinkInfoImpl.Kind.PACKAGE_FRAME) {
            return DocPath.forName(linkInfo.classDoc);
        }
        return this.m_writer.pathToRoot.resolve(DocPath.forClass(linkInfo.classDoc));
    }
}

