/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.javadoc.codesnippet;

import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Tag;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Snippets {
    private static final Pattern TAG = Pattern.compile("\\{ *@codesnippet *([\\.\\-a-z0-9A-Z#]*) *\\}");
    private static final Pattern LINKTAG = Pattern.compile("\\{ *@link *([\\.\\-a-z0-9A-Z#]*) *\\}");
    private static final Pattern PACKAGE = Pattern.compile(" *package *([\\p{Alnum}\\.]+);");
    private static final Pattern IMPORT = Pattern.compile(" *import *([\\p{Alnum}\\.\\*]+);");
    private static final Pattern BEGIN = Pattern.compile(".* BEGIN: *(\\p{Graph}+)[-\\> ]*");
    private static final Pattern END = Pattern.compile(".* (END|FINISH): *(\\p{Graph}+)[-\\> ]*");
    private final DocErrorReporter reporter;
    private final List<Path> search = new ArrayList<Path>();
    private final List<Path> visible = new ArrayList<Path>();
    private final List<Pattern> classes = new ArrayList<Pattern>();
    private Map<String, String> snippets;
    private int maxLineLength = 80;
    private String verifySince;
    private String encoding;
    private Set<String> hiddenAnno;
    private static final Pattern WORDS = Pattern.compile("(\\w+)|(//.*)\n|(\"[^\"]*\")");

    Snippets(DocErrorReporter reporter) {
        this.reporter = reporter;
    }

    void fixCodesnippets(Doc enclosingElement, Doc element) {
        try {
            String txt;
            Matcher match;
            while ((match = TAG.matcher(txt = element.getRawCommentText())).find() || !this.classes.isEmpty() && this.findLinkSnippet(match = LINKTAG.matcher(txt))) {
                String code = "<pre>" + this.findSnippet(element, match.group(1)) + "</pre>";
                String newTxt = txt.substring(0, match.start(0)) + code + txt.substring(match.end(0));
                element.setRawCommentText(newTxt);
            }
            element.inlineTags();
            if (this.verifySince != null) {
                this.verifySinceTag(element, enclosingElement, this.verifySince);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Snippets.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean verifySinceTag(Doc element, Doc enclosingElement, String expVersion) throws IOException {
        for (Tag t : element.tags()) {
            if (!t.name().equals("@since")) continue;
            return false;
        }
        if (enclosingElement.isEnum() && element.isMethod() && (element.name().equals("valueOf") || element.name().equals("values"))) {
            return false;
        }
        this.reporter.printWarning(element.position(), "missing @since tag for " + element);
        if (!expVersion.isEmpty()) {
            this.addSinceTag(element, expVersion);
            return true;
        }
        return false;
    }

    private void addSinceTag(Doc element, String version) throws IOException {
        File f = element.position().file();
        int index = element.position().line();
        List<String> lines = Files.readAllLines(f.toPath(), Charset.forName("UTF-8"));
        boolean second = false;
        while (true) {
            String l;
            int at;
            if ((at = (l = lines.get(--index)).indexOf("*/")) >= 0) {
                if (l.contains("@since " + version)) break;
                lines.set(index, l.substring(0, at) + "@since " + version + " */");
                break;
            }
            if (l.isEmpty()) {
                lines.set(index, l + "/** @since " + version + " */");
                break;
            }
            if (!l.endsWith(";")) continue;
            if (second) {
                lines.set(index, l + " /** @since " + version + " */");
                break;
            }
            second = true;
        }
        try (BufferedWriter w = new BufferedWriter(new FileWriter(f));){
            for (String l : lines) {
                w.write(l);
                w.newLine();
            }
        }
    }

    private boolean findLinkSnippet(Matcher match) {
        block0: while (true) {
            Pattern p;
            if (!match.find()) {
                return false;
            }
            String className = match.group(1);
            Iterator<Pattern> iterator = this.classes.iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!(p = iterator.next()).matcher(className).matches());
            break;
        }
        return true;
    }

    String findSnippet(Doc element, String key) {
        String code;
        if (this.snippets == null) {
            TreeMap<String, String> tmp = new TreeMap<String, String>();
            TreeMap<String, String> topClasses = new TreeMap<String, String>();
            for (Path path : this.visible) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    this.printWarning(null, "Cannot scan " + path + " not a directory!");
                    continue;
                }
                try {
                    this.collectClasses(path, topClasses);
                }
                catch (IOException ex) {
                    this.printError(element, "Cannot read " + path + ": " + ex.getMessage());
                }
            }
            for (Path path : this.search) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    this.printWarning(null, "Cannot scan " + path + " not a directory!");
                    continue;
                }
                try {
                    this.scanDir(path, topClasses, tmp);
                }
                catch (IOException ex) {
                    this.printError(element, "Cannot read " + path + ": " + ex.getMessage());
                }
            }
            this.snippets = tmp;
        }
        if ((code = this.snippets.get(key)) == null) {
            code = "Snippet '" + key + "' not found.";
            this.reporter.printWarning(element.position(), code);
        }
        return code;
    }

    void addPath(Path path, boolean useLink) {
        this.search.add(path);
        if (useLink) {
            this.visible.add(path);
        }
    }

    void addClasses(String classRegExp) {
        this.classes.add(Pattern.compile(classRegExp));
    }

    private void scanDir(Path dir, final Map<String, String> topClasses, final Map<String, String> collect) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String javaName = Snippets.javaName(file);
                TreeMap<String, CharSequence> texts = new TreeMap<String, CharSequence>();
                TreeMap<String, String> imports = new TreeMap<String, String>(topClasses);
                LinkedHashSet<String> packages = new LinkedHashSet<String>();
                Charset charset = Charset.defaultCharset();
                if (Snippets.this.encoding != null && !Snippets.this.encoding.isEmpty()) {
                    charset = Charset.forName(Snippets.this.encoding);
                }
                try (BufferedReader r = Files.newBufferedReader(file, charset);){
                    String line;
                    while ((line = r.readLine()) != null) {
                        Matcher m;
                        if (javaName != null && (m = IMPORT.matcher(line)).matches()) {
                            String fqn = m.group(1);
                            if (fqn.endsWith(".*")) {
                                packages.add(fqn.substring(0, fqn.length() - 2));
                            } else {
                                int lastDot = fqn.lastIndexOf(46);
                                imports.put(fqn.substring(lastDot + 1), fqn);
                            }
                        }
                        if ((m = BEGIN.matcher(line)).matches()) {
                            Item sb = new Item(file);
                            CharSequence prev = texts.put(m.group(1), sb);
                            if (prev == null) continue;
                            Snippets.this.printError(null, "Same pattern is there twice: " + m.group(1) + " in " + file);
                            continue;
                        }
                        m = END.matcher(line);
                        if (m.matches()) {
                            CharSequence s = (CharSequence)texts.get(m.group(2));
                            if (s instanceof Item) {
                                texts.put(m.group(2), ((Item)s).toString(m.group(1).equals("FINISH"), imports, packages));
                                continue;
                            }
                            if (s == null) {
                                Snippets.this.printError(null, "Closing unknown section: " + m.group(2) + " in " + file);
                                continue;
                            }
                            Snippets.this.printError(null, "Closing not opened section: " + m.group(2) + " in " + file);
                            continue;
                        }
                        for (CharSequence charSequence : texts.values()) {
                            if (!(charSequence instanceof Item)) continue;
                            Item sb = (Item)charSequence;
                            sb.append(line);
                        }
                    }
                }
                catch (MalformedInputException ex) {
                    Snippets.this.printWarning(null, "Skipping binary file " + file.toString());
                }
                catch (CharacterCodingException ex) {
                    Snippets.this.printWarning(null, "Skipping binary file " + file.toString());
                }
                catch (IOException ex) {
                    Snippets.this.printError(null, "Cannot read " + file.toString() + " " + ex.getMessage());
                }
                Iterator iterator = texts.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    CharSequence v = (CharSequence)entry.getValue();
                    if (v instanceof Item) {
                        Snippets.this.printError(null, "Not closed section " + (String)entry.getKey() + " in " + file);
                    }
                    collect.put(entry.getKey(), v.toString());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void collectClasses(Path dir, final Map<String, String> topClasses) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String javaName = Snippets.javaName(file);
                if (javaName != null) {
                    try (BufferedReader r = Files.newBufferedReader(file, Charset.defaultCharset());){
                        String line;
                        while ((line = r.readLine()) != null) {
                            Matcher pkgMatch = PACKAGE.matcher(line);
                            if (!pkgMatch.matches()) continue;
                            String fqn = pkgMatch.group(1);
                            topClasses.put(javaName, fqn + '.' + javaName);
                        }
                    }
                    catch (IOException ex) {
                        Snippets.this.printError(null, "Cannot read " + file.toString() + " " + ex.getMessage());
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    final void printWarning(Doc where, String msg) {
        if (this.reporter != null) {
            if (where == null) {
                this.reporter.printWarning(msg);
            } else {
                this.reporter.printWarning(where.position(), msg);
            }
        } else {
            throw new IllegalStateException(msg);
        }
    }

    final void printError(Doc where, String msg) {
        if (this.reporter != null) {
            if (where == null) {
                this.reporter.printError(msg);
            } else {
                this.reporter.printError(where.position(), msg);
            }
        } else {
            throw new IllegalStateException(msg);
        }
    }

    static String xmlize(CharSequence text) {
        String noAmp = text.toString().replaceAll("&", "&amp;");
        String noZav = noAmp.toString().replaceAll("@", "&#064;");
        String noLt = noZav.replaceAll("<", "&lt;");
        String noGt = noLt.replaceAll(">", "&gt;");
        return noGt;
    }

    static String javaName(Path file1) {
        String name = file1.getFileName().toString();
        return name.endsWith(".java") ? name.substring(0, name.length() - 5) : null;
    }

    static String boldJavaKeywords(String text, Map<String, String> imports, Set<String> packages) {
        Matcher m = WORDS.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String append;
            switch (m.group(0)) {
                case "abstract": 
                case "assert": 
                case "boolean": 
                case "break": 
                case "byte": 
                case "case": 
                case "catch": 
                case "class": 
                case "const": 
                case "continue": 
                case "default": 
                case "do": 
                case "double": 
                case "else": 
                case "enum": 
                case "extends": 
                case "final": 
                case "finally": 
                case "float": 
                case "for": 
                case "goto": 
                case "char": 
                case "if": 
                case "implements": 
                case "import": 
                case "instanceof": 
                case "int": 
                case "interface": 
                case "long": 
                case "native": 
                case "new": 
                case "package": 
                case "private": 
                case "protected": 
                case "public": 
                case "return": 
                case "short": 
                case "static": 
                case "strictfp": 
                case "super": 
                case "switch": 
                case "synchronized": 
                case "this": 
                case "throw": 
                case "throws": 
                case "transient": 
                case "try": 
                case "void": 
                case "volatile": 
                case "while": 
                case "true": 
                case "false": 
                case "null": {
                    append = "<b>" + m.group(0) + "</b>";
                    break;
                }
                default: {
                    if (m.group(0).startsWith("//")) {
                        append = "<em>" + m.group(0).substring(0, m.group(0).length() - 1) + "</em>\n";
                        break;
                    }
                    if (m.group(0).startsWith("\"")) {
                        append = "<em>" + m.group(0) + "</em>";
                        break;
                    }
                    String fqn = imports.get(m.group(0));
                    if (fqn == null && (fqn = Snippets.tryLoad("java.lang", m.group(0))) == null && packages != null) {
                        String p;
                        Iterator<String> iterator = packages.iterator();
                        while (iterator.hasNext() && (fqn = Snippets.tryLoad(p = iterator.next(), m.group(0))) == null) {
                        }
                    }
                    append = fqn == null ? m.group(0) : "{@link " + fqn + "}";
                }
            }
            append = append.replace("\\", "\\\\").replace("$", "\\$");
            m.appendReplacement(sb, append);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String tryLoad(String pkg, String name) {
        try {
            String loaded = pkg + "." + name;
            Class.forName(loaded);
            return loaded;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    static final int countChar(CharSequence seq, char ch) {
        int cnt = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (ch != seq.charAt(i)) continue;
            ++cnt;
        }
        return cnt;
    }

    void setMaxLineLength(String maxLineLength) {
        if (maxLineLength != null) {
            try {
                this.maxLineLength = Integer.parseInt(maxLineLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void setVerifySince(String sinceCheck) {
        this.verifySince = sinceCheck;
    }

    void addHiddenAnnotation(String fqn) {
        if (this.hiddenAnno == null) {
            this.hiddenAnno = new HashSet<String>();
        }
        this.hiddenAnno.add(fqn);
    }

    boolean isHiddingAnnotation(String name) {
        return this.hiddenAnno != null && this.hiddenAnno.contains(name);
    }

    static int findMissingIndentation(String unclosedText) {
        int closed = 0;
        int i = unclosedText.length() - 1;
        while (i >= 0) {
            char ch;
            if ((ch = unclosedText.charAt(i--)) == '}') {
                ++closed;
            }
            if (ch != '{' || closed-- != 0) continue;
            break;
        }
        int spaces = 0;
        while (i >= 0) {
            char ch;
            if ((ch = unclosedText.charAt(i--)) == ' ') {
                ++spaces;
                continue;
            }
            if (ch == '\n' || ch == '\r') break;
            spaces = 0;
        }
        return spaces;
    }

    void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private final class Item
    implements CharSequence {
        private StringBuilder sb = new StringBuilder();
        private int spaces = Integer.MAX_VALUE;
        private Stack<Integer> remove = new Stack();
        private final Path file;

        public Item(Path file) {
            this.file = file;
        }

        @Override
        public int length() {
            return this.sb.length();
        }

        @Override
        public char charAt(int index) {
            return this.sb.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.sb.subSequence(start, end);
        }

        private void append(String line) {
            for (int sp = 0; sp < line.length(); ++sp) {
                if (line.charAt(sp) == ' ' || sp >= this.spaces) continue;
                this.spaces = sp;
                break;
            }
            this.remove.push(this.sb.length());
            this.sb.append(line);
            this.sb.append('\n');
        }

        public String toString(boolean finish, Map<String, String> imports, Set<String> packages) {
            int len = Snippets.this.maxLineLength;
            if (this.remove != null) {
                int i;
                while (!this.remove.isEmpty()) {
                    Integer pos = this.remove.pop();
                    for (i = 0; i < this.spaces && this.sb.charAt(pos) != '\n'; ++i) {
                        this.sb.deleteCharAt(pos);
                    }
                }
                this.remove = null;
                int line = 0;
                for (i = 0; i < this.sb.length(); ++i) {
                    if (this.sb.charAt(i) == '\n') {
                        line = 0;
                        continue;
                    }
                    if (++line <= len) continue;
                    Snippets.this.printError(null, "Line is too long in: " + this.file + "\n" + this.sb);
                }
                int open = Snippets.countChar(this.sb, '{');
                int end = Snippets.countChar(this.sb, '}');
                if (finish) {
                    for (int i2 = 0; i2 < open - end; ++i2) {
                        int missingBraceIndent = Snippets.findMissingIndentation(this.sb.toString());
                        while (missingBraceIndent-- > 0) {
                            this.sb.append(" ");
                        }
                        this.sb.append("}\n");
                    }
                }
                if (Snippets.countChar(this.sb, '{') != Snippets.countChar(this.sb, '}')) {
                    Snippets.this.printError(null, "not paired amount of braces (consider using '// FINISH:' instead of '// END:') in " + this.file + "\n" + this.sb);
                }
            }
            String xml = Snippets.xmlize(this.sb.toString());
            if (Snippets.javaName(this.file) != null) {
                return Snippets.boldJavaKeywords(xml, imports, packages);
            }
            return xml;
        }
    }
}

