/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class VisibleMemberMap {
    private boolean noVisibleMembers = true;
    public static final int INNERCLASSES = 0;
    public static final int ENUM_CONSTANTS = 1;
    public static final int FIELDS = 2;
    public static final int CONSTRUCTORS = 3;
    public static final int METHODS = 4;
    public static final int ANNOTATION_TYPE_FIELDS = 5;
    public static final int ANNOTATION_TYPE_MEMBER_OPTIONAL = 6;
    public static final int ANNOTATION_TYPE_MEMBER_REQUIRED = 7;
    public static final int PROPERTIES = 8;
    public static final int NUM_MEMBER_TYPES = 9;
    public static final String STARTLEVEL = "start";
    private final List<ClassDoc> visibleClasses = new ArrayList<ClassDoc>();
    private final Map<Object, Map<ProgramElementDoc, String>> memberNameMap = new HashMap<Object, Map<ProgramElementDoc, String>>();
    private final Map<ClassDoc, ClassMembers> classMap = new HashMap<ClassDoc, ClassMembers>();
    private final ClassDoc classdoc;
    private final int kind;
    private final Configuration configuration;
    private static final Map<ClassDoc, ProgramElementDoc[]> propertiesCache = new HashMap<ClassDoc, ProgramElementDoc[]>();
    private static final Map<ProgramElementDoc, ProgramElementDoc> classPropertiesMap = new HashMap<ProgramElementDoc, ProgramElementDoc>();
    private static final Map<ProgramElementDoc, GetterSetter> getterSetterMap = new HashMap<ProgramElementDoc, GetterSetter>();

    public VisibleMemberMap(ClassDoc classdoc, int kind, Configuration configuration) {
        this.classdoc = classdoc;
        this.kind = kind;
        this.configuration = configuration;
        new ClassMembers(classdoc, STARTLEVEL).build();
    }

    public List<ClassDoc> getVisibleClassesList() {
        this.sort(this.visibleClasses);
        return this.visibleClasses;
    }

    public ProgramElementDoc getPropertyMemberDoc(ProgramElementDoc ped) {
        return classPropertiesMap.get(ped);
    }

    public ProgramElementDoc getGetterForProperty(ProgramElementDoc propertyMethod) {
        return getterSetterMap.get(propertyMethod).getGetter();
    }

    public ProgramElementDoc getSetterForProperty(ProgramElementDoc propertyMethod) {
        return getterSetterMap.get(propertyMethod).getSetter();
    }

    private List<ProgramElementDoc> getInheritedPackagePrivateMethods(Configuration configuration) {
        ArrayList<ProgramElementDoc> results = new ArrayList<ProgramElementDoc>();
        for (ClassDoc currentClass : this.visibleClasses) {
            if (currentClass == this.classdoc || !currentClass.isPackagePrivate() || Util.isLinkable(currentClass, configuration)) continue;
            results.addAll(this.getMembersFor(currentClass));
        }
        return results;
    }

    public List<ProgramElementDoc> getLeafClassMembers(Configuration configuration) {
        List<ProgramElementDoc> result = this.getMembersFor(this.classdoc);
        result.addAll(this.getInheritedPackagePrivateMethods(configuration));
        return result;
    }

    public List<ProgramElementDoc> getMembersFor(ClassDoc cd) {
        ClassMembers clmembers = this.classMap.get(cd);
        if (clmembers == null) {
            return new ArrayList<ProgramElementDoc>();
        }
        return clmembers.getMembers();
    }

    private void sort(List<ClassDoc> list) {
        ArrayList<ClassDoc> classes = new ArrayList<ClassDoc>();
        ArrayList<ClassDoc> interfaces = new ArrayList<ClassDoc>();
        for (int i = 0; i < list.size(); ++i) {
            ClassDoc cd = list.get(i);
            if (cd.isClass()) {
                classes.add(cd);
                continue;
            }
            interfaces.add(cd);
        }
        list.clear();
        list.addAll(classes);
        list.addAll(interfaces);
    }

    private void fillMemberLevelMap(List<ProgramElementDoc> list, String level) {
        for (int i = 0; i < list.size(); ++i) {
            Object key = this.getMemberKey(list.get(i));
            Map<ProgramElementDoc, String> memberLevelMap = this.memberNameMap.get(key);
            if (memberLevelMap == null) {
                memberLevelMap = new HashMap<ProgramElementDoc, String>();
                this.memberNameMap.put(key, memberLevelMap);
            }
            memberLevelMap.put(list.get(i), level);
        }
    }

    private void purgeMemberLevelMap(List<ProgramElementDoc> list, String level) {
        for (int i = 0; i < list.size(); ++i) {
            Object key = this.getMemberKey(list.get(i));
            Map<ProgramElementDoc, String> memberLevelMap = this.memberNameMap.get(key);
            if (memberLevelMap == null || !level.equals(memberLevelMap.get(list.get(i)))) continue;
            memberLevelMap.remove(list.get(i));
        }
    }

    public boolean noVisibleMembers() {
        return this.noVisibleMembers;
    }

    private ClassMember getClassMember(MethodDoc member) {
        for (Object key : this.memberNameMap.keySet()) {
            if (key instanceof String || !((ClassMember)key).isEqual(member)) continue;
            return (ClassMember)key;
        }
        return new ClassMember((ProgramElementDoc)member);
    }

    private Object getMemberKey(ProgramElementDoc doc) {
        if (doc.isConstructor()) {
            return doc.name() + ((ExecutableMemberDoc)doc).signature();
        }
        if (doc.isMethod()) {
            return this.getClassMember((MethodDoc)doc);
        }
        if (doc.isField() || doc.isEnumConstant() || doc.isAnnotationTypeElement()) {
            return doc.name();
        }
        String classOrIntName = doc.name();
        classOrIntName = classOrIntName.indexOf(46) != 0 ? classOrIntName.substring(classOrIntName.lastIndexOf(46), classOrIntName.length()) : classOrIntName;
        return "clint" + classOrIntName;
    }

    private class GetterSetter {
        private final ProgramElementDoc getter;
        private final ProgramElementDoc setter;

        public GetterSetter(ProgramElementDoc getter, ProgramElementDoc setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public ProgramElementDoc getGetter() {
            return this.getter;
        }

        public ProgramElementDoc getSetter() {
            return this.setter;
        }
    }

    private class ClassMembers {
        private ClassDoc mappingClass;
        private List<ProgramElementDoc> members = new ArrayList<ProgramElementDoc>();
        private String level;
        private final Pattern pattern = Pattern.compile("[sg]et\\p{Upper}.*");

        public List<ProgramElementDoc> getMembers() {
            return this.members;
        }

        private ClassMembers(ClassDoc mappingClass, String level) {
            this.mappingClass = mappingClass;
            this.level = level;
            if (VisibleMemberMap.this.classMap.containsKey(mappingClass) && level.startsWith(((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)mappingClass)).level)) {
                VisibleMemberMap.this.purgeMemberLevelMap(this.getClassMembers(mappingClass, false), ((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)mappingClass)).level);
                VisibleMemberMap.this.classMap.remove(mappingClass);
                VisibleMemberMap.this.visibleClasses.remove(mappingClass);
            }
            if (!VisibleMemberMap.this.classMap.containsKey(mappingClass)) {
                VisibleMemberMap.this.classMap.put(mappingClass, this);
                VisibleMemberMap.this.visibleClasses.add(mappingClass);
            }
        }

        private void build() {
            if (VisibleMemberMap.this.kind == 3) {
                this.addMembers(this.mappingClass);
            } else {
                this.mapClass();
            }
        }

        private void mapClass() {
            ClassDoc superclass;
            this.addMembers(this.mappingClass);
            ClassDoc[] interfaces = this.mappingClass.interfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String locallevel = this.level + 1;
                ClassMembers cm = new ClassMembers(interfaces[i], locallevel);
                cm.mapClass();
            }
            if (this.mappingClass.isClass() && (superclass = this.mappingClass.superclass()) != null && !this.mappingClass.equals(superclass)) {
                ClassMembers cm = new ClassMembers(superclass, this.level + "c");
                cm.mapClass();
            }
        }

        private void addMembers(ClassDoc fromClass) {
            List<ProgramElementDoc> cdmembers = this.getClassMembers(fromClass, true);
            ArrayList<ProgramElementDoc> incllist = new ArrayList<ProgramElementDoc>();
            for (int i = 0; i < cdmembers.size(); ++i) {
                ProgramElementDoc pgmelem = cdmembers.get(i);
                if (this.found(this.members, pgmelem) || !this.memberIsVisible(pgmelem) || this.isOverridden(pgmelem, this.level) || this.isTreatedAsPrivate(pgmelem)) continue;
                incllist.add(pgmelem);
            }
            if (incllist.size() > 0) {
                VisibleMemberMap.this.noVisibleMembers = false;
            }
            this.members.addAll(incllist);
            VisibleMemberMap.this.fillMemberLevelMap(this.getClassMembers(fromClass, false), this.level);
        }

        private boolean isTreatedAsPrivate(ProgramElementDoc pgmelem) {
            if (!((VisibleMemberMap)VisibleMemberMap.this).configuration.javafx) {
                return false;
            }
            Tag[] aspTags = pgmelem.tags("@treatAsPrivate");
            boolean result = aspTags != null && aspTags.length > 0;
            return result;
        }

        private boolean memberIsVisible(ProgramElementDoc pgmdoc) {
            if (pgmdoc.containingClass().equals(VisibleMemberMap.this.classdoc)) {
                return true;
            }
            if (pgmdoc.isPrivate()) {
                return false;
            }
            if (pgmdoc.isPackagePrivate()) {
                return pgmdoc.containingClass().containingPackage().equals(VisibleMemberMap.this.classdoc.containingPackage());
            }
            return true;
        }

        private List<ProgramElementDoc> getClassMembers(ClassDoc cd, boolean filter) {
            if (cd.isEnum() && VisibleMemberMap.this.kind == 3) {
                return Arrays.asList(new ProgramElementDoc[0]);
            }
            FieldDoc[] members = null;
            switch (VisibleMemberMap.this.kind) {
                case 5: {
                    members = cd.fields(filter);
                    break;
                }
                case 6: {
                    members = cd.isAnnotationType() ? this.filter((AnnotationTypeDoc)cd, false) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 7: {
                    members = cd.isAnnotationType() ? this.filter((AnnotationTypeDoc)cd, true) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 0: {
                    members = cd.innerClasses(filter);
                    break;
                }
                case 1: {
                    members = cd.enumConstants();
                    break;
                }
                case 2: {
                    members = cd.fields(filter);
                    break;
                }
                case 3: {
                    members = cd.constructors();
                    break;
                }
                case 4: {
                    members = cd.methods(filter);
                    this.checkOnPropertiesTags((MethodDoc[])members);
                    break;
                }
                case 8: {
                    members = this.properties(cd, filter);
                    break;
                }
                default: {
                    members = new ProgramElementDoc[]{};
                }
            }
            if (((VisibleMemberMap)VisibleMemberMap.this).configuration.nodeprecated) {
                return Util.excludeDeprecatedMembersAsList((ProgramElementDoc[])members);
            }
            return Arrays.asList(members);
        }

        private AnnotationTypeElementDoc[] filter(AnnotationTypeDoc doc, boolean required) {
            AnnotationTypeElementDoc[] members = doc.elements();
            ArrayList<AnnotationTypeElementDoc> targetMembers = new ArrayList<AnnotationTypeElementDoc>();
            for (int i = 0; i < members.length; ++i) {
                if ((!required || members[i].defaultValue() != null) && (required || members[i].defaultValue() == null)) continue;
                targetMembers.add(members[i]);
            }
            return targetMembers.toArray(new AnnotationTypeElementDoc[0]);
        }

        private boolean found(List<ProgramElementDoc> list, ProgramElementDoc elem) {
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc pgmelem = list.get(i);
                if (!Util.matches(pgmelem, elem)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverridden(ProgramElementDoc pgmdoc, String level) {
            Map memberLevelMap = (Map)VisibleMemberMap.this.memberNameMap.get(VisibleMemberMap.this.getMemberKey(pgmdoc));
            if (memberLevelMap == null) {
                return false;
            }
            String mappedlevel2 = null;
            for (String mappedlevel2 : memberLevelMap.values()) {
                if (!mappedlevel2.equals(VisibleMemberMap.STARTLEVEL) && (!level.startsWith(mappedlevel2) || level.equals(mappedlevel2))) continue;
                return true;
            }
            return false;
        }

        private ProgramElementDoc[] properties(ClassDoc cd, boolean filter) {
            MethodDoc[] allMethods = cd.methods(filter);
            FieldDoc[] allFields = cd.fields(false);
            if (propertiesCache.containsKey(cd)) {
                return (ProgramElementDoc[])propertiesCache.get(cd);
            }
            ArrayList<MethodDoc> result = new ArrayList<MethodDoc>();
            for (MethodDoc propertyMethod : allMethods) {
                if (!this.isPropertyMethod(propertyMethod)) continue;
                MethodDoc getter = this.getterForField(allMethods, propertyMethod);
                MethodDoc setter = this.setterForField(allMethods, propertyMethod);
                FieldDoc field = this.fieldForProperty(allFields, propertyMethod);
                this.addToPropertiesMap(setter, getter, propertyMethod, field);
                getterSetterMap.put(propertyMethod, new GetterSetter((ProgramElementDoc)getter, (ProgramElementDoc)setter));
                result.add(propertyMethod);
            }
            ProgramElementDoc[] resultAray = result.toArray(new ProgramElementDoc[result.size()]);
            propertiesCache.put(cd, resultAray);
            return resultAray;
        }

        private void addToPropertiesMap(MethodDoc setter, MethodDoc getter, MethodDoc propertyMethod, FieldDoc field) {
            if (field == null || field.getRawCommentText() == null || field.getRawCommentText().length() == 0) {
                this.addToPropertiesMap((ProgramElementDoc)setter, (ProgramElementDoc)propertyMethod);
                this.addToPropertiesMap((ProgramElementDoc)getter, (ProgramElementDoc)propertyMethod);
                this.addToPropertiesMap((ProgramElementDoc)propertyMethod, (ProgramElementDoc)propertyMethod);
            } else {
                this.addToPropertiesMap((ProgramElementDoc)getter, (ProgramElementDoc)field);
                this.addToPropertiesMap((ProgramElementDoc)setter, (ProgramElementDoc)field);
                this.addToPropertiesMap((ProgramElementDoc)propertyMethod, (ProgramElementDoc)field);
            }
        }

        private void addToPropertiesMap(ProgramElementDoc propertyMethod, ProgramElementDoc commentSource) {
            if (null == propertyMethod || null == commentSource) {
                return;
            }
            String methodRawCommentText = propertyMethod.getRawCommentText();
            if (null == methodRawCommentText || 0 == methodRawCommentText.length() || propertyMethod.equals(commentSource)) {
                classPropertiesMap.put(propertyMethod, commentSource);
            }
        }

        private MethodDoc getterForField(MethodDoc[] methods, MethodDoc propertyMethod) {
            String propertyMethodName = propertyMethod.name();
            String fieldName = propertyMethodName.substring(0, propertyMethodName.lastIndexOf("Property"));
            String fieldNameUppercased = "" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String fieldTypeName = propertyMethod.returnType().toString();
            String getterNamePattern = "boolean".equals(fieldTypeName) || fieldTypeName.endsWith("BooleanProperty") ? "(is|get)" + fieldNameUppercased : "get" + fieldNameUppercased;
            for (MethodDoc methodDoc : methods) {
                if (!Pattern.matches(getterNamePattern, methodDoc.name()) || 0 != methodDoc.parameters().length || !methodDoc.isPublic() && !methodDoc.isProtected()) continue;
                return methodDoc;
            }
            return null;
        }

        private MethodDoc setterForField(MethodDoc[] methods, MethodDoc propertyMethod) {
            String propertyMethodName = propertyMethod.name();
            String fieldName = propertyMethodName.substring(0, propertyMethodName.lastIndexOf("Property"));
            String fieldNameUppercased = "" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String setter = "set" + fieldNameUppercased;
            for (MethodDoc methodDoc : methods) {
                if (!setter.equals(methodDoc.name()) || 1 != methodDoc.parameters().length || !"void".equals(methodDoc.returnType().simpleTypeName()) || !methodDoc.isPublic() && !methodDoc.isProtected()) continue;
                return methodDoc;
            }
            return null;
        }

        private FieldDoc fieldForProperty(FieldDoc[] fields, MethodDoc property) {
            for (FieldDoc field : fields) {
                String fieldName = field.name();
                String propertyName = fieldName + "Property";
                if (!propertyName.equals(property.name())) continue;
                return field;
            }
            return null;
        }

        private boolean isPropertyMethod(MethodDoc method) {
            if (!method.name().endsWith("Property")) {
                return false;
            }
            if (!this.memberIsVisible((ProgramElementDoc)method)) {
                return false;
            }
            if (this.pattern.matcher(method.name()).matches()) {
                return false;
            }
            return 0 == method.parameters().length && !"void".equals(method.returnType().simpleTypeName());
        }

        private void checkOnPropertiesTags(MethodDoc[] members) {
            block0: for (MethodDoc methodDoc : members) {
                if (!methodDoc.isIncluded()) continue;
                for (Tag tag : methodDoc.tags()) {
                    String tagName = tag.name();
                    if (!tagName.equals("@propertySetter") && !tagName.equals("@propertyGetter") && !tagName.equals("@propertyDescription")) continue;
                    if (this.isPropertyGetterOrSetter(members, methodDoc)) continue block0;
                    ((VisibleMemberMap)VisibleMemberMap.this).configuration.message.warning(tag.position(), "doclet.javafx_tag_misuse", new Object[0]);
                    continue block0;
                }
            }
        }

        private boolean isPropertyGetterOrSetter(MethodDoc[] members, MethodDoc methodDoc) {
            boolean found = false;
            String propertyName = Util.propertyNameFromMethodName(VisibleMemberMap.this.configuration, methodDoc.name());
            if (!propertyName.isEmpty()) {
                String propertyMethodName = propertyName + "Property";
                for (MethodDoc member : members) {
                    if (!member.name().equals(propertyMethodName)) continue;
                    found = true;
                    break;
                }
            }
            return found;
        }
    }

    private class ClassMember {
        private Set<ProgramElementDoc> members = new HashSet<ProgramElementDoc>();

        public ClassMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public void addMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public boolean isEqual(MethodDoc member) {
            for (MethodDoc methodDoc : this.members) {
                if (!Util.executableMembersEqual((ExecutableMemberDoc)member, (ExecutableMemberDoc)methodDoc)) continue;
                this.members.add((ProgramElementDoc)member);
                return true;
            }
            return false;
        }
    }
}

