/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.AnnotatedType;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.tools.javac.util.StringUtils;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.DocletConstants;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.tools.StandardLocation;

public class Util {
    public static ProgramElementDoc[] excludeDeprecatedMembers(ProgramElementDoc[] members) {
        return Util.toProgramElementDocArray(Util.excludeDeprecatedMembersAsList(members));
    }

    public static List<ProgramElementDoc> excludeDeprecatedMembersAsList(ProgramElementDoc[] members) {
        ArrayList<ProgramElementDoc> list = new ArrayList<ProgramElementDoc>();
        for (int i = 0; i < members.length; ++i) {
            if (members[i].tags("deprecated").length != 0) continue;
            list.add(members[i]);
        }
        Collections.sort(list);
        return list;
    }

    public static ProgramElementDoc[] toProgramElementDocArray(List<ProgramElementDoc> list) {
        ProgramElementDoc[] pgmarr = new ProgramElementDoc[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            pgmarr[i] = list.get(i);
        }
        return pgmarr;
    }

    public static boolean nonPublicMemberFound(ProgramElementDoc[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isPublic()) continue;
            return true;
        }
        return false;
    }

    public static MethodDoc findMethod(ClassDoc cd, MethodDoc method) {
        MethodDoc[] methods = cd.methods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Util.executableMembersEqual((ExecutableMemberDoc)method, (ExecutableMemberDoc)methods[i])) continue;
            return methods[i];
        }
        return null;
    }

    public static boolean executableMembersEqual(ExecutableMemberDoc member1, ExecutableMemberDoc member2) {
        if (!(member1 instanceof MethodDoc) || !(member2 instanceof MethodDoc)) {
            return false;
        }
        MethodDoc method1 = (MethodDoc)member1;
        MethodDoc method2 = (MethodDoc)member2;
        if (method1.isStatic() && method2.isStatic()) {
            Parameter[] currentParams;
            Parameter[] targetParams = method1.parameters();
            if (method1.name().equals(method2.name()) && (currentParams = method2.parameters()).length == targetParams.length) {
                int j;
                for (j = 0; j < targetParams.length && (targetParams[j].typeName().equals(currentParams[j].typeName()) || currentParams[j].type() instanceof TypeVariable || targetParams[j].type() instanceof TypeVariable); ++j) {
                }
                if (j == targetParams.length) {
                    return true;
                }
            }
            return false;
        }
        return method1.overrides(method2) || method2.overrides(method1) || member1 == member2;
    }

    public static boolean isCoreClass(ClassDoc cd) {
        return cd.containingClass() == null || cd.isStatic();
    }

    public static boolean matches(ProgramElementDoc doc1, ProgramElementDoc doc2) {
        if (doc1 instanceof ExecutableMemberDoc && doc2 instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc ed1 = (ExecutableMemberDoc)doc1;
            ExecutableMemberDoc ed2 = (ExecutableMemberDoc)doc2;
            return Util.executableMembersEqual(ed1, ed2);
        }
        return doc1.name().equals(doc2.name());
    }

    public static void copyDocFiles(Configuration configuration, PackageDoc pd) {
        Util.copyDocFiles(configuration, DocPath.forPackage(pd).resolve(DocPaths.DOC_FILES));
    }

    public static void copyDocFiles(Configuration configuration, DocPath dir) {
        try {
            boolean first = true;
            for (DocFile f : DocFile.list(configuration, StandardLocation.SOURCE_PATH, dir)) {
                DocFile destdir;
                DocFile srcdir;
                if (!f.isDirectory() || (srcdir = f).isSameFile(destdir = DocFile.createFileForOutput(configuration, dir))) continue;
                for (DocFile srcfile : srcdir.list()) {
                    DocFile destfile = destdir.resolve(srcfile.getName());
                    if (srcfile.isFile()) {
                        if (destfile.exists() && !first) {
                            configuration.message.warning((SourcePosition)null, "doclet.Copy_Overwrite_warning", srcfile.getPath(), destdir.getPath());
                            continue;
                        }
                        configuration.message.notice("doclet.Copying_File_0_To_Dir_1", srcfile.getPath(), destdir.getPath());
                        destfile.copyFile(srcfile);
                        continue;
                    }
                    if (!srcfile.isDirectory() || !configuration.copydocfilesubdirs || configuration.shouldExcludeDocFileDir(srcfile.getName())) continue;
                    Util.copyDocFiles(configuration, dir.resolve(srcfile.getName()));
                }
                first = false;
            }
        }
        catch (SecurityException exc) {
            throw new DocletAbortException(exc);
        }
        catch (IOException exc) {
            throw new DocletAbortException(exc);
        }
    }

    public static List<Type> getAllInterfaces(Type type, Configuration configuration, boolean sort) {
        AbstractMap results = sort ? new TreeMap() : new LinkedHashMap();
        Type[] interfaceTypes = null;
        Type superType = null;
        if (type instanceof ParameterizedType) {
            interfaceTypes = ((ParameterizedType)type).interfaceTypes();
            superType = ((ParameterizedType)type).superclassType();
        } else if (type instanceof ClassDoc) {
            interfaceTypes = ((ClassDoc)type).interfaceTypes();
            superType = ((ClassDoc)type).superclassType();
        } else {
            interfaceTypes = type.asClassDoc().interfaceTypes();
            superType = type.asClassDoc().superclassType();
        }
        for (int i = 0; i < interfaceTypes.length; ++i) {
            Type interfaceType = interfaceTypes[i];
            ClassDoc interfaceClassDoc = interfaceType.asClassDoc();
            if (!interfaceClassDoc.isPublic() && configuration != null && !Util.isLinkable(interfaceClassDoc, configuration)) continue;
            results.put(interfaceClassDoc, interfaceType);
            List<Type> superInterfaces = Util.getAllInterfaces(interfaceType, configuration, sort);
            for (Type t : superInterfaces) {
                results.put(t.asClassDoc(), t);
            }
        }
        if (superType == null) {
            return new ArrayList<Type>(results.values());
        }
        Util.addAllInterfaceTypes(results, superType, Util.interfaceTypesOf(superType), false, configuration);
        ArrayList<Type> resultsList = new ArrayList<Type>(results.values());
        if (sort) {
            Collections.sort(resultsList, new TypeComparator());
        }
        return resultsList;
    }

    private static Type[] interfaceTypesOf(Type type) {
        if (type instanceof AnnotatedType) {
            type = ((AnnotatedType)type).underlyingType();
        }
        return type instanceof ClassDoc ? ((ClassDoc)type).interfaceTypes() : ((ParameterizedType)type).interfaceTypes();
    }

    public static List<Type> getAllInterfaces(Type type, Configuration configuration) {
        return Util.getAllInterfaces(type, configuration, true);
    }

    private static void findAllInterfaceTypes(Map<ClassDoc, Type> results, ClassDoc c, boolean raw, Configuration configuration) {
        Type superType = c.superclassType();
        if (superType == null) {
            return;
        }
        Util.addAllInterfaceTypes(results, superType, Util.interfaceTypesOf(superType), raw, configuration);
    }

    private static void findAllInterfaceTypes(Map<ClassDoc, Type> results, ParameterizedType p, Configuration configuration) {
        Type superType = p.superclassType();
        if (superType == null) {
            return;
        }
        Util.addAllInterfaceTypes(results, superType, Util.interfaceTypesOf(superType), false, configuration);
    }

    private static void addAllInterfaceTypes(Map<ClassDoc, Type> results, Type type, Type[] interfaceTypes, boolean raw, Configuration configuration) {
        for (int i = 0; i < interfaceTypes.length; ++i) {
            Type interfaceType = interfaceTypes[i];
            ClassDoc interfaceClassDoc = interfaceType.asClassDoc();
            if (!interfaceClassDoc.isPublic() && (configuration == null || !Util.isLinkable(interfaceClassDoc, configuration))) continue;
            if (raw) {
                interfaceType = interfaceType.asClassDoc();
            }
            results.put(interfaceClassDoc, interfaceType);
            List<Type> superInterfaces = Util.getAllInterfaces(interfaceType, configuration);
            for (Type superInterface : superInterfaces) {
                results.put(superInterface.asClassDoc(), superInterface);
            }
        }
        if (type instanceof AnnotatedType) {
            type = ((AnnotatedType)type).underlyingType();
        }
        if (type instanceof ParameterizedType) {
            Util.findAllInterfaceTypes(results, (ParameterizedType)type, configuration);
        } else if (((ClassDoc)type).typeParameters().length == 0) {
            Util.findAllInterfaceTypes(results, (ClassDoc)type, raw, configuration);
        } else {
            Util.findAllInterfaceTypes(results, (ClassDoc)type, true, configuration);
        }
    }

    public static String quote(String filepath) {
        return "\"" + filepath + "\"";
    }

    public static String getPackageName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "<Unnamed>" : packageDoc.name();
    }

    public static String getPackageFileHeadName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "default" : packageDoc.name();
    }

    public static String replaceText(String originalStr, String oldStr, String newStr) {
        if (oldStr == null || newStr == null || oldStr.equals(newStr)) {
            return originalStr;
        }
        return originalStr.replace(oldStr, newStr);
    }

    public static boolean isDocumentedAnnotation(AnnotationTypeDoc annotationDoc) {
        AnnotationDesc[] annotationDescList = annotationDoc.annotations();
        for (int i = 0; i < annotationDescList.length; ++i) {
            if (!annotationDescList[i].annotationType().qualifiedName().equals(Documented.class.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeclarationTarget(AnnotationDesc targetAnno) {
        AnnotationDesc.ElementValuePair[] elems = targetAnno.elementValues();
        if (elems == null || elems.length != 1 || !"value".equals(elems[0].element().name()) || !(elems[0].value().value() instanceof AnnotationValue[])) {
            return true;
        }
        AnnotationValue[] values = (AnnotationValue[])elems[0].value().value();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i].value();
            if (!(value instanceof FieldDoc)) {
                return true;
            }
            FieldDoc eValue = (FieldDoc)value;
            if (!Util.isJava5DeclarationElementType(eValue)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeclarationAnnotation(AnnotationTypeDoc annotationDoc, boolean isJava5DeclarationLocation) {
        if (!isJava5DeclarationLocation) {
            return false;
        }
        AnnotationDesc[] annotationDescList = annotationDoc.annotations();
        if (annotationDescList.length == 0) {
            return true;
        }
        for (int i = 0; i < annotationDescList.length; ++i) {
            if (!annotationDescList[i].annotationType().qualifiedName().equals(Target.class.getName()) || !Util.isDeclarationTarget(annotationDescList[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isLinkable(ClassDoc classDoc, Configuration configuration) {
        return classDoc.isIncluded() && configuration.isGeneratedDoc(classDoc) || configuration.extern.isExternal((ProgramElementDoc)classDoc) && (classDoc.isPublic() || classDoc.isProtected());
    }

    public static Type getFirstVisibleSuperClass(ClassDoc classDoc, Configuration configuration) {
        if (classDoc == null) {
            return null;
        }
        Type sup = classDoc.superclassType();
        ClassDoc supClassDoc = classDoc.superclass();
        while (!(sup == null || supClassDoc.isPublic() || Util.isLinkable(supClassDoc, configuration) || supClassDoc.superclass().qualifiedName().equals(supClassDoc.qualifiedName()))) {
            sup = supClassDoc.superclassType();
            supClassDoc = supClassDoc.superclass();
        }
        if (classDoc.equals(supClassDoc)) {
            return null;
        }
        return sup;
    }

    public static ClassDoc getFirstVisibleSuperClassCD(ClassDoc classDoc, Configuration configuration) {
        ClassDoc supClassDoc;
        if (classDoc == null) {
            return null;
        }
        for (supClassDoc = classDoc.superclass(); supClassDoc != null && !supClassDoc.isPublic() && !Util.isLinkable(supClassDoc, configuration); supClassDoc = supClassDoc.superclass()) {
        }
        if (classDoc.equals(supClassDoc)) {
            return null;
        }
        return supClassDoc;
    }

    public static String getTypeName(Configuration config, ClassDoc cd, boolean lowerCaseOnly) {
        String typeName = "";
        if (cd.isOrdinaryClass()) {
            typeName = "doclet.Class";
        } else if (cd.isInterface()) {
            typeName = "doclet.Interface";
        } else if (cd.isException()) {
            typeName = "doclet.Exception";
        } else if (cd.isError()) {
            typeName = "doclet.Error";
        } else if (cd.isAnnotationType()) {
            typeName = "doclet.AnnotationType";
        } else if (cd.isEnum()) {
            typeName = "doclet.Enum";
        }
        return config.getText(lowerCaseOnly ? StringUtils.toLowerCase(typeName) : typeName);
    }

    public static String replaceTabs(Configuration configuration, String text) {
        if (text.indexOf("\t") == -1) {
            return text;
        }
        int tabLength = configuration.sourcetab;
        String whitespace = configuration.tabSpaces;
        int textLength = text.length();
        StringBuilder result = new StringBuilder(textLength);
        int pos = 0;
        int lineLength = 0;
        block4: for (int i = 0; i < textLength; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    lineLength = 0;
                    continue block4;
                }
                case '\t': {
                    result.append(text, pos, i);
                    int spaceCount = tabLength - lineLength % tabLength;
                    result.append(whitespace, 0, spaceCount);
                    lineLength += spaceCount;
                    pos = i + 1;
                    continue block4;
                }
                default: {
                    ++lineLength;
                }
            }
        }
        result.append(text, pos, textLength);
        return result.toString();
    }

    public static String normalizeNewlines(String text) {
        StringBuilder sb = new StringBuilder();
        int textLength = text.length();
        String NL = DocletConstants.NL;
        int pos = 0;
        block4: for (int i = 0; i < textLength; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append(text, pos, i);
                    sb.append(NL);
                    pos = i + 1;
                    continue block4;
                }
                case '\r': {
                    sb.append(text, pos, i);
                    sb.append(NL);
                    if (i + 1 < textLength && text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    pos = i + 1;
                }
            }
        }
        sb.append(text, pos, textLength);
        return sb.toString();
    }

    public static void setEnumDocumentation(Configuration configuration, ClassDoc classDoc) {
        MethodDoc[] methods = classDoc.methods();
        for (int j = 0; j < methods.length; ++j) {
            Type paramType;
            MethodDoc currentMethod = methods[j];
            if (currentMethod.name().equals("values") && currentMethod.parameters().length == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(configuration.getText("doclet.enum_values_doc.main", classDoc.name()));
                sb.append("\n@return ");
                sb.append(configuration.getText("doclet.enum_values_doc.return"));
                currentMethod.setRawCommentText(sb.toString());
                continue;
            }
            if (!currentMethod.name().equals("valueOf") || currentMethod.parameters().length != 1 || (paramType = currentMethod.parameters()[0].type()) == null || !paramType.qualifiedTypeName().equals(String.class.getName())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(configuration.getText("doclet.enum_valueof_doc.main", classDoc.name()));
            sb.append("\n@param name ");
            sb.append(configuration.getText("doclet.enum_valueof_doc.param_name"));
            sb.append("\n@return ");
            sb.append(configuration.getText("doclet.enum_valueof_doc.return"));
            sb.append("\n@throws IllegalArgumentException ");
            sb.append(configuration.getText("doclet.enum_valueof_doc.throws_ila"));
            sb.append("\n@throws NullPointerException ");
            sb.append(configuration.getText("doclet.enum_valueof_doc.throws_npe"));
            currentMethod.setRawCommentText(sb.toString());
        }
    }

    public static boolean isDeprecated(Doc doc) {
        if (doc.tags("deprecated").length > 0) {
            return true;
        }
        AnnotationDesc[] annotationDescList = doc instanceof PackageDoc ? ((PackageDoc)doc).annotations() : ((ProgramElementDoc)doc).annotations();
        for (int i = 0; i < annotationDescList.length; ++i) {
            if (!annotationDescList[i].annotationType().qualifiedName().equals(Deprecated.class.getName())) continue;
            return true;
        }
        return false;
    }

    public static String propertyNameFromMethodName(Configuration configuration, String name) {
        String propertyName = null;
        if (name.startsWith("get") || name.startsWith("set")) {
            propertyName = name.substring(3);
        } else if (name.startsWith("is")) {
            propertyName = name.substring(2);
        }
        if (propertyName == null || propertyName.isEmpty()) {
            return "";
        }
        return propertyName.substring(0, 1).toLowerCase(configuration.getLocale()) + propertyName.substring(1);
    }

    public static ClassDoc[] filterOutPrivateClasses(ClassDoc[] classes, boolean javafx) {
        if (!javafx) {
            return classes;
        }
        ArrayList<ClassDoc> filteredOutClasses = new ArrayList<ClassDoc>(classes.length);
        for (ClassDoc classDoc : classes) {
            Tag[] aspTags;
            if (classDoc.isPrivate() || classDoc.isPackagePrivate() || (aspTags = classDoc.tags("treatAsPrivate")) != null && aspTags.length > 0) continue;
            filteredOutClasses.add(classDoc);
        }
        return filteredOutClasses.toArray(new ClassDoc[0]);
    }

    public static boolean isJava5DeclarationElementType(FieldDoc elt) {
        return elt.name().contentEquals(ElementType.ANNOTATION_TYPE.name()) || elt.name().contentEquals(ElementType.CONSTRUCTOR.name()) || elt.name().contentEquals(ElementType.FIELD.name()) || elt.name().contentEquals(ElementType.LOCAL_VARIABLE.name()) || elt.name().contentEquals(ElementType.METHOD.name()) || elt.name().contentEquals(ElementType.PACKAGE.name()) || elt.name().contentEquals(ElementType.PARAMETER.name()) || elt.name().contentEquals(ElementType.TYPE.name());
    }

    private static class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type type1, Type type2) {
            return type1.qualifiedTypeName().compareToIgnoreCase(type2.qualifiedTypeName());
        }
    }
}

