/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Group {
    private Map<String, String> regExpGroupMap = new HashMap<String, String>();
    private List<String> sortedRegExpList = new ArrayList<String>();
    private List<String> groupList = new ArrayList<String>();
    private Map<String, String> pkgNameGroupMap = new HashMap<String, String>();
    private final Configuration configuration;

    public Group(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean checkPackageGroups(String groupname, String pkgNameFormList) {
        StringTokenizer strtok = new StringTokenizer(pkgNameFormList, ":");
        if (this.groupList.contains(groupname)) {
            this.configuration.message.warning("doclet.Groupname_already_used", groupname);
            return false;
        }
        this.groupList.add(groupname);
        while (strtok.hasMoreTokens()) {
            String id = strtok.nextToken();
            if (id.length() == 0) {
                this.configuration.message.warning("doclet.Error_in_packagelist", groupname, pkgNameFormList);
                return false;
            }
            if (id.endsWith("*")) {
                if (this.foundGroupFormat(this.regExpGroupMap, id = id.substring(0, id.length() - 1))) {
                    return false;
                }
                this.regExpGroupMap.put(id, groupname);
                this.sortedRegExpList.add(id);
                continue;
            }
            if (this.foundGroupFormat(this.pkgNameGroupMap, id)) {
                return false;
            }
            this.pkgNameGroupMap.put(id, groupname);
        }
        Collections.sort(this.sortedRegExpList, new MapKeyComparator());
        return true;
    }

    boolean foundGroupFormat(Map<String, ?> map, String pkgFormat) {
        if (map.containsKey(pkgFormat)) {
            this.configuration.message.error("doclet.Same_package_name_used", pkgFormat);
            return true;
        }
        return false;
    }

    public Map<String, List<PackageDoc>> groupPackages(PackageDoc[] packages) {
        String defaultGroupName;
        HashMap<String, List<PackageDoc>> groupPackageMap = new HashMap<String, List<PackageDoc>>();
        String string = defaultGroupName = this.pkgNameGroupMap.isEmpty() && this.regExpGroupMap.isEmpty() ? this.configuration.message.getText("doclet.Packages", new Object[0]) : this.configuration.message.getText("doclet.Other_Packages", new Object[0]);
        if (!this.groupList.contains(defaultGroupName)) {
            this.groupList.add(defaultGroupName);
        }
        for (int i = 0; i < packages.length; ++i) {
            PackageDoc pkg = packages[i];
            String pkgName = pkg.name();
            String groupName = this.pkgNameGroupMap.get(pkgName);
            if (groupName == null) {
                groupName = this.regExpGroupName(pkgName);
            }
            if (groupName == null) {
                groupName = defaultGroupName;
            }
            this.getPkgList(groupPackageMap, groupName).add(pkg);
        }
        return groupPackageMap;
    }

    String regExpGroupName(String pkgName) {
        for (int j = 0; j < this.sortedRegExpList.size(); ++j) {
            String regexp = this.sortedRegExpList.get(j);
            if (!pkgName.startsWith(regexp)) continue;
            return this.regExpGroupMap.get(regexp);
        }
        return null;
    }

    List<PackageDoc> getPkgList(Map<String, List<PackageDoc>> map, String groupname) {
        List<PackageDoc> list = map.get(groupname);
        if (list == null) {
            list = new ArrayList<PackageDoc>();
            map.put(groupname, list);
        }
        return list;
    }

    public List<String> getGroupList() {
        return this.groupList;
    }

    private static class MapKeyComparator
    implements Comparator<String> {
        private MapKeyComparator() {
        }

        @Override
        public int compare(String key1, String key2) {
            return key2.length() - key1.length();
        }
    }
}

