/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ClassTree {
    private List<ClassDoc> baseclasses = new ArrayList<ClassDoc>();
    private Map<ClassDoc, List<ClassDoc>> subclasses = new HashMap<ClassDoc, List<ClassDoc>>();
    private List<ClassDoc> baseinterfaces = new ArrayList<ClassDoc>();
    private Map<ClassDoc, List<ClassDoc>> subinterfaces = new HashMap<ClassDoc, List<ClassDoc>>();
    private List<ClassDoc> baseEnums = new ArrayList<ClassDoc>();
    private Map<ClassDoc, List<ClassDoc>> subEnums = new HashMap<ClassDoc, List<ClassDoc>>();
    private List<ClassDoc> baseAnnotationTypes = new ArrayList<ClassDoc>();
    private Map<ClassDoc, List<ClassDoc>> subAnnotationTypes = new HashMap<ClassDoc, List<ClassDoc>>();
    private Map<ClassDoc, List<ClassDoc>> implementingclasses = new HashMap<ClassDoc, List<ClassDoc>>();

    public ClassTree(Configuration configuration, boolean noDeprecated) {
        configuration.message.notice("doclet.Building_Tree", new Object[0]);
        this.buildTree(configuration.root.classes(), configuration);
    }

    public ClassTree(RootDoc root, Configuration configuration) {
        this.buildTree(root.classes(), configuration);
    }

    public ClassTree(ClassDoc[] classes, Configuration configuration) {
        this.buildTree(classes, configuration);
    }

    private void buildTree(ClassDoc[] classes, Configuration configuration) {
        for (int i = 0; i < classes.length; ++i) {
            if (configuration.nodeprecated && (Util.isDeprecated((Doc)classes[i]) || Util.isDeprecated((Doc)classes[i].containingPackage())) || configuration.javafx && classes[i].tags("treatAsPrivate").length > 0) continue;
            if (classes[i].isEnum()) {
                this.processType(classes[i], configuration, this.baseEnums, this.subEnums);
                continue;
            }
            if (classes[i].isClass()) {
                this.processType(classes[i], configuration, this.baseclasses, this.subclasses);
                continue;
            }
            if (classes[i].isInterface()) {
                this.processInterface(classes[i]);
                List<ClassDoc> list = this.implementingclasses.get(classes[i]);
                if (list == null) continue;
                Collections.sort(list);
                continue;
            }
            if (!classes[i].isAnnotationType()) continue;
            this.processType(classes[i], configuration, this.baseAnnotationTypes, this.subAnnotationTypes);
        }
        Collections.sort(this.baseinterfaces);
        Iterator<List<ClassDoc>> it = this.subinterfaces.values().iterator();
        while (it.hasNext()) {
            Collections.sort(it.next());
        }
        it = this.subclasses.values().iterator();
        while (it.hasNext()) {
            Collections.sort(it.next());
        }
    }

    private void processType(ClassDoc cd, Configuration configuration, List<ClassDoc> bases, Map<ClassDoc, List<ClassDoc>> subs) {
        ClassDoc superclass = Util.getFirstVisibleSuperClassCD(cd, configuration);
        if (superclass != null) {
            if (!this.add(subs, superclass, cd)) {
                return;
            }
            this.processType(superclass, configuration, bases, subs);
        } else if (!bases.contains(cd)) {
            bases.add(cd);
        }
        List<Type> intfacs = Util.getAllInterfaces((Type)cd, configuration);
        Iterator<Type> iter = intfacs.iterator();
        while (iter.hasNext()) {
            this.add(this.implementingclasses, iter.next().asClassDoc(), cd);
        }
    }

    private void processInterface(ClassDoc cd) {
        ClassDoc[] intfacs = cd.interfaces();
        if (intfacs.length > 0) {
            for (int i = 0; i < intfacs.length; ++i) {
                if (!this.add(this.subinterfaces, intfacs[i], cd)) {
                    return;
                }
                this.processInterface(intfacs[i]);
            }
        } else if (!this.baseinterfaces.contains(cd)) {
            this.baseinterfaces.add(cd);
        }
    }

    private boolean add(Map<ClassDoc, List<ClassDoc>> map, ClassDoc superclass, ClassDoc cd) {
        List<ClassDoc> list = map.get(superclass);
        if (list == null) {
            list = new ArrayList<ClassDoc>();
            map.put(superclass, list);
        }
        if (list.contains(cd)) {
            return false;
        }
        list.add(cd);
        return true;
    }

    private List<ClassDoc> get(Map<ClassDoc, List<ClassDoc>> map, ClassDoc cd) {
        List<ClassDoc> list = map.get(cd);
        if (list == null) {
            return new ArrayList<ClassDoc>();
        }
        return list;
    }

    public List<ClassDoc> subclasses(ClassDoc cd) {
        return this.get(this.subclasses, cd);
    }

    public List<ClassDoc> subinterfaces(ClassDoc cd) {
        return this.get(this.subinterfaces, cd);
    }

    public List<ClassDoc> implementingclasses(ClassDoc cd) {
        List<ClassDoc> result = this.get(this.implementingclasses, cd);
        List<ClassDoc> subinterfaces = this.allSubs(cd, false);
        ListIterator<ClassDoc> subInterfacesIter = subinterfaces.listIterator();
        while (subInterfacesIter.hasNext()) {
            ListIterator<ClassDoc> implementingClassesIter = this.implementingclasses((ClassDoc)subInterfacesIter.next()).listIterator();
            while (implementingClassesIter.hasNext()) {
                ClassDoc c = (ClassDoc)implementingClassesIter.next();
                if (result.contains(c)) continue;
                result.add(c);
            }
        }
        Collections.sort(result);
        return result;
    }

    public List<ClassDoc> subs(ClassDoc cd, boolean isEnum) {
        if (isEnum) {
            return this.get(this.subEnums, cd);
        }
        if (cd.isAnnotationType()) {
            return this.get(this.subAnnotationTypes, cd);
        }
        if (cd.isInterface()) {
            return this.get(this.subinterfaces, cd);
        }
        if (cd.isClass()) {
            return this.get(this.subclasses, cd);
        }
        return null;
    }

    public List<ClassDoc> allSubs(ClassDoc cd, boolean isEnum) {
        List<ClassDoc> list = this.subs(cd, isEnum);
        for (int i = 0; i < list.size(); ++i) {
            cd = list.get(i);
            List<ClassDoc> tlist = this.subs(cd, isEnum);
            for (int j = 0; j < tlist.size(); ++j) {
                ClassDoc tcd = tlist.get(j);
                if (list.contains(tcd)) continue;
                list.add(tcd);
            }
        }
        Collections.sort(list);
        return list;
    }

    public List<ClassDoc> baseclasses() {
        return this.baseclasses;
    }

    public List<ClassDoc> baseinterfaces() {
        return this.baseinterfaces;
    }

    public List<ClassDoc> baseEnums() {
        return this.baseEnums;
    }

    public List<ClassDoc> baseAnnotationTypes() {
        return this.baseAnnotationTypes;
    }
}

