/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassDocCatalog {
    private Set<String> packageSet;
    private Map<String, Set<ClassDoc>> allClasses;
    private Map<String, Set<ClassDoc>> ordinaryClasses;
    private Map<String, Set<ClassDoc>> exceptions;
    private Map<String, Set<ClassDoc>> enums;
    private Map<String, Set<ClassDoc>> annotationTypes;
    private Map<String, Set<ClassDoc>> errors;
    private Map<String, Set<ClassDoc>> interfaces;
    private Configuration configuration;

    public ClassDocCatalog(ClassDoc[] classdocs, Configuration config) {
        this.init();
        this.configuration = config;
        for (int i = 0; i < classdocs.length; ++i) {
            this.addClassDoc(classdocs[i]);
        }
    }

    public ClassDocCatalog() {
        this.init();
    }

    private void init() {
        this.allClasses = new HashMap<String, Set<ClassDoc>>();
        this.ordinaryClasses = new HashMap<String, Set<ClassDoc>>();
        this.exceptions = new HashMap<String, Set<ClassDoc>>();
        this.enums = new HashMap<String, Set<ClassDoc>>();
        this.annotationTypes = new HashMap<String, Set<ClassDoc>>();
        this.errors = new HashMap<String, Set<ClassDoc>>();
        this.interfaces = new HashMap<String, Set<ClassDoc>>();
        this.packageSet = new HashSet<String>();
    }

    public void addClassDoc(ClassDoc classdoc) {
        if (classdoc == null) {
            return;
        }
        this.addClass(classdoc, this.allClasses);
        if (classdoc.isOrdinaryClass()) {
            this.addClass(classdoc, this.ordinaryClasses);
        } else if (classdoc.isException()) {
            this.addClass(classdoc, this.exceptions);
        } else if (classdoc.isEnum()) {
            this.addClass(classdoc, this.enums);
        } else if (classdoc.isAnnotationType()) {
            this.addClass(classdoc, this.annotationTypes);
        } else if (classdoc.isError()) {
            this.addClass(classdoc, this.errors);
        } else if (classdoc.isInterface()) {
            this.addClass(classdoc, this.interfaces);
        }
    }

    private void addClass(ClassDoc classdoc, Map<String, Set<ClassDoc>> map) {
        PackageDoc pkg = classdoc.containingPackage();
        if (pkg.isIncluded() || this.configuration.nodeprecated && Util.isDeprecated((Doc)pkg)) {
            return;
        }
        String key = Util.getPackageName(pkg);
        Set<ClassDoc> s = map.get(key);
        if (s == null) {
            this.packageSet.add(key);
            s = new HashSet<ClassDoc>();
        }
        s.add(classdoc);
        map.put(key, s);
    }

    private ClassDoc[] getArray(Map<String, Set<ClassDoc>> m, String key) {
        Set<ClassDoc> s = m.get(key);
        if (s == null) {
            return new ClassDoc[0];
        }
        return s.toArray(new ClassDoc[0]);
    }

    public ClassDoc[] allClasses(PackageDoc pkgDoc) {
        return pkgDoc.isIncluded() ? pkgDoc.allClasses() : this.getArray(this.allClasses, Util.getPackageName(pkgDoc));
    }

    public ClassDoc[] allClasses(String packageName) {
        return this.getArray(this.allClasses, packageName);
    }

    public String[] packageNames() {
        return this.packageSet.toArray(new String[0]);
    }

    public boolean isKnownPackage(String packageName) {
        return this.packageSet.contains(packageName);
    }

    public ClassDoc[] errors(String packageName) {
        return this.getArray(this.errors, packageName);
    }

    public ClassDoc[] exceptions(String packageName) {
        return this.getArray(this.exceptions, packageName);
    }

    public ClassDoc[] enums(String packageName) {
        return this.getArray(this.enums, packageName);
    }

    public ClassDoc[] annotationTypes(String packageName) {
        return this.getArray(this.annotationTypes, packageName);
    }

    public ClassDoc[] interfaces(String packageName) {
        return this.getArray(this.interfaces, packageName);
    }

    public ClassDoc[] ordinaryClasses(String packageName) {
        return this.getArray(this.ordinaryClasses, packageName);
    }
}

