/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.taglets;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.tools.javac.util.StringUtils;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.taglets.BaseTaglet;
import com.sun.tools.oldlets.internal.toolkit.taglets.InheritableTaglet;
import com.sun.tools.oldlets.internal.toolkit.taglets.TagletWriter;
import com.sun.tools.oldlets.internal.toolkit.util.DocFinder;

public class SimpleTaglet
extends BaseTaglet
implements InheritableTaglet {
    public static final String EXCLUDED = "x";
    public static final String PACKAGE = "p";
    public static final String TYPE = "t";
    public static final String CONSTRUCTOR = "c";
    public static final String FIELD = "f";
    public static final String METHOD = "m";
    public static final String OVERVIEW = "o";
    public static final String ALL = "a";
    protected String tagName;
    protected String header;
    protected String locations;

    public SimpleTaglet(String tagName, String header, String locations) {
        this.tagName = tagName;
        this.header = header;
        locations = StringUtils.toLowerCase(locations);
        this.locations = locations.indexOf(ALL) != -1 && locations.indexOf(EXCLUDED) == -1 ? "ptfmco" : locations;
    }

    @Override
    public String getName() {
        return this.tagName;
    }

    @Override
    public boolean inConstructor() {
        return this.locations.indexOf(CONSTRUCTOR) != -1 && this.locations.indexOf(EXCLUDED) == -1;
    }

    @Override
    public boolean inField() {
        return this.locations.indexOf(FIELD) != -1 && this.locations.indexOf(EXCLUDED) == -1;
    }

    @Override
    public boolean inMethod() {
        return this.locations.indexOf(METHOD) != -1 && this.locations.indexOf(EXCLUDED) == -1;
    }

    @Override
    public boolean inOverview() {
        return this.locations.indexOf(OVERVIEW) != -1 && this.locations.indexOf(EXCLUDED) == -1;
    }

    @Override
    public boolean inPackage() {
        return this.locations.indexOf(PACKAGE) != -1 && this.locations.indexOf(EXCLUDED) == -1;
    }

    @Override
    public boolean inType() {
        return this.locations.indexOf(TYPE) != -1 && this.locations.indexOf(EXCLUDED) == -1;
    }

    @Override
    public boolean isInlineTag() {
        return false;
    }

    @Override
    public void inherit(DocFinder.Input input, DocFinder.Output output) {
        Tag[] tags = input.element.tags(this.tagName);
        if (tags.length > 0) {
            output.holder = input.element;
            output.holderTag = tags[0];
            output.inlineTags = input.isFirstSentence ? tags[0].firstSentenceTags() : tags[0].inlineTags();
        }
    }

    @Override
    public Content getTagletOutput(Tag tag, TagletWriter writer) {
        return this.header == null || tag == null ? null : writer.simpleTagOutput(tag, this.header);
    }

    @Override
    public Content getTagletOutput(Doc holder, TagletWriter writer) {
        if (this.header == null || holder.tags(this.getName()).length == 0) {
            return null;
        }
        return writer.simpleTagOutput(holder.tags(this.getName()), this.header);
    }
}

