/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.ProfilePackageSummaryWriter;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;

public class ProfilePackageSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "PackageDoc";
    private final PackageDoc packageDoc;
    private final String profileName;
    private final int profileValue;
    private final ProfilePackageSummaryWriter profilePackageWriter;
    private Content contentTree;

    private ProfilePackageSummaryBuilder(AbstractBuilder.Context context, PackageDoc pkg, ProfilePackageSummaryWriter profilePackageWriter, Profile profile) {
        super(context);
        this.packageDoc = pkg;
        this.profilePackageWriter = profilePackageWriter;
        this.profileName = profile.name;
        this.profileValue = profile.value;
    }

    public static ProfilePackageSummaryBuilder getInstance(AbstractBuilder.Context context, PackageDoc pkg, ProfilePackageSummaryWriter profilePackageWriter, Profile profile) {
        return new ProfilePackageSummaryBuilder(context, pkg, profilePackageWriter, profile);
    }

    @Override
    public void build() throws IOException {
        if (this.profilePackageWriter == null) {
            return;
        }
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildPackageDoc(XMLNode node, Content contentTree) throws Exception {
        contentTree = this.profilePackageWriter.getPackageHeader(Util.getPackageName(this.packageDoc));
        this.buildChildren(node, contentTree);
        this.profilePackageWriter.addPackageFooter(contentTree);
        this.profilePackageWriter.printDocument(contentTree);
        this.profilePackageWriter.close();
        Util.copyDocFiles(this.configuration, this.packageDoc);
    }

    public void buildContent(XMLNode node, Content contentTree) {
        Content packageContentTree = this.profilePackageWriter.getContentHeader();
        this.buildChildren(node, packageContentTree);
        contentTree.addContent(packageContentTree);
    }

    public void buildSummary(XMLNode node, Content packageContentTree) {
        Content summaryContentTree = this.profilePackageWriter.getSummaryHeader();
        this.buildChildren(node, summaryContentTree);
        packageContentTree.addContent(summaryContentTree);
    }

    public void buildInterfaceSummary(XMLNode node, Content summaryContentTree) {
        ClassDoc[] interfaces;
        String interfaceTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Interface_Summary"), this.configuration.getText("doclet.interfaces"));
        String[] interfaceTableHeader = new String[]{this.configuration.getText("doclet.Interface"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = interfaces = this.packageDoc.isIncluded() ? this.packageDoc.interfaces() : this.configuration.classDocCatalog.interfaces(Util.getPackageName(this.packageDoc));
        if (interfaces.length > 0) {
            this.profilePackageWriter.addClassesSummary(interfaces, this.configuration.getText("doclet.Interface_Summary"), interfaceTableSummary, interfaceTableHeader, summaryContentTree);
        }
    }

    public void buildClassSummary(XMLNode node, Content summaryContentTree) {
        ClassDoc[] classes;
        String classTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Class_Summary"), this.configuration.getText("doclet.classes"));
        String[] classTableHeader = new String[]{this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = classes = this.packageDoc.isIncluded() ? this.packageDoc.ordinaryClasses() : this.configuration.classDocCatalog.ordinaryClasses(Util.getPackageName(this.packageDoc));
        if (classes.length > 0) {
            this.profilePackageWriter.addClassesSummary(classes, this.configuration.getText("doclet.Class_Summary"), classTableSummary, classTableHeader, summaryContentTree);
        }
    }

    public void buildEnumSummary(XMLNode node, Content summaryContentTree) {
        ClassDoc[] enums;
        String enumTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Enum_Summary"), this.configuration.getText("doclet.enums"));
        String[] enumTableHeader = new String[]{this.configuration.getText("doclet.Enum"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = enums = this.packageDoc.isIncluded() ? this.packageDoc.enums() : this.configuration.classDocCatalog.enums(Util.getPackageName(this.packageDoc));
        if (enums.length > 0) {
            this.profilePackageWriter.addClassesSummary(enums, this.configuration.getText("doclet.Enum_Summary"), enumTableSummary, enumTableHeader, summaryContentTree);
        }
    }

    public void buildExceptionSummary(XMLNode node, Content summaryContentTree) {
        ClassDoc[] exceptions;
        String exceptionTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Exception_Summary"), this.configuration.getText("doclet.exceptions"));
        String[] exceptionTableHeader = new String[]{this.configuration.getText("doclet.Exception"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = exceptions = this.packageDoc.isIncluded() ? this.packageDoc.exceptions() : this.configuration.classDocCatalog.exceptions(Util.getPackageName(this.packageDoc));
        if (exceptions.length > 0) {
            this.profilePackageWriter.addClassesSummary(exceptions, this.configuration.getText("doclet.Exception_Summary"), exceptionTableSummary, exceptionTableHeader, summaryContentTree);
        }
    }

    public void buildErrorSummary(XMLNode node, Content summaryContentTree) {
        ClassDoc[] errors;
        String errorTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Error_Summary"), this.configuration.getText("doclet.errors"));
        String[] errorTableHeader = new String[]{this.configuration.getText("doclet.Error"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = errors = this.packageDoc.isIncluded() ? this.packageDoc.errors() : this.configuration.classDocCatalog.errors(Util.getPackageName(this.packageDoc));
        if (errors.length > 0) {
            this.profilePackageWriter.addClassesSummary(errors, this.configuration.getText("doclet.Error_Summary"), errorTableSummary, errorTableHeader, summaryContentTree);
        }
    }

    public void buildAnnotationTypeSummary(XMLNode node, Content summaryContentTree) {
        AnnotationTypeDoc[] annotationTypes;
        String annotationtypeTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Annotation_Types_Summary"), this.configuration.getText("doclet.annotationtypes"));
        String[] annotationtypeTableHeader = new String[]{this.configuration.getText("doclet.AnnotationType"), this.configuration.getText("doclet.Description")};
        Object[] objectArray = annotationTypes = this.packageDoc.isIncluded() ? this.packageDoc.annotationTypes() : this.configuration.classDocCatalog.annotationTypes(Util.getPackageName(this.packageDoc));
        if (annotationTypes.length > 0) {
            this.profilePackageWriter.addClassesSummary((ClassDoc[])annotationTypes, this.configuration.getText("doclet.Annotation_Types_Summary"), annotationtypeTableSummary, annotationtypeTableHeader, summaryContentTree);
        }
    }

    public void buildPackageDescription(XMLNode node, Content packageContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        this.profilePackageWriter.addPackageDescription(packageContentTree);
    }

    public void buildPackageTags(XMLNode node, Content packageContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        this.profilePackageWriter.addPackageTags(packageContentTree);
    }
}

