/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.internal.toolkit.ClassWriter;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.builders.XMLNode;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;

public class ClassBuilder
extends AbstractBuilder {
    public static final String ROOT = "ClassDoc";
    private final ClassDoc classDoc;
    private final ClassWriter writer;
    private final boolean isInterface;
    private final boolean isEnum;
    private Content contentTree;

    private ClassBuilder(AbstractBuilder.Context context, ClassDoc classDoc, ClassWriter writer) {
        super(context);
        this.classDoc = classDoc;
        this.writer = writer;
        if (classDoc.isInterface()) {
            this.isInterface = true;
            this.isEnum = false;
        } else if (classDoc.isEnum()) {
            this.isInterface = false;
            this.isEnum = true;
            Util.setEnumDocumentation(this.configuration, classDoc);
        } else {
            this.isInterface = false;
            this.isEnum = false;
        }
    }

    public static ClassBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, ClassWriter writer) {
        return new ClassBuilder(context, classDoc, writer);
    }

    @Override
    public void build() throws IOException {
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildClassDoc(XMLNode node, Content contentTree) throws Exception {
        String key = this.isInterface ? "doclet.Interface" : (this.isEnum ? "doclet.Enum" : "doclet.Class");
        contentTree = this.writer.getHeader(this.configuration.getText(key) + " " + this.classDoc.name());
        Content classContentTree = this.writer.getClassContentHeader();
        this.buildChildren(node, classContentTree);
        contentTree.addContent(classContentTree);
        this.writer.addFooter(contentTree);
        this.writer.printDocument(contentTree);
        this.writer.close();
        this.copyDocFiles();
    }

    public void buildClassTree(XMLNode node, Content classContentTree) {
        this.writer.addClassTree(classContentTree);
    }

    public void buildClassInfo(XMLNode node, Content classContentTree) {
        Content classInfoTree = this.writer.getClassInfoTreeHeader();
        this.buildChildren(node, classInfoTree);
        classContentTree.addContent(this.writer.getClassInfo(classInfoTree));
    }

    public void buildTypeParamInfo(XMLNode node, Content classInfoTree) {
        this.writer.addTypeParamInfo(classInfoTree);
    }

    public void buildSuperInterfacesInfo(XMLNode node, Content classInfoTree) {
        this.writer.addSuperInterfacesInfo(classInfoTree);
    }

    public void buildImplementedInterfacesInfo(XMLNode node, Content classInfoTree) {
        this.writer.addImplementedInterfacesInfo(classInfoTree);
    }

    public void buildSubClassInfo(XMLNode node, Content classInfoTree) {
        this.writer.addSubClassInfo(classInfoTree);
    }

    public void buildSubInterfacesInfo(XMLNode node, Content classInfoTree) {
        this.writer.addSubInterfacesInfo(classInfoTree);
    }

    public void buildInterfaceUsageInfo(XMLNode node, Content classInfoTree) {
        this.writer.addInterfaceUsageInfo(classInfoTree);
    }

    public void buildFunctionalInterfaceInfo(XMLNode node, Content classInfoTree) {
        this.writer.addFunctionalInterfaceInfo(classInfoTree);
    }

    public void buildDeprecationInfo(XMLNode node, Content classInfoTree) {
        this.writer.addClassDeprecationInfo(classInfoTree);
    }

    public void buildNestedClassInfo(XMLNode node, Content classInfoTree) {
        this.writer.addNestedClassInfo(classInfoTree);
    }

    private void copyDocFiles() {
        PackageDoc containingPackage = this.classDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, containingPackage) >= 0 || this.containingPackagesSeen.contains(containingPackage.name()))) {
            Util.copyDocFiles(this.configuration, containingPackage);
            this.containingPackagesSeen.add(containingPackage.name());
        }
    }

    public void buildClassSignature(XMLNode node, Content classInfoTree) {
        StringBuilder modifiers;
        modifiers.append((modifiers = new StringBuilder(this.classDoc.modifiers())).length() == 0 ? "" : " ");
        if (this.isEnum) {
            modifiers.append("enum ");
            int index = modifiers.indexOf("abstract");
            if (index >= 0) {
                modifiers.delete(index, index + "abstract".length());
                modifiers = new StringBuilder(Util.replaceText(modifiers.toString(), "  ", " "));
            }
            if ((index = modifiers.indexOf("final")) >= 0) {
                modifiers.delete(index, index + "final".length());
                modifiers = new StringBuilder(Util.replaceText(modifiers.toString(), "  ", " "));
            }
        } else if (!this.isInterface) {
            modifiers.append("class ");
        }
        this.writer.addClassSignature(modifiers.toString(), classInfoTree);
    }

    public void buildClassDescription(XMLNode node, Content classInfoTree) {
        this.writer.addClassDescription(classInfoTree);
    }

    public void buildClassTagInfo(XMLNode node, Content classInfoTree) {
        this.writer.addClassTagInfo(classInfoTree);
    }

    public void buildMemberSummary(XMLNode node, Content classContentTree) throws Exception {
        Content memberSummaryTree = this.writer.getMemberTreeHeader();
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).buildChildren(node, memberSummaryTree);
        classContentTree.addContent(this.writer.getMemberSummaryTree(memberSummaryTree));
    }

    public void buildMemberDetails(XMLNode node, Content classContentTree) {
        Content memberDetailsTree = this.writer.getMemberTreeHeader();
        this.buildChildren(node, memberDetailsTree);
        classContentTree.addContent(this.writer.getMemberDetailsTree(memberDetailsTree));
    }

    public void buildEnumConstantsDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getEnumConstantsBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildFieldDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getFieldBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildPropertyDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getPropertyBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildConstructorDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getConstructorBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildMethodDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getMethodBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }
}

