/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.formats.html.AbstractPackageIndexWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.SectionName;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PackageIndexWriter
extends AbstractPackageIndexWriter {
    private RootDoc root;
    private Map<String, List<PackageDoc>> groupPackageMap;
    private List<String> groupList;

    public PackageIndexWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
        this.root = configuration.root;
        this.groupPackageMap = configuration.group.groupPackages(this.packages);
        this.groupList = configuration.group.getGroupList();
    }

    public static void generate(ConfigurationImpl configuration) {
        DocPath filename = DocPaths.OVERVIEW_SUMMARY;
        try {
            PackageIndexWriter packgen = new PackageIndexWriter(configuration, filename);
            packgen.buildPackageIndexFile("doclet.Window_Overview_Summary", true);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    @Override
    protected void addIndex(Content body) {
        for (int i = 0; i < this.groupList.size(); ++i) {
            String groupname = this.groupList.get(i);
            List<PackageDoc> list = this.groupPackageMap.get(groupname);
            if (list == null || list.size() <= 0) continue;
            this.addIndexContents(list.toArray(new PackageDoc[list.size()]), groupname, this.configuration.getText("doclet.Member_Table_Summary", groupname, this.configuration.getText("doclet.packages")), body);
        }
    }

    @Override
    protected void addProfilesList(Content profileSummary, Content body) {
        HtmlTree h2 = HtmlTree.HEADING(HtmlTag.H2, profileSummary);
        HtmlTree profilesDiv = HtmlTree.DIV(h2);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        for (int i = 1; i < this.configuration.profiles.getProfileCount(); ++i) {
            String profileName = Profile.lookup((int)i).name;
            if (!this.configuration.shouldDocumentProfile(profileName)) continue;
            Content profileLinkContent = this.getTargetProfileLink("classFrame", new StringContent(profileName), profileName);
            HtmlTree li = HtmlTree.LI(profileLinkContent);
            ((Content)ul).addContent(li);
        }
        ((Content)profilesDiv).addContent(ul);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.contentContainer, profilesDiv);
        body.addContent(div);
    }

    @Override
    protected void addPackagesList(PackageDoc[] packages, String text, String tableSummary, Content body) {
        HtmlTree table = HtmlTree.TABLE(HtmlStyle.overviewSummary, 0, 3, 0, tableSummary, this.getTableCaption(new RawHtml(text)));
        ((Content)table).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
        this.addPackagesList(packages, tbody);
        ((Content)table).addContent(tbody);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.contentContainer, table);
        body.addContent(div);
    }

    protected void addPackagesList(PackageDoc[] packages, Content tbody) {
        for (int i = 0; i < packages.length; ++i) {
            if (packages[i] == null || packages[i].name().length() <= 0 || this.configuration.nodeprecated && Util.isDeprecated((Doc)packages[i])) continue;
            Content packageLinkContent = this.getPackageLink(packages[i], this.getPackageName(packages[i]));
            HtmlTree tdPackage = HtmlTree.TD(HtmlStyle.colFirst, packageLinkContent);
            HtmlTree tdSummary = new HtmlTree(HtmlTag.TD);
            tdSummary.addStyle(HtmlStyle.colLast);
            this.addSummaryComment((Doc)packages[i], tdSummary);
            HtmlTree tr = HtmlTree.TR(tdPackage);
            tr.addContent(tdSummary);
            if (i % 2 == 0) {
                tr.addStyle(HtmlStyle.altColor);
            } else {
                tr.addStyle(HtmlStyle.rowColor);
            }
            tbody.addContent(tr);
        }
    }

    @Override
    protected void addOverviewHeader(Content body) {
        if (this.root.inlineTags().length > 0) {
            HtmlTree subTitleDiv = new HtmlTree(HtmlTag.DIV);
            subTitleDiv.addStyle(HtmlStyle.subTitle);
            this.addSummaryComment((Doc)this.root, subTitleDiv);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.header, subTitleDiv);
            Content see = this.seeLabel;
            see.addContent(" ");
            HtmlTree descPara = HtmlTree.P(see);
            Content descLink = this.getHyperLink(this.getDocLink(SectionName.OVERVIEW_DESCRIPTION), this.descriptionLabel, "", "");
            ((Content)descPara).addContent(descLink);
            ((Content)div).addContent(descPara);
            body.addContent(div);
        }
    }

    protected void addOverviewComment(Content htmltree) {
        if (this.root.inlineTags().length > 0) {
            htmltree.addContent(this.getMarkerAnchor(SectionName.OVERVIEW_DESCRIPTION));
            this.addInlineComment((Doc)this.root, htmltree);
        }
    }

    @Override
    protected void addOverview(Content body) throws IOException {
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        this.addOverviewComment(div);
        this.addTagsInfo((Doc)this.root, div);
        body.addContent(div);
    }

    @Override
    protected void addNavigationBarHeader(Content body) {
        this.addTop(body);
        this.addNavLinks(true, body);
        this.addConfigurationTitle(body);
    }

    @Override
    protected void addNavigationBarFooter(Content body) {
        this.addNavLinks(false, body);
        this.addBottom(body);
    }
}

