/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.StringContent;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PackageFrameWriter
extends HtmlDocletWriter {
    private PackageDoc packageDoc;
    private Set<ClassDoc> documentedClasses;

    public PackageFrameWriter(ConfigurationImpl configuration, PackageDoc packageDoc) throws IOException {
        super(configuration, DocPath.forPackage(packageDoc).resolve(DocPaths.PACKAGE_FRAME));
        this.packageDoc = packageDoc;
        if (configuration.root.specifiedPackages().length == 0) {
            this.documentedClasses = new HashSet<ClassDoc>(Arrays.asList(configuration.root.classes()));
        }
    }

    public static void generate(ConfigurationImpl configuration, PackageDoc packageDoc) {
        try {
            PackageFrameWriter packgen = new PackageFrameWriter(configuration, packageDoc);
            String pkgName = Util.getPackageName(packageDoc);
            HtmlTree body = packgen.getBody(false, packgen.getWindowTitle(pkgName));
            StringContent pkgNameContent = new StringContent(pkgName);
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, packgen.getTargetPackageLink(packageDoc, "classFrame", pkgNameContent));
            ((Content)body).addContent(heading);
            HtmlTree div = new HtmlTree(HtmlTag.DIV);
            div.addStyle(HtmlStyle.indexContainer);
            packgen.addClassListing(div);
            ((Content)body).addContent(div);
            packgen.printHtmlDocument(configuration.metakeywords.getMetaKeywords(packageDoc), false, body);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), DocPaths.PACKAGE_FRAME.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void addClassListing(Content contentTree) {
        ConfigurationImpl config = this.configuration;
        if (this.packageDoc.isIncluded()) {
            this.addClassKindListing(this.packageDoc.interfaces(), this.getResource("doclet.Interfaces"), contentTree);
            this.addClassKindListing(this.packageDoc.ordinaryClasses(), this.getResource("doclet.Classes"), contentTree);
            this.addClassKindListing(this.packageDoc.enums(), this.getResource("doclet.Enums"), contentTree);
            this.addClassKindListing(this.packageDoc.exceptions(), this.getResource("doclet.Exceptions"), contentTree);
            this.addClassKindListing(this.packageDoc.errors(), this.getResource("doclet.Errors"), contentTree);
            this.addClassKindListing((ClassDoc[])this.packageDoc.annotationTypes(), this.getResource("doclet.AnnotationTypes"), contentTree);
        } else {
            String name = Util.getPackageName(this.packageDoc);
            this.addClassKindListing(config.classDocCatalog.interfaces(name), this.getResource("doclet.Interfaces"), contentTree);
            this.addClassKindListing(config.classDocCatalog.ordinaryClasses(name), this.getResource("doclet.Classes"), contentTree);
            this.addClassKindListing(config.classDocCatalog.enums(name), this.getResource("doclet.Enums"), contentTree);
            this.addClassKindListing(config.classDocCatalog.exceptions(name), this.getResource("doclet.Exceptions"), contentTree);
            this.addClassKindListing(config.classDocCatalog.errors(name), this.getResource("doclet.Errors"), contentTree);
            this.addClassKindListing(config.classDocCatalog.annotationTypes(name), this.getResource("doclet.AnnotationTypes"), contentTree);
        }
    }

    protected void addClassKindListing(ClassDoc[] arr, Content labelContent, Content contentTree) {
        if ((arr = Util.filterOutPrivateClasses(arr, this.configuration.javafx)).length > 0) {
            Arrays.sort(arr);
            boolean printedHeader = false;
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            ul.setTitle(labelContent);
            for (int i = 0; i < arr.length; ++i) {
                if (this.documentedClasses != null && !this.documentedClasses.contains(arr[i]) || !Util.isCoreClass(arr[i]) || !this.configuration.isGeneratedDoc(arr[i])) continue;
                if (!printedHeader) {
                    HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, labelContent);
                    contentTree.addContent(heading);
                    printedHeader = true;
                }
                Content arr_i_name = new StringContent(arr[i].name());
                if (arr[i].isInterface()) {
                    arr_i_name = HtmlTree.SPAN(HtmlStyle.interfaceName, arr_i_name);
                }
                Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE_FRAME, arr[i]).label(arr_i_name).target("classFrame"));
                HtmlTree li = HtmlTree.LI(link);
                ul.addContent(li);
            }
            contentTree.addContent(ul);
        }
    }
}

