/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.oldlets.formats.html.AllClassesFrameWriter;
import com.sun.tools.oldlets.formats.html.ClassUseWriter;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.DeprecatedListWriter;
import com.sun.tools.oldlets.formats.html.FrameOutputWriter;
import com.sun.tools.oldlets.formats.html.HelpWriter;
import com.sun.tools.oldlets.formats.html.PackageFrameWriter;
import com.sun.tools.oldlets.formats.html.PackageIndexFrameWriter;
import com.sun.tools.oldlets.formats.html.PackageIndexWriter;
import com.sun.tools.oldlets.formats.html.PackageTreeWriter;
import com.sun.tools.oldlets.formats.html.ProfileIndexFrameWriter;
import com.sun.tools.oldlets.formats.html.ProfilePackageFrameWriter;
import com.sun.tools.oldlets.formats.html.ProfilePackageIndexFrameWriter;
import com.sun.tools.oldlets.formats.html.SingleIndexWriter;
import com.sun.tools.oldlets.formats.html.SourceToHTMLConverter;
import com.sun.tools.oldlets.formats.html.SplitIndexWriter;
import com.sun.tools.oldlets.formats.html.TreeWriter;
import com.sun.tools.oldlets.internal.toolkit.AbstractDoclet;
import com.sun.tools.oldlets.internal.toolkit.Configuration;
import com.sun.tools.oldlets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.oldlets.internal.toolkit.util.ClassTree;
import com.sun.tools.oldlets.internal.toolkit.util.DocFile;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.oldlets.internal.toolkit.util.FatalError;
import com.sun.tools.oldlets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;

public class HtmlDoclet
extends AbstractDoclet {
    private static HtmlDoclet docletToStart = null;
    public final ConfigurationImpl configuration = new ConfigurationImpl();
    public static final ConfigurationImpl sharedInstanceForOptions = new ConfigurationImpl();

    public static boolean start(RootDoc root) {
        HtmlDoclet doclet;
        if (docletToStart != null) {
            doclet = docletToStart;
            docletToStart = null;
        } else {
            doclet = new HtmlDoclet();
        }
        return doclet.start(doclet, root);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    protected void generateOtherFiles(RootDoc root, ClassTree classtree) throws Exception {
        DocFile f;
        super.generateOtherFiles(root, classtree);
        if (this.configuration.linksource) {
            SourceToHTMLConverter.convertRoot(this.configuration, root, DocPaths.SOURCE_OUTPUT);
        }
        if (this.configuration.topFile.isEmpty()) {
            this.configuration.standardmessage.error("doclet.No_Non_Deprecated_Classes_To_Document", new Object[0]);
            return;
        }
        boolean nodeprecated = this.configuration.nodeprecated;
        this.performCopy(this.configuration.helpfile);
        this.performCopy(this.configuration.stylesheetfile);
        if (this.configuration.classuse) {
            ClassUseWriter.generate(this.configuration, classtree);
        }
        IndexBuilder indexbuilder = new IndexBuilder(this.configuration, nodeprecated);
        if (this.configuration.createtree) {
            TreeWriter.generate(this.configuration, classtree);
        }
        if (this.configuration.createindex) {
            if (this.configuration.splitindex) {
                SplitIndexWriter.generate(this.configuration, indexbuilder);
            } else {
                SingleIndexWriter.generate(this.configuration, indexbuilder);
            }
        }
        if (!this.configuration.nodeprecatedlist && !nodeprecated) {
            DeprecatedListWriter.generate(this.configuration);
        }
        AllClassesFrameWriter.generate(this.configuration, new IndexBuilder(this.configuration, nodeprecated, true));
        FrameOutputWriter.generate(this.configuration);
        if (this.configuration.createoverview) {
            PackageIndexWriter.generate(this.configuration);
        }
        if (this.configuration.helpfile.length() == 0 && !this.configuration.nohelp) {
            HelpWriter.generate(this.configuration);
        }
        if (this.configuration.stylesheetfile.length() == 0) {
            f = DocFile.createFileForOutput(this.configuration, DocPaths.STYLESHEET);
            f.copyResource(DocPaths.RESOURCES.resolve(DocPaths.STYLESHEET), false, true);
        }
        f = DocFile.createFileForOutput(this.configuration, DocPaths.JAVASCRIPT);
        f.copyResource(DocPaths.RESOURCES.resolve(DocPaths.JAVASCRIPT), true, true);
    }

    @Override
    protected void generateClassFiles(ClassDoc[] arr, ClassTree classtree) {
        Arrays.sort(arr);
        for (int i = 0; i < arr.length; ++i) {
            if (!this.configuration.isGeneratedDoc(arr[i]) || !arr[i].isIncluded()) continue;
            ClassDoc prev = i == 0 ? null : arr[i - 1];
            ClassDoc curr = arr[i];
            ClassDoc next = i + 1 == arr.length ? null : arr[i + 1];
            try {
                if (curr.isAnnotationType()) {
                    AbstractBuilder annotationTypeBuilder = this.configuration.getBuilderFactory().getAnnotationTypeBuilder((AnnotationTypeDoc)curr, (Type)prev, (Type)next);
                    annotationTypeBuilder.build();
                    continue;
                }
                AbstractBuilder classBuilder = this.configuration.getBuilderFactory().getClassBuilder(curr, prev, next, classtree);
                classBuilder.build();
                continue;
            }
            catch (IOException e) {
                throw new DocletAbortException(e);
            }
            catch (FatalError fe) {
                throw fe;
            }
            catch (DocletAbortException de) {
                throw de;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DocletAbortException(e);
            }
        }
    }

    @Override
    protected void generateProfileFiles() throws Exception {
        if (this.configuration.showProfiles && this.configuration.profilePackages.size() > 0) {
            ProfileIndexFrameWriter.generate(this.configuration);
            Profile prevProfile = null;
            for (int i = 1; i < this.configuration.profiles.getProfileCount(); ++i) {
                String profileName = Profile.lookup((int)i).name;
                if (!this.configuration.shouldDocumentProfile(profileName)) continue;
                ProfilePackageIndexFrameWriter.generate(this.configuration, profileName);
                PackageDoc[] packages = (PackageDoc[])this.configuration.profilePackages.get(profileName);
                PackageDoc prev = null;
                for (int j = 0; j < packages.length; ++j) {
                    if (this.configuration.nodeprecated && Util.isDeprecated((Doc)packages[j])) continue;
                    ProfilePackageFrameWriter.generate(this.configuration, packages[j], i);
                    PackageDoc next = j + 1 < packages.length && packages[j + 1].name().length() > 0 ? packages[j + 1] : null;
                    AbstractBuilder profilePackageSummaryBuilder = this.configuration.getBuilderFactory().getProfilePackageSummaryBuilder(packages[j], prev, next, Profile.lookup(i));
                    profilePackageSummaryBuilder.build();
                    prev = packages[j];
                }
                Profile nextProfile = i + 1 < this.configuration.profiles.getProfileCount() ? Profile.lookup(i + 1) : null;
                AbstractBuilder profileSummaryBuilder = this.configuration.getBuilderFactory().getProfileSummaryBuilder(Profile.lookup(i), prevProfile, nextProfile);
                profileSummaryBuilder.build();
                prevProfile = Profile.lookup(i);
            }
        }
    }

    @Override
    protected void generatePackageFiles(ClassTree classtree) throws Exception {
        PackageDoc[] packages = this.configuration.packages;
        if (packages.length > 1) {
            PackageIndexFrameWriter.generate(this.configuration);
        }
        PackageDoc prev = null;
        for (int i = 0; i < packages.length; ++i) {
            if (this.configuration.nodeprecated && Util.isDeprecated((Doc)packages[i])) continue;
            PackageFrameWriter.generate(this.configuration, packages[i]);
            PackageDoc next = i + 1 < packages.length && packages[i + 1].name().length() > 0 ? packages[i + 1] : null;
            next = i + 2 < packages.length && next == null ? packages[i + 2] : next;
            AbstractBuilder packageSummaryBuilder = this.configuration.getBuilderFactory().getPackageSummaryBuilder(packages[i], prev, next);
            packageSummaryBuilder.build();
            if (this.configuration.createtree) {
                PackageTreeWriter.generate(this.configuration, packages[i], prev, next, this.configuration.nodeprecated);
            }
            prev = packages[i];
        }
    }

    public static int optionLength(String option) {
        return sharedInstanceForOptions.optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        docletToStart = new HtmlDoclet();
        return HtmlDoclet.docletToStart.configuration.validOptions(options, reporter);
    }

    private void performCopy(String filename) {
        if (filename.isEmpty()) {
            return;
        }
        try {
            DocFile fromfile = DocFile.createFileForInput(this.configuration, filename);
            DocPath path = DocPath.create(fromfile.getName());
            DocFile toFile = DocFile.createFileForOutput(this.configuration, path);
            if (toFile.isSameFile(fromfile)) {
                return;
            }
            this.configuration.message.notice((SourcePosition)null, "doclet.Copying_File_0_To_File_1", fromfile.toString(), path.getPath());
            toFile.copyFile(fromfile);
        }
        catch (IOException exc) {
            this.configuration.message.error((SourcePosition)null, "doclet.perform_copy_exception_encountered", exc.toString());
            throw new DocletAbortException(exc);
        }
    }
}

