/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.tools.oldlets.formats.html.AbstractMemberWriter;
import com.sun.tools.oldlets.formats.html.AnnotationTypeOptionalMemberWriterImpl;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.ConstructorWriterImpl;
import com.sun.tools.oldlets.formats.html.EnumConstantWriterImpl;
import com.sun.tools.oldlets.formats.html.FieldWriterImpl;
import com.sun.tools.oldlets.formats.html.MethodWriterImpl;
import com.sun.tools.oldlets.formats.html.NestedClassWriterImpl;
import com.sun.tools.oldlets.formats.html.SubWriterHolderWriter;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DeprecatedAPIListBuilder;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.DocPaths;
import com.sun.tools.oldlets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;

public class DeprecatedListWriter
extends SubWriterHolderWriter {
    private static final String[] ANCHORS = new String[]{"package", "interface", "class", "enum", "exception", "error", "annotation.type", "field", "method", "constructor", "enum.constant", "annotation.type.member"};
    private static final String[] HEADING_KEYS = new String[]{"doclet.Deprecated_Packages", "doclet.Deprecated_Interfaces", "doclet.Deprecated_Classes", "doclet.Deprecated_Enums", "doclet.Deprecated_Exceptions", "doclet.Deprecated_Errors", "doclet.Deprecated_Annotation_Types", "doclet.Deprecated_Fields", "doclet.Deprecated_Methods", "doclet.Deprecated_Constructors", "doclet.Deprecated_Enum_Constants", "doclet.Deprecated_Annotation_Type_Members"};
    private static final String[] SUMMARY_KEYS = new String[]{"doclet.deprecated_packages", "doclet.deprecated_interfaces", "doclet.deprecated_classes", "doclet.deprecated_enums", "doclet.deprecated_exceptions", "doclet.deprecated_errors", "doclet.deprecated_annotation_types", "doclet.deprecated_fields", "doclet.deprecated_methods", "doclet.deprecated_constructors", "doclet.deprecated_enum_constants", "doclet.deprecated_annotation_type_members"};
    private static final String[] HEADER_KEYS = new String[]{"doclet.Package", "doclet.Interface", "doclet.Class", "doclet.Enum", "doclet.Exceptions", "doclet.Errors", "doclet.AnnotationType", "doclet.Field", "doclet.Method", "doclet.Constructor", "doclet.Enum_Constant", "doclet.Annotation_Type_Member"};
    private AbstractMemberWriter[] writers;
    private ConfigurationImpl configuration;

    public DeprecatedListWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
        this.configuration = configuration;
        NestedClassWriterImpl classW = new NestedClassWriterImpl(this);
        this.writers = new AbstractMemberWriter[]{classW, classW, classW, classW, classW, classW, new FieldWriterImpl(this), new MethodWriterImpl(this), new ConstructorWriterImpl(this), new EnumConstantWriterImpl(this), new AnnotationTypeOptionalMemberWriterImpl((SubWriterHolderWriter)this, null)};
    }

    public static void generate(ConfigurationImpl configuration) {
        DocPath filename = DocPaths.DEPRECATED_LIST;
        try {
            DeprecatedListWriter depr = new DeprecatedListWriter(configuration, filename);
            depr.generateDeprecatedListFile(new DeprecatedAPIListBuilder(configuration));
            depr.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    protected void generateDeprecatedListFile(DeprecatedAPIListBuilder deprapi) throws IOException {
        Content body = this.getHeader();
        body.addContent(this.getContentsList(deprapi));
        String[] memberTableHeader = new String[1];
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        for (int i = 0; i < 12; ++i) {
            if (!deprapi.hasDocumentation(i)) continue;
            this.addAnchor(deprapi, i, div);
            String memberTableSummary = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText(HEADING_KEYS[i]), this.configuration.getText(SUMMARY_KEYS[i]));
            memberTableHeader[0] = this.configuration.getText("doclet.0_and_1", this.configuration.getText(HEADER_KEYS[i]), this.configuration.getText("doclet.Description"));
            if (i == 0) {
                this.addPackageDeprecatedAPI(deprapi.getList(i), HEADING_KEYS[i], memberTableSummary, memberTableHeader, div);
                continue;
            }
            this.writers[i - 1].addDeprecatedAPI(deprapi.getList(i), HEADING_KEYS[i], memberTableSummary, memberTableHeader, div);
        }
        body.addContent(div);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    private void addIndexLink(DeprecatedAPIListBuilder builder, int type, Content contentTree) {
        if (builder.hasDocumentation(type)) {
            HtmlTree li = HtmlTree.LI(this.getHyperLink(ANCHORS[type], this.getResource(HEADING_KEYS[type])));
            contentTree.addContent(li);
        }
    }

    public Content getContentsList(DeprecatedAPIListBuilder deprapi) {
        Content headContent = this.getResource("doclet.Deprecated_API");
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        Content headingContent = this.getResource("doclet.Contents");
        ((Content)div).addContent(HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, headingContent));
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        for (int i = 0; i < 12; ++i) {
            this.addIndexLink(deprapi, i, ul);
        }
        ((Content)div).addContent(ul);
        return div;
    }

    private void addAnchor(DeprecatedAPIListBuilder builder, int type, Content htmlTree) {
        if (builder.hasDocumentation(type)) {
            htmlTree.addContent(this.getMarkerAnchor(ANCHORS[type]));
        }
    }

    public Content getHeader() {
        String title = this.configuration.getText("doclet.Window_Deprecated_List");
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        this.addTop(bodyTree);
        this.addNavLinks(true, bodyTree);
        return bodyTree;
    }

    @Override
    protected Content getNavLinkDeprecated() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.deprecatedLabel);
        return li;
    }
}

