/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.markup.HtmlAttr;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.ClassTree;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import com.sun.tools.oldlets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTreeWriter
extends HtmlDocletWriter {
    protected final ClassTree classtree;
    private static final String LI_CIRCLE = "circle";

    protected AbstractTreeWriter(ConfigurationImpl configuration, DocPath filename, ClassTree classtree) throws IOException {
        super(configuration, filename);
        this.classtree = classtree;
    }

    protected void addLevelInfo(ClassDoc parent, List<ClassDoc> list, boolean isEnum, Content contentTree) {
        int size = list.size();
        if (size > 0) {
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            for (int i = 0; i < size; ++i) {
                ClassDoc local = list.get(i);
                HtmlTree li = new HtmlTree(HtmlTag.LI);
                li.addAttr(HtmlAttr.TYPE, LI_CIRCLE);
                this.addPartialInfo(local, li);
                this.addExtendsImplements(parent, local, li);
                this.addLevelInfo(local, this.classtree.subs(local, isEnum), isEnum, li);
                ((Content)ul).addContent(li);
            }
            contentTree.addContent(ul);
        }
    }

    protected void addTree(List<ClassDoc> list, String heading, Content div) {
        if (list.size() > 0) {
            ClassDoc firstClassDoc = list.get(0);
            Content headingContent = this.getResource(heading);
            div.addContent(HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, headingContent));
            this.addLevelInfo((ClassDoc)(!firstClassDoc.isInterface() ? firstClassDoc : null), list, list == this.classtree.baseEnums(), div);
        }
    }

    protected void addExtendsImplements(ClassDoc parent, ClassDoc cd, Content contentTree) {
        Object[] interfaces = cd.interfaces();
        if (interfaces.length > (cd.isInterface() ? 1 : 0)) {
            Arrays.sort(interfaces);
            int counter = 0;
            for (int i = 0; i < interfaces.length; ++i) {
                if (parent == interfaces[i] || !interfaces[i].isPublic() && !Util.isLinkable((ClassDoc)interfaces[i], this.configuration)) continue;
                if (counter == 0) {
                    if (cd.isInterface()) {
                        contentTree.addContent(" (");
                        contentTree.addContent(this.getResource("doclet.also"));
                        contentTree.addContent(" extends ");
                    } else {
                        contentTree.addContent(" (implements ");
                    }
                } else {
                    contentTree.addContent(", ");
                }
                this.addPreQualifiedClassLink(LinkInfoImpl.Kind.TREE, (ClassDoc)interfaces[i], contentTree);
                ++counter;
            }
            if (counter > 0) {
                contentTree.addContent(")");
            }
        }
    }

    protected void addPartialInfo(ClassDoc cd, Content contentTree) {
        this.addPreQualifiedStrongClassLink(LinkInfoImpl.Kind.TREE, cd, contentTree);
    }

    @Override
    protected Content getNavLinkTree() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.treeLabel);
        return li;
    }
}

