/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.oldlets.formats.html.ConfigurationImpl;
import com.sun.tools.oldlets.formats.html.HtmlDocletWriter;
import com.sun.tools.oldlets.formats.html.markup.HtmlConstants;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTag;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.formats.html.markup.RawHtml;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocPath;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractPackageIndexWriter
extends HtmlDocletWriter {
    protected PackageDoc[] packages;

    public AbstractPackageIndexWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
        this.packages = configuration.packages;
    }

    protected abstract void addNavigationBarHeader(Content var1);

    protected abstract void addNavigationBarFooter(Content var1);

    protected abstract void addOverviewHeader(Content var1);

    protected abstract void addPackagesList(PackageDoc[] var1, String var2, String var3, Content var4);

    protected void buildPackageIndexFile(String title, boolean includeScript) throws IOException {
        String windowOverview = this.configuration.getText(title);
        HtmlTree body = this.getBody(includeScript, this.getWindowTitle(windowOverview));
        this.addNavigationBarHeader(body);
        this.addOverviewHeader(body);
        this.addIndex(body);
        this.addOverview(body);
        this.addNavigationBarFooter(body);
        this.printHtmlDocument(this.configuration.metakeywords.getOverviewMetaKeywords(title, this.configuration.doctitle), includeScript, body);
    }

    protected void addOverview(Content body) throws IOException {
    }

    protected void addIndex(Content body) {
        this.addIndexContents(this.packages, "doclet.Package_Summary", this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Package_Summary"), this.configuration.getText("doclet.packages")), body);
    }

    protected void addIndexContents(PackageDoc[] packages, String text, String tableSummary, Content body) {
        if (packages.length > 0) {
            Arrays.sort(packages);
            HtmlTree div = new HtmlTree(HtmlTag.DIV);
            div.addStyle(HtmlStyle.indexHeader);
            this.addAllClassesLink(div);
            if (this.configuration.showProfiles) {
                this.addAllProfilesLink(div);
            }
            body.addContent(div);
            if (this.configuration.showProfiles && this.configuration.profilePackages.size() > 0) {
                Content profileSummary = this.configuration.getResource("doclet.Profiles");
                this.addProfilesList(profileSummary, body);
            }
            this.addPackagesList(packages, text, tableSummary, body);
        }
    }

    protected void addConfigurationTitle(Content body) {
        if (this.configuration.doctitle.length() > 0) {
            RawHtml title = new RawHtml(this.configuration.doctitle);
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.title, (Content)title);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
            body.addContent(div);
        }
    }

    @Override
    protected Content getNavLinkContents() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.overviewLabel);
        return li;
    }

    protected void addAllClassesLink(Content div) {
    }

    protected void addAllProfilesLink(Content div) {
    }

    protected void addProfilesList(Content profileSummary, Content body) {
    }
}

