/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.oldlets.formats.html;

import com.sun.javadoc.AnnotatedType;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import com.sun.tools.oldlets.formats.html.AbstractMemberWriter;
import com.sun.tools.oldlets.formats.html.LinkInfoImpl;
import com.sun.tools.oldlets.formats.html.SubWriterHolderWriter;
import com.sun.tools.oldlets.formats.html.markup.HtmlStyle;
import com.sun.tools.oldlets.formats.html.markup.HtmlTree;
import com.sun.tools.oldlets.internal.toolkit.Content;
import com.sun.tools.oldlets.internal.toolkit.util.DocletConstants;

public abstract class AbstractExecutableMemberWriter
extends AbstractMemberWriter {
    public AbstractExecutableMemberWriter(SubWriterHolderWriter writer, ClassDoc classdoc) {
        super(writer, classdoc);
    }

    public AbstractExecutableMemberWriter(SubWriterHolderWriter writer) {
        super(writer);
    }

    protected void addTypeParameters(ExecutableMemberDoc member, Content htmltree) {
        Content typeParameters = this.getTypeParameters(member);
        if (!typeParameters.isEmpty()) {
            htmltree.addContent(typeParameters);
            htmltree.addContent(this.writer.getSpace());
        }
    }

    protected Content getTypeParameters(ExecutableMemberDoc member) {
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER_TYPE_PARAMS, member);
        return this.writer.getTypeParameterLinks(linkInfo);
    }

    @Override
    protected Content getDeprecatedLink(ProgramElementDoc member) {
        ExecutableMemberDoc emd = (ExecutableMemberDoc)member;
        return this.writer.getDocLink(LinkInfoImpl.Kind.MEMBER, (MemberDoc)emd, emd.qualifiedName() + emd.flatSignature());
    }

    @Override
    protected void addSummaryLink(LinkInfoImpl.Kind context, ClassDoc cd, ProgramElementDoc member, Content tdSummary) {
        ExecutableMemberDoc emd = (ExecutableMemberDoc)member;
        String name = emd.name();
        HtmlTree memberLink = HtmlTree.SPAN(HtmlStyle.memberNameLink, this.writer.getDocLink(context, cd, (MemberDoc)emd, name, false));
        HtmlTree code = HtmlTree.CODE(memberLink);
        this.addParameters(emd, false, code, name.length() - 1);
        tdSummary.addContent(code);
    }

    @Override
    protected void addInheritedSummaryLink(ClassDoc cd, ProgramElementDoc member, Content linksTree) {
        linksTree.addContent(this.writer.getDocLink(LinkInfoImpl.Kind.MEMBER, cd, (MemberDoc)member, member.name(), false));
    }

    protected void addParam(ExecutableMemberDoc member, Parameter param, boolean isVarArg, Content tree) {
        if (param.type() != null) {
            Content link = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.EXECUTABLE_MEMBER_PARAM, param.type()).varargs(isVarArg));
            tree.addContent(link);
        }
        if (param.name().length() > 0) {
            tree.addContent(this.writer.getSpace());
            tree.addContent(param.name());
        }
    }

    protected void addReceiverAnnotations(ExecutableMemberDoc member, Type rcvrType, AnnotationDesc[] descList, Content tree) {
        this.writer.addReceiverAnnotationInfo(member, descList, tree);
        tree.addContent(this.writer.getSpace());
        tree.addContent(rcvrType.typeName());
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_SIGNATURE, rcvrType);
        tree.addContent(this.writer.getTypeParameterLinks(linkInfo));
        tree.addContent(this.writer.getSpace());
        tree.addContent("this");
    }

    protected void addParameters(ExecutableMemberDoc member, Content htmltree, int indentSize) {
        this.addParameters(member, true, htmltree, indentSize);
    }

    protected void addParameters(ExecutableMemberDoc member, boolean includeAnnotations, Content htmltree, int indentSize) {
        boolean foundAnnotations;
        AnnotationDesc[] descList;
        htmltree.addContent("(");
        String sep = "";
        Parameter[] params = member.parameters();
        String indent = this.makeSpace(indentSize + 1);
        Type rcvrType = member.receiverType();
        if (includeAnnotations && rcvrType instanceof AnnotatedType && (descList = rcvrType.asAnnotatedType().annotations()).length > 0) {
            this.addReceiverAnnotations(member, rcvrType, descList, htmltree);
            sep = "," + DocletConstants.NL + indent;
        }
        for (int paramstart = 0; paramstart < params.length; ++paramstart) {
            htmltree.addContent(sep);
            Parameter param = params[paramstart];
            if (param.name().startsWith("this$")) continue;
            if (includeAnnotations && (foundAnnotations = this.writer.addAnnotationInfo(indent.length(), (Doc)member, param, htmltree))) {
                htmltree.addContent(DocletConstants.NL);
                htmltree.addContent(indent);
            }
            this.addParam(member, param, paramstart == params.length - 1 && member.isVarArgs(), htmltree);
            break;
        }
        for (int i = paramstart + 1; i < params.length; ++i) {
            htmltree.addContent(",");
            htmltree.addContent(DocletConstants.NL);
            htmltree.addContent(indent);
            if (includeAnnotations && (foundAnnotations = this.writer.addAnnotationInfo(indent.length(), (Doc)member, params[i], htmltree))) {
                htmltree.addContent(DocletConstants.NL);
                htmltree.addContent(indent);
            }
            this.addParam(member, params[i], i == params.length - 1 && member.isVarArgs(), htmltree);
        }
        htmltree.addContent(")");
    }

    protected void addExceptions(ExecutableMemberDoc member, Content htmltree, int indentSize) {
        Type[] exceptions = member.thrownExceptionTypes();
        if (exceptions.length > 0) {
            LinkInfoImpl memberTypeParam = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, member);
            String indent = this.makeSpace(indentSize + 1 - 7);
            htmltree.addContent(DocletConstants.NL);
            htmltree.addContent(indent);
            htmltree.addContent("throws ");
            indent = this.makeSpace(indentSize + 1);
            Content link = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, exceptions[0]));
            htmltree.addContent(link);
            for (int i = 1; i < exceptions.length; ++i) {
                htmltree.addContent(",");
                htmltree.addContent(DocletConstants.NL);
                htmltree.addContent(indent);
                Content exceptionLink = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, exceptions[i]));
                htmltree.addContent(exceptionLink);
            }
        }
    }

    protected ClassDoc implementsMethodInIntfac(MethodDoc method, ClassDoc[] intfacs) {
        for (int i = 0; i < intfacs.length; ++i) {
            MethodDoc[] methods = intfacs[i].methods();
            if (methods.length <= 0) continue;
            for (int j = 0; j < methods.length; ++j) {
                if (!methods[j].name().equals(method.name()) || !methods[j].signature().equals(method.signature())) continue;
                return intfacs[i];
            }
        }
        return null;
    }

    protected String getErasureAnchor(ExecutableMemberDoc emd) {
        StringBuilder buf = new StringBuilder(emd.name() + "(");
        Parameter[] params = emd.parameters();
        boolean foundTypeVariable = false;
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            Type t = params[i].type();
            foundTypeVariable = foundTypeVariable || t.asTypeVariable() != null;
            buf.append(t.isPrimitive() ? t.typeName() : t.asClassDoc().qualifiedName());
            buf.append(t.dimension());
        }
        buf.append(")");
        return foundTypeVariable ? this.writer.getName(buf.toString()) : null;
    }
}

