/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.aot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public final class UtilAsm {
    private UtilAsm() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> findMainClass(File jarOrDir) throws IOException {
        Iterable<Path> roots;
        final TreeSet<String> classes = new TreeSet<String>();
        if (jarOrDir.isDirectory()) {
            roots = Collections.singleton(jarOrDir.toPath());
        } else {
            FileSystem fs;
            try (JarFile jf2222 = new JarFile(jarOrDir);){
                Attributes attr = jf2222.getManifest().getMainAttributes();
                String mc = attr.getValue("Main-Class");
                if (mc != null) {
                    classes.add(mc);
                    TreeSet<String> treeSet = classes;
                    return treeSet;
                }
            }
            catch (IOException jf2222) {
                // empty catch block
            }
            try {
                fs = FileSystems.newFileSystem(new URI("jar:" + jarOrDir.toURI()), new HashMap(), null);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
            roots = fs.getRootDirectories();
        }
        Iterator iterator = roots.iterator();
        while (iterator.hasNext()) {
            Path r = (Path)iterator.next();
            Files.walkFileTree(r, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    UtilAsm.visitFile(file, classes);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return classes;
    }

    private static void visitFile(Path file, final Set<String> classes) throws IOException {
        if (!file.getFileName().toString().endsWith(".class")) {
            return;
        }
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            ClassReader r = new ClassReader(is);
            r.accept(new ClassVisitor(589824){
                private String name;

                public void visit(int i, int i1, String jvmName, String string1, String string2, String[] strings) {
                    this.name = jvmName.replace('/', '.');
                }

                public void visitSource(String string, String string1) {
                }

                public void visitOuterClass(String string, String string1, String string2) {
                }

                public AnnotationVisitor visitAnnotation(String string, boolean bln) {
                    return null;
                }

                public void visitAttribute(Attribute atrbt) {
                }

                public void visitInnerClass(String string, String string1, String string2, int i) {
                }

                public FieldVisitor visitField(int i, String string, String string1, String string2, Object o) {
                    return null;
                }

                public MethodVisitor visitMethod(int mod, String methodName, String signature, String string2, String[] strings) {
                    if (this.name != null && "main".equals(methodName) && "([Ljava/lang/String;)V".equals(signature)) {
                        classes.add(this.name);
                    }
                    return null;
                }

                public void visitEnd() {
                }
            }, 52);
        }
    }
}

