/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.aot;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apidesign.bck2brwsr.aot.FastJar;
import org.apidesign.vm4brwsr.Bck2Brwsr;

public final class Bck2BrwsrJars {
    private static final Logger LOG = Logger.getLogger(Bck2BrwsrJars.class.getName());

    private Bck2BrwsrJars() {
    }

    public static Bck2Brwsr configureFrom(Bck2Brwsr c, File jar) throws IOException {
        return Bck2BrwsrJars.configureFrom(c, jar, null);
    }

    public static Bck2Brwsr configureFrom(Bck2Brwsr c, File jar, ClassLoader classpath) throws IOException {
        return Bck2BrwsrJars.configureFrom(c, jar, classpath, true);
    }

    public static Bck2Brwsr configureFrom(Bck2Brwsr c, final File jar, final ClassLoader classpath, final boolean ignoreBootClassPath) throws IOException {
        String mainClass;
        Manifest manifest;
        if (jar.isDirectory()) {
            return Bck2BrwsrJars.configureDir(ignoreBootClassPath, c, jar, classpath);
        }
        final Iterable<? extends FastJar.Entry> entries = FastJar.list(jar);
        final ArrayList classes = new ArrayList();
        ArrayList<String> resources = new ArrayList<String>();
        HashSet<String> exported = new HashSet<String>();
        class JarRes
        extends EmulationResources
        implements Bck2Brwsr.Resources {
            JarRes() {
                super(bl, classLoader, list);
            }

            @Override
            public InputStream get(String resource) throws IOException {
                InputStream is = this.getConverted(resource);
                if (is != null) {
                    return is;
                }
                if (resource.startsWith("/")) {
                    resource = resource.substring(1);
                }
                for (FastJar.Entry e : entries) {
                    if (!resource.equals(e.name)) continue;
                    is = FastJar.getInputStream(jar, e);
                    break;
                }
                return is == null ? super.get(resource) : is;
            }
        }
        JarRes jarRes = new JarRes();
        try (JarInputStream is = new JarInputStream((InputStream)new FileInputStream(jar), false);){
            manifest = is.getManifest();
        }
        Bck2BrwsrJars.listJAR(jar, manifest, entries, jarRes, resources, exported);
        Attributes mainAttributes = manifest == null ? null : manifest.getMainAttributes();
        String cp = mainAttributes == null ? null : mainAttributes.getValue("Class-Path");
        String[] parts = cp == null ? null : cp.split(" ");
        String string = mainClass = mainAttributes == null ? null : mainAttributes.getValue("Main-Class");
        if (mainClass != null) {
            exported.add(mainClass.replace('.', '/'));
        }
        if (c == null) {
            c = Bck2Brwsr.newCompiler();
        }
        return c.library(parts).addClasses(classes.toArray(new String[classes.size()])).addExported(exported.toArray(new String[exported.size()])).addResources(resources.toArray(new String[resources.size()])).resources((Bck2Brwsr.Resources)jarRes);
    }

    private static void listJAR(File jar, Manifest manifest, Iterable<? extends FastJar.Entry> entries, EmulationResources classes, List<String> resources, Set<String> keep) throws IOException {
        HashSet<String> packages = new HashSet<String>();
        for (FastJar.Entry entry : entries) {
            String l;
            String n = entry.name;
            if (n.endsWith("/") || n.startsWith("META-INF/maven/") || n.equals("module-info.class") || n.startsWith("META-INF/versions/") && n.endsWith("/module-info.class")) continue;
            int last = n.lastIndexOf(47);
            String pkg = n.substring(0, last + 1);
            if (pkg.isEmpty()) {
                pkg = "/";
            }
            packages.add(pkg);
            if (pkg.startsWith("java/") && keep != null) {
                keep.add(pkg);
            }
            if (n.endsWith(".class")) {
                classes.addClassResource(n);
                continue;
            }
            resources.add(n);
            if (!n.startsWith("META-INF/services/") || keep == null) continue;
            BufferedReader r = new BufferedReader(new InputStreamReader(FastJar.getInputStream(jar, entry)));
            while ((l = r.readLine()) != null) {
                if (l.startsWith("#")) continue;
                keep.add(l.replace('.', '/'));
            }
            r.close();
        }
        if (keep != null) {
            Attributes attributes;
            boolean exported = false;
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                exported = Bck2BrwsrJars.exportPublicPackages(attributes, keep);
            }
            if (!exported) {
                keep.addAll(packages);
            }
        }
    }

    static boolean exportPublicPackages(Attributes mainAttr, Set<String> keep) {
        String exp = mainAttr.getValue("Export-Package");
        if (exp != null) {
            String[] stringArray = exp.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = 0;
                String def = stringArray[i];
                String[] stringArray2 = def.split(";");
                int n3 = stringArray2.length;
                if (n2 >= n3) continue;
                String sep = stringArray2[n2];
                keep.add(sep.replace('.', '/') + "/");
            }
            return true;
        }
        exp = mainAttr.getValue("OpenIDE-Module-Public-Packages");
        if (exp != null) {
            for (String def : exp.split(",")) {
                if (!(def = def.trim()).endsWith(".*")) continue;
                keep.add(def.substring(0, def.length() - 1).replace('.', '/'));
            }
            return true;
        }
        return false;
    }

    static byte[] readFrom(InputStream is) throws IOException {
        int read;
        int expLen = is.available();
        if (expLen < 1) {
            expLen = 1;
        }
        byte[] arr = new byte[expLen];
        int pos = 0;
        while ((read = is.read(arr, pos, arr.length - pos)) != -1) {
            if ((pos += read) != arr.length) continue;
            byte[] tmp = new byte[arr.length * 2];
            System.arraycopy(arr, 0, tmp, 0, arr.length);
            arr = tmp;
        }
        if (pos != arr.length) {
            byte[] tmp = new byte[pos];
            System.arraycopy(arr, 0, tmp, 0, pos);
            arr = tmp;
        }
        return arr;
    }

    private static Bck2Brwsr configureDir(final boolean ignoreBootClassPath, Bck2Brwsr c, final File dir, ClassLoader cp) throws IOException {
        ArrayList<String> arr = new ArrayList<String>();
        ArrayList classes = new ArrayList();
        class DirRes
        extends EmulationResources {
            public DirRes(ClassLoader cp, List<String> classes) {
                super(n != 0, cp, classes);
            }

            @Override
            public InputStream get(String name) throws IOException {
                InputStream is = super.get(name);
                if (is != null) {
                    return is;
                }
                File r = new File(dir, name.replace('/', File.separatorChar));
                if (r.exists()) {
                    return new FileInputStream(r);
                }
                return null;
            }
        }
        DirRes dirRes = new DirRes(cp, classes);
        Bck2BrwsrJars.listDir(dir, null, dirRes, arr);
        if (c == null) {
            c = Bck2Brwsr.newCompiler();
        }
        return c.addRootClasses(classes.toArray(new String[0])).addResources(arr.toArray(new String[0])).library(new String[0]).resources((Bck2Brwsr.Resources)dirRes);
    }

    private static void listDir(File f, String pref, EmulationResources res, List<String> resources) throws IOException {
        File[] arr = f.listFiles();
        if (arr == null) {
            if (f.getName().endsWith(".class")) {
                res.addClassResource(pref + f.getName());
            } else {
                resources.add(pref + f.getName());
            }
        } else {
            for (File ch : arr) {
                Bck2BrwsrJars.listDir(ch, pref == null ? "" : pref + f.getName() + "/", res, resources);
            }
        }
    }

    static class EmulationResources
    implements Bck2Brwsr.Resources {
        private final List<String> classes;
        private final Map<String, byte[]> converted = new HashMap<String, byte[]>();
        private final ClassLoader cp;
        private final boolean ignoreBootClassPath;

        protected EmulationResources(boolean ignoreBootClassPath, ClassLoader cp, List<String> classes) {
            this.ignoreBootClassPath = ignoreBootClassPath;
            this.classes = classes;
            this.cp = cp != null ? cp : Bck2BrwsrJars.class.getClassLoader();
        }

        protected final InputStream getConverted(String name) throws IOException {
            byte[] arr = this.converted.get(name);
            if (arr != null) {
                return new ByteArrayInputStream(arr);
            }
            return null;
        }

        public InputStream get(String name) throws IOException {
            InputStream is = this.getConverted(name);
            if (is != null) {
                return is;
            }
            return this.getFromCp(name);
        }

        private InputStream getFromCp(String name) throws IOException {
            Enumeration<URL> en = this.cp.getResources(name);
            URL u = null;
            while (en.hasMoreElements()) {
                u = en.nextElement();
            }
            if (u == null) {
                LOG.log(Level.FINE, "Cannot find {0}", name);
                return null;
            }
            if (this.ignoreBootClassPath && u.toExternalForm().contains("/rt.jar!")) {
                LOG.log(Level.CONFIG, "No bootdelegation for {0}", name);
                return null;
            }
            try {
                return u.openStream();
            }
            catch (FileNotFoundException ex) {
                URLConnection c = u.openConnection();
                c.setDefaultUseCaches(false);
                if (c instanceof JarURLConnection) {
                    c.setUseCaches(false);
                }
                return c.getInputStream();
            }
        }

        final void addClassResource(String n) throws IOException {
            this.classes.add(n.substring(0, n.length() - 6));
        }

        private final class NoConvRes
        implements Bck2Brwsr.Resources {
            private NoConvRes() {
            }

            public InputStream get(String resource) throws IOException {
                return EmulationResources.this.getFromCp(resource);
            }
        }
    }
}

