/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.resources;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public final class RestResourceUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestResourceUtils.class);
    private static ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules().configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);

    public static ResponseEntity<String> createResponseEntityForAuthnFailure(AuthenticationException e) {
        try {
            List authnExceptions = e.getHandlerErrors().values().stream().map(ex -> ex.getClass().getSimpleName() + ": " + (String)StringUtils.defaultIfBlank((CharSequence)ex.getMessage(), (CharSequence)("Authentication Failure: " + e.getMessage()))).collect(Collectors.toList());
            HashMap errorsMap = new HashMap();
            errorsMap.put("authentication_exceptions", authnExceptions);
            LOGGER.warn("[{}] Caused by: [{}]", (Object)e.getMessage(), authnExceptions);
            return new ResponseEntity((Object)MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(errorsMap), HttpStatus.UNAUTHORIZED);
        }
        catch (JsonProcessingException exception) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Generated
    private RestResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

