/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.resources;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.rest.factory.ServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="serviceTicketResourceRestController")
public class ServiceTicketResource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTicketResource.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final TicketRegistrySupport ticketRegistrySupport;
    private final ArgumentExtractor argumentExtractor;
    private final ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/v1/tickets/{tgtId:.+}"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createServiceTicket(HttpServletRequest httpServletRequest, @PathVariable(value="tgtId") String tgtId) {
        try {
            Authentication authn = this.ticketRegistrySupport.getAuthenticationFrom(tgtId);
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authn);
            if (authn == null) {
                throw new InvalidTicketException(tgtId);
            }
            DefaultAuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder();
            WebApplicationService service = this.argumentExtractor.extractService(httpServletRequest);
            if (service == null) {
                throw new IllegalArgumentException("Target service/application is unspecified or unrecognized in the request");
            }
            AuthenticationResult authenticationResult = builder.collect(authn).build(this.authenticationSystemSupport.getPrincipalElectionStrategy(), (Service)service);
            ResponseEntity responseEntity = this.serviceTicketResourceEntityResponseFactory.build(tgtId, (Service)service, authenticationResult);
            return responseEntity;
        }
        catch (InvalidTicketException e) {
            ResponseEntity responseEntity = new ResponseEntity((Object)(tgtId + " could not be found or is considered invalid"), HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseEntity responseEntity = new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            return responseEntity;
        }
        finally {
            AuthenticationCredentialsThreadLocalBinder.clear();
        }
    }

    @Generated
    public ServiceTicketResource(AuthenticationSystemSupport authenticationSystemSupport, TicketRegistrySupport ticketRegistrySupport, ArgumentExtractor argumentExtractor, ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.argumentExtractor = argumentExtractor;
        this.serviceTicketResourceEntityResponseFactory = serviceTicketResourceEntityResponseFactory;
    }
}

